/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.module;

import com.vwp.sound.mod.modplay.module.Track;

public class Pattern {
    private Track[] tracks;
    private int divisions;

    public Pattern(Track[] tracks, int divisions) {
        this.tracks = tracks;
        this.divisions = divisions;
    }

    public Track getTrack(int n) {
        if (n >= this.tracks.length || n < 0) {
            return null;
        }
        return this.tracks[n];
    }

    public int getTrackCount() {
        return this.tracks.length;
    }

    public int getDivisions() {
        return this.divisions;
    }

    public String getCode(int division) {
        StringBuffer sb = new StringBuffer();
        int m = 0;
        while (m < this.tracks.length) {
            sb.append(String.valueOf(this.tracks[m].getInfo(division)) + " ");
            ++m;
        }
        return sb.toString();
    }

    public String getInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("#tracks: " + this.tracks.length + " #divisions:" + this.divisions + "\n");
        int n = 0;
        while (n < this.divisions) {
            int m = 0;
            while (m < this.tracks.length) {
                sb.append(String.valueOf(this.tracks[m].getInfo(n)) + " ");
                ++m;
            }
            sb.append("\n");
            ++n;
        }
        sb.append("\n");
        return sb.toString();
    }
}

