/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.loader;

import com.vwp.sound.mod.modplay.loader.ITLoader;
import com.vwp.sound.mod.modplay.loader.InvalidFormatException;
import com.vwp.sound.mod.modplay.loader.ModLoader;
import com.vwp.sound.mod.modplay.loader.S3MLoader;
import com.vwp.sound.mod.modplay.loader.STMLoader;
import com.vwp.sound.mod.modplay.loader.XMLoader;
import com.vwp.sound.mod.modplay.loader.ZippedModuleLoader;
import com.vwp.sound.mod.modplay.module.Module;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public abstract class ModuleLoader {
    public static final int UNKNOWN = 0;
    public static final int MOD = 1;
    public static final int XM = 2;
    public static final int S3M = 3;
    public static final int STM = 4;
    public static final int IT = 5;
    public static final int ZIP = 6;
    protected static final String EXT_MOD = ".mod";
    protected static final String EXT_XM = ".xm";
    protected static final String EXT_S3M = ".s3m";
    protected static final String EXT_STM = ".stm";
    protected static final String EXT_IT = ".it";
    protected static final String EXT_ZIP = ".zip";

    public static ModuleLoader getModuleLoader(int type, String name, File modFile) throws InvalidFormatException, IOException {
        return ModuleLoader.getModuleLoader(type, name, ModuleLoader.getData(modFile));
    }

    public static ModuleLoader getModuleLoader(int type, String name, URL modURL) throws InvalidFormatException, IOException {
        return ModuleLoader.getModuleLoader(type, name, ModuleLoader.getData(modURL));
    }

    public static ModuleLoader getModuleLoader(URL modURL) throws InvalidFormatException, IOException {
        return ModuleLoader.getModuleLoader(ModuleLoader.getType(modURL.toExternalForm()), modURL.toExternalForm(), ModuleLoader.getData(modURL));
    }

    public static ModuleLoader getModuleLoader(File modFile) throws InvalidFormatException, IOException {
        return ModuleLoader.getModuleLoader(ModuleLoader.getType(modFile.getAbsolutePath()), modFile.getAbsolutePath(), ModuleLoader.getData(modFile));
    }

    public static ModuleLoader getModuleLoader(InputStream in, String modFile) throws InvalidFormatException, IOException {
        return ModuleLoader.getModuleLoader(ModuleLoader.getType(modFile), modFile, ModuleLoader.getData(in));
    }

    public static ModuleLoader getModuleLoader(String name, byte[] data) throws InvalidFormatException, IOException {
        return ModuleLoader.getModuleLoader(ModuleLoader.getType(name), name, data);
    }

    public static ModuleLoader getModuleLoader(int type, String name, byte[] data) throws InvalidFormatException, IOException {
        switch (type) {
            case 1: {
                return new ModLoader(name, data);
            }
            case 3: {
                return new S3MLoader(name, data);
            }
            case 4: {
                return new STMLoader(name, data);
            }
            case 2: {
                return new XMLoader(name, data);
            }
            case 5: {
                return new ITLoader(name, data);
            }
            case 6: {
                return new ZippedModuleLoader(name, data);
            }
        }
        return null;
    }

    private static int getType(String modName) {
        if (modName.toLowerCase().endsWith(EXT_MOD)) {
            return 1;
        }
        if (modName.toLowerCase().endsWith(EXT_S3M)) {
            return 3;
        }
        if (modName.toLowerCase().endsWith(EXT_XM)) {
            return 2;
        }
        if (modName.toLowerCase().endsWith(EXT_STM)) {
            return 4;
        }
        if (modName.toLowerCase().endsWith(EXT_IT)) {
            return 5;
        }
        if (modName.toLowerCase().endsWith(EXT_ZIP)) {
            return 6;
        }
        return 0;
    }

    private static byte[] getData(URL url) throws IOException {
        return ModuleLoader.getData(url.openStream());
    }

    private static byte[] getData(File file) throws IOException {
        if (!file.exists() || !file.isFile()) {
            throw new IOException("No such file: " + file.getAbsolutePath());
        }
        return ModuleLoader.getData(new FileInputStream(file));
    }

    protected static byte[] getData(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] data = new byte[102400];
        int len = -1;
        while ((len = in.read(data)) != -1) {
            baos.write(data, 0, len);
        }
        baos.flush();
        return baos.toByteArray();
    }

    public abstract Module getModule();

    protected static void skip(DataInputStream dis, int len) throws IOException {
        int l = len;
        while ((l = (int)((long)l - dis.skip(l))) > 0) {
        }
    }
}

