/*
 * Decompiled with CFR 0.152.
 */
package de.gulden.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class Toolbox {
    public static final int NORTH = 1;
    public static final int EAST = 2;
    public static final int SOUTH = 4;
    public static final int WEST = 8;
    public static final int NORTH_EAST = 3;
    public static final int SOUTH_EAST = 6;
    public static final int SOUTH_WEST = 12;
    public static final int NORTH_WEST = 9;
    public static final int CENTER = 0;
    public static final String NL = System.getProperty("line.separator");
    private static final Object[][] primitiveTypeWrappers = new Object[][]{{"boolean", "byte", "short", "int", "long", "float", "double", "char"}, {Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class}};

    public static Class getPrimitiveTypeWrapperClass(String typename) throws ClassNotFoundException {
        int i = Toolbox.getPrimitiveTypeIndex(typename);
        if (i != -1) {
            return (Class)primitiveTypeWrappers[1][i];
        }
        throw new ClassNotFoundException("'" + typename + "' is not a primitive type");
    }

    public static Class getPrimitiveTypeClass(String typename) throws ClassNotFoundException {
        Class wrapper = Toolbox.getPrimitiveTypeWrapperClass(typename);
        try {
            Field field = wrapper.getField("TYPE");
            Class primitiveClass = (Class)field.get(null);
            return primitiveClass;
        }
        catch (Exception e) {
            throw new ClassNotFoundException("wrapper for '" + typename + "' has no TYPE field");
        }
    }

    public static boolean isPrimitiveType(String typename) {
        return Toolbox.getPrimitiveTypeIndex(typename) != -1;
    }

    public static Color parseColor(String s) {
        if (s.length() == 7 && s.startsWith("#")) {
            String rStr = s.substring(1, 3);
            String gStr = s.substring(3, 5);
            String bStr = s.substring(5, 7);
            int r = Toolbox.decimal(rStr);
            int g = Toolbox.decimal(gStr);
            int b = Toolbox.decimal(bStr);
            return new Color(r, g, b);
        }
        try {
            Field field = Color.class.getField(s);
            return (Color)field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String toString(Color color) {
        return "#" + Toolbox.hex(color.getRed(), 2) + Toolbox.hex(color.getGreen(), 2) + Toolbox.hex(color.getBlue(), 2);
    }

    public static String hex(int i) {
        return Integer.toHexString(i);
    }

    public static String hex(int i, int minLength) {
        String s = Toolbox.hex(i);
        int lendiff = minLength - s.length();
        return s + Toolbox.repeat('0', lendiff);
    }

    public static int decimal(String hex) {
        return Integer.valueOf(hex, 16);
    }

    public static String repeat(String s, int count) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String repeat(char c, int count) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static String noNull(String s) {
        if (s != null) {
            return s;
        }
        return "";
    }

    public static String unqualify(String s) {
        int pos = s.lastIndexOf(46);
        if (pos != -1) {
            return s.substring(pos + 1);
        }
        return s;
    }

    public static String padRight(String s, String fill, int len) {
        return s + Toolbox.repeat(fill, len - s.length());
    }

    public static String padLeft(String s, String fill, int len) {
        return Toolbox.repeat(fill, len - s.length()) + s;
    }

    public static boolean parseBoolean(String s) {
        return s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("y") || s.equalsIgnoreCase("on") || s.equalsIgnoreCase("true");
    }

    public static String capitalize(String s) {
        if (s.length() > 0) {
            return s.substring(0, 1).toUpperCase() + s.substring(1);
        }
        return "";
    }

    public static String unqualifyJavaName(String name) {
        int lastDotPos = name.lastIndexOf(46);
        if (lastDotPos != -1) {
            return name.substring(lastDotPos + 1);
        }
        return name;
    }

    public static boolean arrayContains(Object[] array, Object object) {
        for (int i = 0; i < array.length; ++i) {
            if (!object.equals(array[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean empty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static void centerOnScreen(Component component) {
        Dimension screen = component.getToolkit().getScreenSize();
        Dimension comp = component.getSize();
        Point newLocation = new Point((screen.width - comp.width) / 2, (screen.height - comp.height) / 2);
        component.setLocation(newLocation);
    }

    public static void centerComponent(Component component, Component parent) {
        Dimension p = parent.getSize();
        Dimension comp = component.getSize();
        Point oldPos = parent.getLocation();
        Point newPos = new Point();
        newPos.x = oldPos.x + (p.width - comp.width) / 2;
        newPos.y = oldPos.y + (p.height - comp.height) / 2;
        component.setLocation(newPos);
    }

    public static Object invokeValueOf(Class clazz, String s) {
        try {
            Class[] signature = new Class[]{String.class};
            Method m = clazz.getMethod("valueOf", signature);
            Object[] params = new Object[]{s};
            Object result = m.invoke(null, params);
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getDocumentText(Document d) {
        try {
            return d.getText(d.getStartPosition().getOffset(), d.getLength());
        }
        catch (BadLocationException ble) {
            return null;
        }
    }

    public static void setDocumentText(Document d, String s) {
        try {
            d.remove(d.getStartPosition().getOffset(), d.getLength());
            d.insertString(d.getStartPosition().getOffset(), s, null);
        }
        catch (BadLocationException ble) {
            throw new Error("INTERNAL ERROR: Toolbox.setDocumentText");
        }
    }

    public static Collection filterCollectionOnType(Collection c, Class type) {
        ArrayList result = new ArrayList();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!type.isAssignableFrom(o.getClass())) continue;
            result.add(o);
        }
        return result;
    }

    public static Component findChildComponent(Container c, Class childType) {
        int i;
        Component[] children = c.getComponents();
        for (i = 0; i < children.length; ++i) {
            if (childType != children[i].getClass()) continue;
            return children[i];
        }
        for (i = 0; i < children.length; ++i) {
            Component found;
            if (!(children[i] instanceof Container) || (found = Toolbox.findChildComponent((Container)children[i], childType)) == null) continue;
            return found;
        }
        return null;
    }

    public static void drawString(Graphics g, String s, Point p, int anchor, Insets shift, Color backgroundColor, Insets backgroundBorder) {
        FontMetrics fm = g.getFontMetrics();
        int w = fm.stringWidth(s);
        int h = fm.getHeight();
        p.y = (anchor & 1) != 0 ? (p.y += h + shift.top) : ((anchor & 4) == 0 ? (p.y += h / 2) : (p.y -= shift.bottom));
        p.x = (anchor & 2) != 0 ? (p.x -= w + shift.right) : ((anchor & 8) == 0 ? (p.x -= w / 2) : (p.x += shift.left));
        if (backgroundColor != null) {
            if (backgroundBorder == null) {
                backgroundBorder = new Insets(0, 0, 0, 0);
            }
            Color foregroundColor = g.getColor();
            g.setColor(backgroundColor);
            Rectangle r = new Rectangle();
            r.x = p.x - backgroundBorder.left;
            r.y = p.y - fm.getAscent() - backgroundBorder.top;
            r.width = w + backgroundBorder.left + backgroundBorder.right;
            r.height = h + backgroundBorder.top + backgroundBorder.bottom;
            g.fillRect(r.x, r.y, r.width, r.height);
            g.setColor(foregroundColor);
        }
        g.drawString(s, p.x, p.y);
    }

    public static void drawString(Graphics g, String s, Point p, int anchor, Insets shift) {
        Toolbox.drawString(g, s, p, anchor, shift, null, null);
    }

    public static void drawString(Graphics g, String s, Point p, int anchor) {
        Toolbox.drawString(g, s, p, anchor, new Insets(0, 0, 0, 0));
    }

    public static void fillCircle(Graphics g, Point center, int radius) {
        int x = center.x - radius;
        int y = center.y - radius;
        int wh = radius * 2;
        g.fillOval(x, y, wh, wh);
    }

    public static void drawLine(Graphics g, Point center, double angle, int radius) {
        Toolbox.drawLine(g, center, angle, 0, radius);
    }

    public static void drawLine(Graphics g, Point center, double angle, int startRadius, int endRadius) {
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        int x1 = (int)((double)center.x - sin * (double)startRadius);
        int y1 = (int)((double)center.y + cos * (double)startRadius);
        int x2 = (int)((double)center.x - sin * (double)endRadius);
        int y2 = (int)((double)center.y + cos * (double)endRadius);
        g.drawLine(x1, y1, x2, y2);
    }

    public static void setLocationCentered(Component c, Point p) {
        Dimension size = c.getSize();
        c.setLocation(p.x - size.width / 2, p.y - size.height / 2);
    }

    public static void messageBox(String text) {
        Toolbox.messageBox("Info", text);
    }

    public static void messageBox(String title, String text) {
        JOptionPane.showMessageDialog(null, text, title, 1);
    }

    public static String replace(String s, String search, String repl) {
        int pos = s.indexOf(search);
        if (pos >= 0) {
            return s.substring(0, pos) + repl + Toolbox.replace(s.substring(pos + search.length()), search, repl);
        }
        return s;
    }

    public static List explode(String s, char seperator) {
        StringTokenizer st = new StringTokenizer(s, String.valueOf(seperator), false);
        ArrayList<String> l = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        return l;
    }

    public static List explode(String s) {
        return Toolbox.explode(s, ',');
    }

    public static String implode(Collection c, char separator) {
        StringBuffer sb = new StringBuffer();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            sb.append(s);
            if (!it.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String implode(Collection c) {
        return Toolbox.implode(c, ',');
    }

    public static String implode(String[] a, String delim) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < a.length; ++i) {
            sb.append(a[i]);
            if (i >= a.length - 1) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static boolean isTrue(String s) {
        if (s != null) {
            return (s = s.trim().toLowerCase()).equalsIgnoreCase("yes") || s.equalsIgnoreCase("true") || s.equalsIgnoreCase("on");
        }
        return false;
    }

    public static boolean isFalse(String s) {
        if (s != null) {
            return (s = s.trim().toLowerCase()).equalsIgnoreCase("no") || s.equalsIgnoreCase("false") || s.equalsIgnoreCase("off");
        }
        return false;
    }

    public static boolean isYes(String s) {
        return Toolbox.isTrue(s);
    }

    public static boolean isNo(String s) {
        return Toolbox.isFalse(s);
    }

    public static String replaceCharsWithStrings(String s, char[] c, String[] r) {
        int len = s.length();
        StringBuffer sb = new StringBuffer();
        int[] pos = new int[c.length];
        int firstIndex = -1;
        int first = len;
        int lastPos = 0;
        for (int i = 0; i < c.length; ++i) {
            int p;
            pos[i] = p = s.indexOf(c[i]);
            if (p == -1 || p >= first) continue;
            first = p;
            firstIndex = i;
        }
        do {
            String part = s.substring(lastPos, first);
            sb.append(part);
            if (first < len) {
                sb.append(r[firstIndex]);
                lastPos = first + 1;
                pos[firstIndex] = lastPos < len ? s.indexOf(c[firstIndex], lastPos) : -1;
                first = len;
                for (int i = 0; i < c.length; ++i) {
                    int p = pos[i];
                    if (p == -1 || p >= first) continue;
                    first = p;
                    firstIndex = i;
                }
            } else {
                lastPos = len;
            }
        } while (lastPos < len);
        return sb.toString();
    }

    private static int getPrimitiveTypeIndex(String typename) {
        for (int i = 0; i < primitiveTypeWrappers[0].length; ++i) {
            if (!primitiveTypeWrappers[0][i].equals(typename)) continue;
            return i;
        }
        return -1;
    }
}

