/*
 * Decompiled with CFR 0.152.
 */
package de.gulden.framework.jjack;

import de.gulden.framework.jjack.JJackAudioConsumer;
import de.gulden.framework.jjack.JJackAudioEvent;
import de.gulden.framework.jjack.JJackAudioProcessListener;
import de.gulden.framework.jjack.JJackAudioProducer;
import de.gulden.framework.jjack.JJackMonitor;
import de.gulden.util.Toolbox;
import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.net.URL;
import javax.swing.ImageIcon;

public abstract class JJackBeanInfoAbstract
extends SimpleBeanInfo {
    public static final String IMAGE_PREFIX = "de/gulden/application/jjack/clients/res/icons/";
    public static final String IMAGE_SUFFIX = ".png";
    protected Class thisClass;
    protected int propertyDescriptorsCount;
    protected int methodDescriptorsCount;

    protected JJackBeanInfoAbstract(Class cl) {
        this(cl, 0, 0);
    }

    protected JJackBeanInfoAbstract(Class cl, int extraPropertyDescriptorsCount, int extraMethodDescriptorsCount) {
        this.thisClass = cl;
        this.propertyDescriptorsCount = extraPropertyDescriptorsCount + 7;
        this.methodDescriptorsCount = extraMethodDescriptorsCount + 1;
    }

    public BeanDescriptor getBeanDescriptor() {
        BeanDescriptor bd = new BeanDescriptor(this.thisClass, null);
        return bd;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        PropertyDescriptor[] p = new PropertyDescriptor[this.propertyDescriptorsCount];
        try {
            p[0] = new PropertyDescriptor("name", this.thisClass);
            p[this.propertyDescriptorsCount - 1] = new PropertyDescriptor("size", this.thisClass);
            p[this.propertyDescriptorsCount - 2] = new PropertyDescriptor("border", this.thisClass);
            p[this.propertyDescriptorsCount - 3] = new PropertyDescriptor("background", this.thisClass);
            p[this.propertyDescriptorsCount - 4] = new PropertyDescriptor("visible", this.thisClass);
            p[this.propertyDescriptorsCount - 5] = new PropertyDescriptor("monitor", this.thisClass, null, "addMonitor");
            p[this.propertyDescriptorsCount - 5].setHidden(true);
            p[this.propertyDescriptorsCount - 6] = new PropertyDescriptor("chained", this.thisClass, null, "setChained");
            p[this.propertyDescriptorsCount - 6].setHidden(true);
        }
        catch (IntrospectionException ie) {
            JJackMonitor.exc(ie);
        }
        return p;
    }

    public EventSetDescriptor[] getEventSetDescriptors() {
        EventSetDescriptor[] e = new EventSetDescriptor[3];
        try {
            e[0] = new EventSetDescriptor(this.thisClass, "monitor", JJackAudioConsumer.class, new String[]{"process"}, "addMonitor", "removeMonitor");
            e[1] = new EventSetDescriptor(this.thisClass, "chained", JJackAudioProducer.class, new String[]{"process"}, "setChained", "removeChained");
            e[1].setUnicast(true);
            e[2] = new EventSetDescriptor(this.thisClass, "processListener", JJackAudioProcessListener.class, new String[]{"beforeProcess", "afterProcess"}, "addAudioProcessListener", "removeAudioProcessListener");
        }
        catch (IntrospectionException ie) {
            JJackMonitor.exc(ie);
        }
        return e;
    }

    public int getDefaultEventIndex() {
        return 0;
    }

    public MethodDescriptor[] getMethodDescriptors() {
        MethodDescriptor[] m = new MethodDescriptor[this.methodDescriptorsCount];
        try {
            m[this.methodDescriptorsCount - 1] = new MethodDescriptor(this.thisClass.getMethod("process", JJackAudioEvent.class));
        }
        catch (Exception e) {
            this.exc(e);
        }
        return m;
    }

    public Image getIcon(int kind) {
        String imgRes = IMAGE_PREFIX + Toolbox.unqualify(this.thisClass.getName()).toLowerCase() + IMAGE_SUFFIX;
        URL res = this.getClass().getClassLoader().getResource(imgRes);
        if (res != null) {
            ImageIcon icon = new ImageIcon(res);
            return icon.getImage();
        }
        return null;
    }

    protected void exc(Exception e) {
        JJackMonitor.exc(e);
    }
}

