/*
 * Decompiled with CFR 0.152.
 */
package com.petersalomonsen.jjack.javasound;

import com.petersalomonsen.jjack.javasound.BlockingByteFIFO;
import com.petersalomonsen.jjack.javasound.ByteIntConverter;
import com.petersalomonsen.jjack.javasound.JJackMixer;
import de.gulden.framework.jjack.JJackSystem;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;

public abstract class JJackLine
implements DataLine {
    BlockingByteFIFO fifo;
    ByteIntConverter converter;
    AudioFormat format = new AudioFormat(JJackSystem.getSampleRate(), 16, 2, true, false);
    DataLine.Info info;
    JJackMixer mixer;
    boolean open = false;
    float[] floatBuffer = null;
    byte[] byteBuffer = null;

    public JJackLine(JJackMixer mixer) {
        this.mixer = mixer;
    }

    protected final void checkAndAllocateBuffers(int length) {
        if (this.floatBuffer == null || this.floatBuffer.length != length) {
            this.floatBuffer = new float[length];
            this.byteBuffer = new byte[length * (this.format.getSampleSizeInBits() / 8)];
        }
    }

    public void addLineListener(LineListener listener) {
    }

    public void open() throws LineUnavailableException {
        this.open(this.format);
    }

    public void open(AudioFormat format) throws LineUnavailableException {
        this.open(format, 65536);
    }

    public void open(AudioFormat format, int bufferSize) throws LineUnavailableException {
        this.format = format;
        this.fifo = new BlockingByteFIFO(bufferSize);
        this.converter = new ByteIntConverter(format.getSampleSizeInBits() / 8, format.isBigEndian(), format.getEncoding() == AudioFormat.Encoding.PCM_SIGNED);
        this.info = new DataLine.Info(this.getClass(), format);
        this.mixer.registerOpenLine(this);
        this.open = true;
    }

    public void close() {
        this.mixer.unregisterLine(this);
        this.open = false;
    }

    public Control getControl(Control.Type control) {
        return null;
    }

    public Control[] getControls() {
        return null;
    }

    public boolean isControlSupported(Control.Type control) {
        return false;
    }

    public int getBufferSize() {
        return this.fifo.getBufferSize();
    }

    public boolean isOpen() {
        return this.open;
    }

    public void removeLineListener(LineListener listener) {
    }

    public int getFramePosition() {
        return (int)this.getLongFramePosition();
    }

    public abstract long getLongFramePosition();

    public long getMicrosecondPosition() {
        return (long)(1000000.0f * ((float)this.getLongFramePosition() / this.format.getFrameRate()));
    }

    public abstract int available();

    public void drain() {
    }

    public void flush() {
        this.fifo.flush();
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public float getLevel() {
        return 0.0f;
    }

    public boolean isActive() {
        return false;
    }

    public boolean isRunning() {
        return false;
    }

    public void start() {
    }

    public void stop() {
    }

    public Line.Info getLineInfo() {
        return this.info;
    }
}

