/*
 * Decompiled with CFR 0.152.
 */
package biniu.vorbis;

import biniu.ogg.Packet;
import biniu.ogg.Page;
import biniu.ogg.StreamState;
import biniu.vorbis.Block;
import biniu.vorbis.Comment;
import biniu.vorbis.DspState;
import biniu.vorbis.Info;
import biniu.vorbis.VorbisEnc;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;

public class EncodeExample {
    public static int READ = 1024;
    private byte[] readbuffer = new byte[READ * 4 + 44];
    private RandomAccessFile fread;
    private RandomAccessFile fwrite;

    int encode() {
        StreamState os = new StreamState();
        Page og = new Page();
        Packet op = new Packet();
        Info vi = new Info();
        Comment vc = new Comment();
        DspState vd = new DspState();
        Block vb = new Block(vd);
        boolean eos = false;
        VorbisEnc ve = new VorbisEnc();
        try {
            File plik = new File("1a.wav");
            this.fread = new RandomAccessFile(plik, "r");
            File plikOgg = new File("1.ogg");
            this.fwrite = new RandomAccessFile(plikOgg, "rw");
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        this.readbuffer[0] = 0;
        byte[] rtab = new byte[2];
        int i = 0;
        boolean founddata = false;
        while (i < 30) {
            try {
                this.fread.read(rtab);
                if (rtab[0] == 100 && rtab[1] == 97) {
                    founddata = true;
                    this.fread.read(this.readbuffer, 1, 6);
                    break;
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            ++i;
        }
        vi.init();
        int ret = ve.initVBR(vi, 2, 44100, 0.1f);
        if (ret != 0) {
            System.exit(1);
        }
        vc.init();
        vc.addTag("ENCODER", "encoder_example.c");
        vd.analysisInit(vi);
        vb.blockInit(vd);
        Random rand = new Random();
        os.init(rand.nextInt());
        Packet header = new Packet();
        Packet header_comm = new Packet();
        Packet header_code = new Packet();
        vd.analysisHeaderOut(vc, header, header_comm, header_code);
        os.packetIn(header);
        os.packetIn(header_comm);
        os.packetIn(header_code);
        while (!eos) {
            boolean result = os.flush(og);
            if (!result) break;
            try {
                this.fwrite.write(og.header_base, og.header, og.header_len);
                this.fwrite.write(og.body_base, og.body, og.body_len);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        boolean pos = false;
        while (!eos) {
            int bytes = 0;
            try {
                bytes = this.fread.read(this.readbuffer, 0, READ * 4);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (bytes == 0) {
                vd.analysisWrote(0);
            } else {
                float[][] buffer = vd.analysisBuffer(READ);
                i = 0;
                int l = vd.pcm_current;
                while (i < bytes / 4) {
                    buffer[0][l] = (float)(this.readbuffer[i * 4 + 1] << 8 | 0xFF & this.readbuffer[i * 4]) / 32768.0f;
                    buffer[1][l] = (float)(this.readbuffer[i * 4 + 3] << 8 | 0xFF & this.readbuffer[i * 4 + 2]) / 32768.0f;
                    ++i;
                    ++l;
                }
                vd.analysisWrote(i);
            }
            while (vb.analysisBlockOut()) {
                vb.analysis(null);
                vb.bitrateAddBlock();
                block15: while (vd.bitrateFlushPacket(op)) {
                    os.packetIn(op);
                    while (!eos) {
                        boolean result = os.pageOut(og);
                        if (!result) continue block15;
                        try {
                            this.fwrite.write(og.header_base, og.header, og.header_len);
                            this.fwrite.write(og.body_base, og.body, og.body_len);
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                        if (!og.eos()) continue;
                        eos = true;
                    }
                }
            }
        }
        os.clear();
        vb.clear();
        vd.clear();
        vc.clear();
        vi.clear();
        System.out.println("Done.\n");
        return 0;
    }

    public static void main(String[] arg) {
        EncodeExample encodeExample = new EncodeExample();
        encodeExample.encode();
    }
}

