/*
 * Decompiled with CFR 0.152.
 */
package biniu.vorbis;

import biniu.ogg.Buffer;
import biniu.ogg.Packet;
import biniu.vorbis.AllocChain;
import biniu.vorbis.BitrateManagerInfo;
import biniu.vorbis.BitrateManagerState;
import biniu.vorbis.BlockInternal;
import biniu.vorbis.CodecSetupInfo;
import biniu.vorbis.DspState;
import biniu.vorbis.FuncMapping;
import biniu.vorbis.Info;
import biniu.vorbis.LookPsyGlobal;
import biniu.vorbis.PrivateState;

public class Block {
    private static final int BLOCKTYPE_IMPULSE = 0;
    private static final int BLOCKTYPE_PADDING = 1;
    private static final int BLOCKTYPE_TRANSITION = 0;
    private static final int BLOCKTYPE_LONG = 1;
    public float[][] pcm = new float[0][];
    public Buffer opb = new Buffer();
    public int lW;
    public int W;
    public int nW;
    public int pcmEnd;
    public int mode;
    public int eofFlag;
    public long granulePos;
    public long sequence;
    public DspState dspState;
    private int localTop;
    private int localAlloc;
    private int totalUse;
    private AllocChain reap;
    public int glue_bits;
    public int time_bits;
    public int floor_bits;
    public int res_bits;
    public BlockInternal blockInternal;
    private Info vi;
    private CodecSetupInfo ci;

    public Block(DspState vd) {
        this.dspState = vd;
        if (vd.analysisp != 0) {
            this.opb.writeInit();
        }
    }

    public void init(DspState vd) {
        this.dspState = vd;
        this.vi = this.dspState.vi;
        this.ci = this.vi.getCodecSetup();
    }

    public int blockInit(DspState vd) {
        this.dspState = vd;
        this.vi = this.dspState.vi;
        this.ci = this.vi.getCodecSetup();
        this.localAlloc = 0;
        if (vd.analysisp != 0) {
            this.blockInternal = new BlockInternal();
            this.blockInternal.ampmax = -9999.0f;
            int i = 0;
            while (i < 15) {
                this.blockInternal.packetblob[i] = i == 7 ? this.opb : new Buffer();
                this.blockInternal.packetblob[i].writeInit();
                ++i;
            }
        }
        return 0;
    }

    public boolean bitrateManaged() {
        BitrateManagerState bm = this.dspState.backEndState.bms;
        return bm.equals(bm.managed);
    }

    public boolean analysisBlockOut() {
        Info vi = this.dspState.vi;
        CodecSetupInfo ci = vi.getCodecSetup();
        PrivateState b = this.dspState.backEndState;
        LookPsyGlobal g = b.psyGlobLook;
        int beginW = this.dspState.centerW - ci.blocksizes[this.dspState.W] / 2;
        if (this.dspState.preextrapolate == 0) {
            return false;
        }
        if (this.dspState.eofflag == -1) {
            return false;
        }
        int bp = this.dspState.envelopeSearch();
        if (bp == -1) {
            if (this.dspState.eofflag == 0) {
                return false;
            }
            this.dspState.nW = 0;
        } else {
            this.dspState.nW = ci.blocksizes[0] == ci.blocksizes[1] ? 0 : bp;
        }
        int centerNext = this.dspState.centerW + ci.blocksizes[this.dspState.W] / 4 + ci.blocksizes[this.dspState.nW] / 4;
        long blockbound = centerNext + ci.blocksizes[this.dspState.nW] / 2;
        if ((long)this.dspState.pcm_current < blockbound) {
            return false;
        }
        this.blockRipcord();
        this.lW = this.dspState.lW;
        this.W = this.dspState.W;
        this.nW = this.dspState.nW;
        this.blockInternal.blocktype = this.dspState.W != 0 ? (this.dspState.lW == 0 || this.dspState.nW == 0 ? 0 : 1) : (this.dspState.envelopeMark() != 0 ? 0 : 1);
        this.sequence = this.dspState.sequence++;
        this.granulePos = this.dspState.granulepos;
        this.pcmEnd = ci.blocksizes[this.dspState.W];
        if (this.blockInternal.ampmax > g.ampmax) {
            g.ampmax = this.blockInternal.ampmax;
        }
        this.blockInternal.ampmax = g.ampmax = this.dspState.ampMaxDecay(g.ampmax);
        this.pcm = new float[vi.channels][];
        this.blockInternal.pcmdelay = new float[vi.channels][];
        int i = 0;
        while (i < vi.channels) {
            this.blockInternal.pcmdelay[i] = new float[this.pcmEnd + beginW];
            System.arraycopy(this.dspState.pcm[i], 0, this.blockInternal.pcmdelay[i], 0, this.pcmEnd + beginW);
            this.pcm[i] = new float[this.blockInternal.pcmdelay[i].length - beginW];
            System.arraycopy(this.blockInternal.pcmdelay[i], beginW, this.pcm[i], 0, this.pcm[i].length);
            ++i;
        }
        if (this.dspState.eofflag != 0 && this.dspState.centerW >= this.dspState.eofflag) {
            this.dspState.eofflag = -1;
            this.eofFlag = 1;
            return true;
        }
        int new_centerNext = ci.blocksizes[1] / 2;
        int movementW = centerNext - new_centerNext;
        if (movementW > 0) {
            b.enveLook.envelopeShift(movementW);
            this.dspState.pcm_current -= movementW;
            i = 0;
            while (i < vi.channels) {
                System.arraycopy(this.dspState.pcm[i], movementW, this.dspState.pcm[i], 0, this.dspState.pcm_current);
                ++i;
            }
            this.dspState.lW = this.dspState.W;
            this.dspState.W = this.dspState.nW;
            this.dspState.centerW = new_centerNext;
            if (this.dspState.eofflag != 0) {
                this.dspState.eofflag -= movementW;
                if (this.dspState.eofflag <= 0) {
                    this.dspState.eofflag = -1;
                }
                this.dspState.granulepos = this.dspState.centerW >= this.dspState.eofflag ? (this.dspState.granulepos += (long)(movementW - (this.dspState.centerW - this.dspState.eofflag))) : (this.dspState.granulepos += (long)movementW);
            } else {
                this.dspState.granulepos += (long)movementW;
            }
        }
        return true;
    }

    public int blockClear() {
        this.blockRipcord();
        if (this.blockInternal != null) {
            int i = 0;
            while (i < 15) {
                this.blockInternal.packetblob[i].writeClear();
                if (i != 7) {
                    this.blockInternal.packetblob[i] = null;
                }
                ++i;
            }
            this.blockInternal = null;
        }
        return 0;
    }

    public int clear() {
        if (this.dspState != null && this.dspState.analysisp != 0) {
            this.opb.writeClear();
        }
        return 0;
    }

    public int analysis(Packet op) {
        this.glue_bits = 0;
        this.time_bits = 0;
        this.floor_bits = 0;
        this.res_bits = 0;
        int i = 0;
        while (i < 15) {
            this.blockInternal.packetblob[i].reset();
            ++i;
        }
        int ret = FuncMapping.mapping_P[0].mapping0Forward(this);
        if (ret != 0) {
            return ret;
        }
        if (op != null) {
            if (this.bitrateManaged()) {
                return -131;
            }
            op.b_o_s = 0;
            op.e_o_s = this.eofFlag;
            op.granulePos = this.granulePos;
            op.packetNo = this.sequence;
        }
        return 0;
    }

    public int bitrateAddBlock() {
        BitrateManagerState bm = this.dspState.backEndState.bms;
        BitrateManagerInfo bi = this.ci.biManInfo;
        int choice = (int)Math.rint(bm.avgfloat);
        long this_bits = this.blockInternal.packetblob[choice].getBytes() * 8;
        long min_target_bits = this.W != 0 ? bm.min_bitsper * bm.short_per_long : bm.min_bitsper;
        int max_target_bits = this.W != 0 ? bm.max_bitsper * bm.short_per_long : bm.max_bitsper;
        int samples = this.ci.blocksizes[this.W] >> 1;
        int desired_fill = (int)((double)bi.reservoir_bits * bi.reservoir_bias);
        if (bm.managed == null) {
            if (bm.vb != null) {
                return -1;
            }
            bm.vb = this;
            return 0;
        }
        bm.vb = this;
        if (bm.avg_bitsper > 0) {
            double slew = 0.0;
            long avg_target_bits = this.W != 0 ? bm.avg_bitsper * bm.short_per_long : bm.avg_bitsper;
            double slewlimit = 15.0 / bi.slew_damp;
            if ((long)bm.avg_reservoir + (this_bits - avg_target_bits) > (long)desired_fill) {
                while (choice > 0 && this_bits > avg_target_bits && (long)bm.avg_reservoir + (this_bits - avg_target_bits) > (long)desired_fill) {
                    this_bits = this.blockInternal.packetblob[--choice].getBytes() * 8;
                }
            } else if ((long)bm.avg_reservoir + (this_bits - avg_target_bits) < (long)desired_fill) {
                while (choice + 1 < 15 && this_bits < avg_target_bits && (long)bm.avg_reservoir + (this_bits - avg_target_bits) < (long)desired_fill) {
                    this_bits = this.blockInternal.packetblob[++choice].getBytes() * 8;
                }
            }
            if ((slew = Math.rint((double)choice - bm.avgfloat) / (double)samples * (double)this.vi.rate) < -slewlimit) {
                slew = -slewlimit;
            }
            if (slew > slewlimit) {
                slew = slewlimit;
            }
            choice = (int)Math.rint(bm.avgfloat += slew / (double)this.vi.rate * (double)samples);
            this_bits = this.blockInternal.packetblob[choice].getBytes() * 8;
        }
        if (bm.min_bitsper > 0 && this_bits < min_target_bits) {
            while ((long)bm.minmax_reservoir - (min_target_bits - this_bits) < 0L) {
                if (++choice >= 15) break;
                this_bits = this.blockInternal.packetblob[choice].getBytes() * 8;
            }
        }
        if (bm.max_bitsper > 0 && this_bits > (long)max_target_bits) {
            while ((long)bm.minmax_reservoir + (this_bits - (long)max_target_bits) > (long)bi.reservoir_bits) {
                if (--choice < 0) break;
                this_bits = this.blockInternal.packetblob[choice].getBytes() * 8;
            }
        }
        if (choice < 0) {
            int maxsize = (max_target_bits + (bi.reservoir_bits - bm.minmax_reservoir)) / 8;
            choice = 0;
            bm.choice = 0;
            if (this.blockInternal.packetblob[choice].getBytes() > maxsize) {
                this.blockInternal.packetblob[choice].writetrUnc(maxsize * 8);
                this_bits = this.blockInternal.packetblob[choice].getBytes() * 8;
            }
        } else {
            long minsize = (min_target_bits - (long)bm.minmax_reservoir + 7L) / 8L;
            if (choice >= 15) {
                choice = 14;
            }
            bm.choice = choice;
            minsize -= (long)this.blockInternal.packetblob[choice].getBytes();
            while ((double)minsize - 0.0 != 0.0) {
                this.blockInternal.packetblob[choice].write(0, 8);
            }
            this_bits = this.blockInternal.packetblob[choice].getBytes() * 8;
        }
        if (bm.min_bitsper > 0 || bm.max_bitsper > 0) {
            if (max_target_bits > 0 && this_bits > (long)max_target_bits) {
                bm.minmax_reservoir = (int)((long)bm.minmax_reservoir + (this_bits - (long)max_target_bits));
            } else if (min_target_bits > 0L && this_bits < min_target_bits) {
                bm.minmax_reservoir = (int)((long)bm.minmax_reservoir + (this_bits - min_target_bits));
            } else if (bm.minmax_reservoir > desired_fill) {
                if (max_target_bits > 0) {
                    bm.minmax_reservoir = (int)((long)bm.minmax_reservoir + (this_bits - (long)max_target_bits));
                    if (bm.minmax_reservoir < desired_fill) {
                        bm.minmax_reservoir = desired_fill;
                    }
                } else {
                    bm.minmax_reservoir = desired_fill;
                }
            } else if (min_target_bits > 0L) {
                bm.minmax_reservoir = (int)((long)bm.minmax_reservoir + (this_bits - min_target_bits));
                if (bm.minmax_reservoir > desired_fill) {
                    bm.minmax_reservoir = desired_fill;
                }
            } else {
                bm.minmax_reservoir = desired_fill;
            }
        }
        if (bm.avg_bitsper > 0) {
            long avg_target_bits = this.W != 0 ? bm.avg_bitsper * bm.short_per_long : bm.avg_bitsper;
            bm.avg_reservoir = (int)((long)bm.avg_reservoir + (this_bits - avg_target_bits));
        }
        return 0;
    }

    private void blockRipcord() {
        while (this.reap != null) {
            AllocChain next = this.reap.next;
            this.reap.ptr = null;
            this.reap = next;
        }
        if (this.totalUse != 0) {
            this.localAlloc += this.totalUse;
            this.totalUse = 0;
        }
        this.localTop = 0;
        this.reap = null;
    }
}

