/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelByteBuffer {
    private ModelByteBuffer root = this;
    private File file;
    private long fileoffset;
    private byte[] buffer;
    private long offset;
    private long len;

    private ModelByteBuffer(ModelByteBuffer modelByteBuffer, long l, long l2, boolean bl) {
        this.root = modelByteBuffer.root;
        this.offset = 0L;
        this.len = modelByteBuffer.len;
        if (l < 0L) {
            l = 0L;
        }
        if (l > this.len) {
            l = this.len;
        }
        if (l2 < 0L) {
            l2 = 0L;
        }
        if (l2 > this.len) {
            l2 = this.len;
        }
        if (l > l2) {
            l = l2;
        }
        this.offset = l;
        this.len = l2 - l;
        if (bl) {
            this.buffer = this.root.buffer;
            if (this.root.file != null) {
                this.file = this.root.file;
                this.fileoffset = this.root.fileoffset + this.arrayOffset();
                this.offset = 0L;
            } else {
                this.offset = this.arrayOffset();
            }
            this.root = this;
        }
    }

    public ModelByteBuffer(byte[] byArray) {
        this.buffer = byArray;
        this.offset = 0L;
        this.len = byArray.length;
    }

    public ModelByteBuffer(byte[] byArray, int n, int n2) {
        this.buffer = byArray;
        this.offset = n;
        this.len = n2;
    }

    public ModelByteBuffer(File file) {
        this.file = file;
        this.fileoffset = 0L;
        this.len = file.length();
    }

    public ModelByteBuffer(File file, long l, long l2) {
        this.file = file;
        this.fileoffset = l;
        this.len = l2;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (this.root.file != null && this.root.buffer == null) {
            int n;
            InputStream inputStream = this.getInputStream();
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        } else {
            outputStream.write(this.array(), (int)this.arrayOffset(), (int)this.capacity());
        }
    }

    public InputStream getInputStream() {
        if (this.root.file != null && this.root.buffer == null) {
            try {
                return new RandomFileInputStream();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
        return new ByteArrayInputStream(this.array(), (int)this.arrayOffset(), (int)this.capacity());
    }

    public ModelByteBuffer subbuffer(long l) {
        return this.subbuffer(l, this.capacity());
    }

    public ModelByteBuffer subbuffer(long l, long l2) {
        return this.subbuffer(l, l2, false);
    }

    public ModelByteBuffer subbuffer(long l, long l2, boolean bl) {
        return new ModelByteBuffer(this, l, l2, bl);
    }

    public byte[] array() {
        return this.root.buffer;
    }

    public long arrayOffset() {
        if (this.root != this) {
            return this.root.arrayOffset() + this.offset;
        }
        return this.offset;
    }

    public long capacity() {
        return this.len;
    }

    public ModelByteBuffer getRoot() {
        return this.root;
    }

    public File getFile() {
        return this.file;
    }

    public long getFilePointer() {
        return this.fileoffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadAll(Collection<ModelByteBuffer> collection) throws IOException {
        File file = null;
        RandomAccessFile randomAccessFile = null;
        try {
            for (ModelByteBuffer modelByteBuffer : collection) {
                modelByteBuffer = modelByteBuffer.root;
                if (modelByteBuffer.file == null || modelByteBuffer.buffer != null) continue;
                if (file == null || !file.equals(modelByteBuffer.file)) {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                        randomAccessFile = null;
                    }
                    file = modelByteBuffer.file;
                    randomAccessFile = new RandomAccessFile(modelByteBuffer.file, "r");
                }
                randomAccessFile.seek(modelByteBuffer.fileoffset);
                byte[] byArray = new byte[(int)modelByteBuffer.capacity()];
                int n = 0;
                int n2 = byArray.length;
                while (n != n2) {
                    if (n2 - n > 65536) {
                        randomAccessFile.read(byArray, n, 65536);
                        n += 65536;
                        continue;
                    }
                    randomAccessFile.read(byArray, n, n2 - n);
                    n = n2;
                }
                modelByteBuffer.buffer = byArray;
                modelByteBuffer.offset = 0L;
            }
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }

    public void load() throws IOException {
        if (this.root != this) {
            this.root.load();
            return;
        }
        if (this.buffer != null) {
            return;
        }
        if (this.file == null) {
            throw new IllegalStateException("No file associated with this ByteBuffer!");
        }
        InputStream inputStream = this.getInputStream();
        this.buffer = new byte[(int)this.capacity()];
        this.offset = 0L;
        inputStream.read(this.buffer);
        inputStream.close();
    }

    public void unload() {
        if (this.root != this) {
            this.root.unload();
            return;
        }
        if (this.file == null) {
            throw new IllegalStateException("No file associated with this ByteBuffer!");
        }
        this.root.buffer = null;
    }

    private class RandomFileInputStream
    extends InputStream {
        private RandomAccessFile raf;
        private long left;
        private long mark = 0L;
        private long markleft = 0L;

        public RandomFileInputStream() throws IOException {
            this.raf = new RandomAccessFile(ModelByteBuffer.this.root.file, "r");
            this.raf.seek(ModelByteBuffer.this.root.fileoffset + ModelByteBuffer.this.arrayOffset());
            this.left = ModelByteBuffer.this.capacity();
        }

        public int available() throws IOException {
            if (this.left > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)this.left;
        }

        public synchronized void mark(int n) {
            try {
                this.mark = this.raf.getFilePointer();
                this.markleft = this.left;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public boolean markSupported() {
            return true;
        }

        public synchronized void reset() throws IOException {
            this.raf.seek(this.mark);
            this.left = this.markleft;
        }

        public long skip(long l) throws IOException {
            if (l > this.left) {
                l = this.left;
            }
            if ((l = super.skip(l)) == -1L) {
                return -1L;
            }
            this.left -= l;
            return l;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if ((long)n2 > this.left) {
                n2 = (int)this.left;
            }
            if (this.left == 0L) {
                return -1;
            }
            if ((n2 = this.raf.read(byArray, n, n2)) == -1) {
                return -1;
            }
            this.left -= (long)n2;
            return n2;
        }

        public int read(byte[] byArray) throws IOException {
            if (ModelByteBuffer.this.len > this.left) {
                ModelByteBuffer.this.len = (int)this.left;
            }
            if (this.left == 0L) {
                return -1;
            }
            int n = this.raf.read(byArray);
            if (n == -1) {
                return -1;
            }
            this.left -= (long)n;
            return n;
        }

        public int read() throws IOException {
            if (ModelByteBuffer.this.len == 0L) {
                return -1;
            }
            int n = this.raf.read();
            if (n == -1) {
                return -1;
            }
            ModelByteBuffer.this.len--;
            return n;
        }

        public void close() throws IOException {
            this.raf.close();
        }
    }
}

