/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;

public class LogFactoryImpl
extends LogFactory {
    public static final String LOG_PROPERTY = "org.apache.commons.logging.Log";
    protected static final String LOG_PROPERTY_OLD = "org.apache.commons.logging.log";
    private static final String LOG_INTERFACE = "org.apache.commons.logging.Log";
    protected Hashtable attributes = new Hashtable();
    protected Hashtable instances = new Hashtable();
    private String logClassName;
    protected Constructor logConstructor = null;
    protected Class[] logConstructorSignature;
    protected Method logMethod;
    protected Class[] logMethodSignature;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public LogFactoryImpl() {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        this.logConstructorSignature = classArray;
        this.logMethod = null;
        Class[] classArray2 = new Class[1];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.apache.commons.logging.LogFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz2;
        this.logMethodSignature = classArray2;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String[] getAttributeNames() {
        Vector<String> names = new Vector<String>();
        Enumeration keys = this.attributes.keys();
        while (keys.hasMoreElements()) {
            names.addElement((String)keys.nextElement());
        }
        String[] results = new String[names.size()];
        int i = 0;
        while (i < results.length) {
            results[i] = (String)names.elementAt(i);
            ++i;
        }
        return results;
    }

    public Log getInstance(Class clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    public Log getInstance(String name) throws LogConfigurationException {
        Log instance = (Log)this.instances.get(name);
        if (instance == null) {
            instance = this.newInstance(name);
            this.instances.put(name, instance);
        }
        return instance;
    }

    public void release() {
        this.instances.clear();
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, value);
        }
    }

    protected String getLogClassName() {
        if (this.logClassName != null) {
            return this.logClassName;
        }
        this.logClassName = (String)this.getAttribute("org.apache.commons.logging.Log");
        if (this.logClassName == null) {
            this.logClassName = (String)this.getAttribute(LOG_PROPERTY_OLD);
        }
        if (this.logClassName == null) {
            try {
                this.logClassName = System.getProperty("org.apache.commons.logging.Log");
            }
            catch (SecurityException securityException) {}
        }
        if (this.logClassName == null) {
            try {
                this.logClassName = System.getProperty(LOG_PROPERTY_OLD);
            }
            catch (SecurityException securityException) {}
        }
        if (this.logClassName == null && this.isLog4JAvailable()) {
            this.logClassName = "org.apache.commons.logging.impl.Log4JLogger";
        }
        if (this.logClassName == null && this.isJdk14Available()) {
            this.logClassName = "org.apache.commons.logging.impl.Jdk14Logger";
        }
        if (this.logClassName == null && this.isJdk13LumberjackAvailable()) {
            this.logClassName = "org.apache.commons.logging.impl.Jdk13LumberjackLogger";
        }
        if (this.logClassName == null) {
            this.logClassName = "org.apache.commons.logging.impl.SimpleLog";
        }
        return this.logClassName;
    }

    protected Constructor getLogConstructor() throws LogConfigurationException {
        if (this.logConstructor != null) {
            return this.logConstructor;
        }
        String logClassName = this.getLogClassName();
        Class logClass = null;
        Class<?> logInterface = null;
        try {
            logInterface = this.getClass().getClassLoader().loadClass("org.apache.commons.logging.Log");
            logClass = LogFactoryImpl.loadClass(logClassName);
            if (logClass == null) {
                throw new LogConfigurationException("No suitable Log implementation for " + logClassName);
            }
            if (!logInterface.isAssignableFrom(logClass)) {
                Class<?>[] interfaces = logClass.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    if ("org.apache.commons.logging.Log".equals(interfaces[i].getName())) {
                        throw new LogConfigurationException("Invalid class loader hierarchy.  You have more than one version of 'org.apache.commons.logging.Log' visible, which is not allowed.");
                    }
                    ++i;
                }
                throw new LogConfigurationException("Class " + logClassName + " does not implement '" + "org.apache.commons.logging.Log" + "'.");
            }
        }
        catch (Throwable t) {
            throw new LogConfigurationException(t);
        }
        try {
            this.logMethod = logClass.getMethod("setLogFactory", this.logMethodSignature);
        }
        catch (Throwable throwable) {
            this.logMethod = null;
        }
        try {
            this.logConstructor = logClass.getConstructor(this.logConstructorSignature);
            return this.logConstructor;
        }
        catch (Throwable t) {
            throw new LogConfigurationException("No suitable Log constructor " + this.logConstructorSignature + " for " + logClassName, t);
        }
    }

    private static Class loadClass(final String name) throws ClassNotFoundException {
        Object result = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader threadCL = LogFactoryImpl.access$0();
                if (threadCL != null) {
                    try {
                        return threadCL.loadClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                try {
                    return Class.forName(name);
                }
                catch (ClassNotFoundException e) {
                    return e;
                }
            }
        });
        if (result instanceof Class) {
            return (Class)result;
        }
        throw (ClassNotFoundException)result;
    }

    protected boolean isJdk13LumberjackAvailable() {
        try {
            LogFactoryImpl.loadClass("java.util.logging.Logger");
            LogFactoryImpl.loadClass("org.apache.commons.logging.impl.Jdk13LumberjackLogger");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected boolean isJdk14Available() {
        try {
            LogFactoryImpl.loadClass("java.util.logging.Logger");
            LogFactoryImpl.loadClass("org.apache.commons.logging.impl.Jdk14Logger");
            Class throwable = LogFactoryImpl.loadClass("java.lang.Throwable");
            return throwable.getDeclaredMethod("getStackTrace", null) != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected boolean isLog4JAvailable() {
        try {
            LogFactoryImpl.loadClass("org.apache.log4j.Logger");
            LogFactoryImpl.loadClass("org.apache.commons.logging.impl.Log4JLogger");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected Log newInstance(String name) throws LogConfigurationException {
        Log instance = null;
        try {
            Object[] params = new Object[]{name};
            instance = (Log)this.getLogConstructor().newInstance(params);
            if (this.logMethod != null) {
                params[0] = this;
                this.logMethod.invoke((Object)instance, params);
            }
            return instance;
        }
        catch (InvocationTargetException e) {
            Throwable c = e.getTargetException();
            if (c != null) {
                throw new LogConfigurationException(c);
            }
            throw new LogConfigurationException(e);
        }
        catch (Throwable t) {
            throw new LogConfigurationException(t);
        }
    }

    static /* synthetic */ ClassLoader access$0() throws LogConfigurationException {
        return LogFactory.getContextClassLoader();
    }
}

