/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.server;

import java.util.Hashtable;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.ChannelFormat;
import uk.org.toot.audio.server.IOAudioProcess;
import uk.org.toot.audio.server.JavaSoundAudioServer;

public class MultiIOJavaSoundAudioServer
extends JavaSoundAudioServer {
    Hashtable<String, IOAudioProcess> outputMap = new Hashtable();
    Hashtable<String, IOAudioProcess> inputMap = new Hashtable();

    public IOAudioProcess openAudioOutput(String name, String label) throws Exception {
        if (name == null) {
            name = this.getAvailableOutputNames().get(0);
            System.out.println(String.valueOf(label) + " null name specified, using " + name);
        }
        IOAudioProcess p = this.outputMap.get(name);
        System.out.println(String.valueOf(name) + "   " + p);
        if (p == null) {
            p = new AudioProcessWrapper(super.openAudioOutput(name, label));
            this.outputMap.put(name, p);
        }
        return p;
    }

    public IOAudioProcess openAudioInput(String name, String label) throws Exception {
        IOAudioProcess p;
        if (name == null) {
            name = this.getAvailableInputNames().get(0);
            System.out.println(String.valueOf(label) + " null name specified, using " + name);
        }
        if ((p = this.inputMap.get(name)) == null) {
            p = new AudioProcessWrapper(super.openAudioInput(name, label));
            this.inputMap.put(name, p);
        }
        return p;
    }

    public void closeAudioInput(IOAudioProcess input) {
    }

    public void closeAudioOutput(IOAudioProcess output) {
    }

    class AudioProcessWrapper
    implements IOAudioProcess {
        IOAudioProcess process;
        int openCount = 0;

        public AudioProcessWrapper(IOAudioProcess process) {
            this.process = process;
        }

        public void open() throws Exception {
            if (this.openCount == 0) {
                this.process.open();
            }
            ++this.openCount;
        }

        public int processAudio(AudioBuffer buffer) {
            return this.process.processAudio(buffer);
        }

        public void close() throws Exception {
            --this.openCount;
            if (this.openCount == 0) {
                this.process.close();
            }
        }

        public ChannelFormat getChannelFormat() {
            return this.process.getChannelFormat();
        }

        public String getName() {
            return this.process.getName();
        }
    }
}

