/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.server;

import com.frinika.toot.PriorityAudioServer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.ChannelFormat;
import uk.org.toot.audio.server.AudioLine;
import uk.org.toot.audio.server.IOAudioProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSoundAudioServer
extends PriorityAudioServer {
    private byte[] sharedByteBuffer;
    private int sampleSizeInBits = 16;
    private AudioFormat format;
    private List<JavaSoundAudioOutput> outputs = new ArrayList<JavaSoundAudioOutput>();
    private List<JavaSoundAudioInput> inputs = new ArrayList<JavaSoundAudioInput>();
    private int lineBufferBytes = 32768;

    protected void checkFormat() {
        if (this.format != null) {
            return;
        }
        this.format = new AudioFormat(this.getSampleRate(), this.getSampleSizeInBits(), 2, true, false);
        this.lineBufferBytes = this.format.getFrameSize() * (int)this.getSampleRate() / 5;
        this.sharedByteBuffer = this.createByteBuffer();
    }

    @Override
    public int getSampleSizeInBits() {
        return this.sampleSizeInBits;
    }

    public void setSampleSizeInBits(int sampleSizeInBits) {
        if (this.format != null) {
            throw new IllegalStateException("too late, format already set");
        }
        this.sampleSizeInBits = sampleSizeInBits;
    }

    @Override
    public void setSampleRate(float sampleRate) {
        if (this.format != null) {
            throw new IllegalStateException("too late, format already set");
        }
        super.setSampleRate(sampleRate);
    }

    @Override
    public List<AudioLine> getOutputs() {
        return Collections.unmodifiableList(this.outputs);
    }

    @Override
    public List<AudioLine> getInputs() {
        return Collections.unmodifiableList(this.inputs);
    }

    @Override
    protected void resizeBuffers() {
        super.resizeBuffers();
        this.sharedByteBuffer = this.createByteBuffer();
    }

    protected byte[] createByteBuffer() {
        this.checkFormat();
        byte[] ret = new byte[this._createAudioBuffer("hack").getByteArrayBufferSize(this.format)];
        return ret;
    }

    public int getOutputLatencyFrames() {
        if (this.syncLine == null) {
            return 0;
        }
        return this.syncLine.getLatencyFrames();
    }

    public int getInputLatencyFrames() {
        if (this.inputs.size() == 0) {
            return 0;
        }
        return this.inputs.get(0).getLatencyFrames();
    }

    public List<String> getAvailableOutputNames() {
        ArrayList<String> names = new ArrayList<String>();
        Mixer.Info[] infos = AudioSystem.getMixerInfo();
        int i = 0;
        while (i < infos.length) {
            Mixer mixer;
            Line.Info[] lines;
            if (!infos[i].getName().startsWith("Port ") && (lines = (mixer = AudioSystem.getMixer(infos[i])).getSourceLineInfo()).length > 0) {
                names.add(infos[i].getName());
            }
            ++i;
        }
        return names;
    }

    public List<String> getAvailableInputNames() {
        ArrayList<String> names = new ArrayList<String>();
        Mixer.Info[] infos = AudioSystem.getMixerInfo();
        int i = 0;
        while (i < infos.length) {
            Mixer mixer;
            Line.Info[] lines;
            if (!infos[i].getName().startsWith("Port ") && (lines = (mixer = AudioSystem.getMixer(infos[i])).getTargetLineInfo()).length > 0) {
                names.add(infos[i].getName());
            }
            ++i;
        }
        return names;
    }

    protected Mixer.Info inputForName(String name) {
        Mixer.Info[] infos = AudioSystem.getMixerInfo();
        int i = 0;
        while (i < infos.length) {
            Mixer mixer = AudioSystem.getMixer(infos[i]);
            Line.Info[] lines = mixer.getTargetLineInfo();
            if (lines.length > 0 && infos[i].getName().indexOf(name) >= 0) {
                return infos[i];
            }
            ++i;
        }
        System.out.println("Oops, no input named " + name);
        return null;
    }

    protected Mixer.Info outputForName(String name) {
        Mixer.Info[] infos = AudioSystem.getMixerInfo();
        int i = 0;
        while (i < infos.length) {
            Mixer mixer = AudioSystem.getMixer(infos[i]);
            Line.Info[] lines = mixer.getSourceLineInfo();
            if (lines.length > 0 && infos[i].getName().indexOf(name) >= 0) {
                return infos[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    protected void startImpl() {
        for (JavaSoundAudioLine javaSoundAudioLine : this.inputs) {
            try {
                javaSoundAudioLine.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (JavaSoundAudioLine javaSoundAudioLine : this.outputs) {
            try {
                javaSoundAudioLine.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.startImpl();
    }

    @Override
    protected void stopImpl() {
        super.stopImpl();
        for (JavaSoundAudioLine javaSoundAudioLine : this.outputs) {
            try {
                javaSoundAudioLine.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (JavaSoundAudioLine javaSoundAudioLine : this.inputs) {
            try {
                javaSoundAudioLine.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public IOAudioProcess openAudioOutput(String name, String label) throws Exception {
        JavaSoundAudioOutput output;
        boolean wasRunning = this.isRunning;
        this.checkFormat();
        if (this.isRunning) {
            this.stop();
        }
        if (name == null) {
            name = this.getAvailableOutputNames().get(0);
            System.out.println(String.valueOf(label) + " null name specified, using " + name);
        }
        try {
            output = new JavaSoundAudioOutput(this.format, this.outputForName(name), label);
            output.open();
            this.outputs.add(output);
        }
        finally {
            if (wasRunning) {
                this.start();
            } else {
                this.checkStart();
            }
        }
        return output;
    }

    public void closeAudioOutput(IOAudioProcess output) {
        if (!(output instanceof JavaSoundAudioOutput)) {
            throw new IllegalArgumentException(String.valueOf(output.getName()) + " is not a JavaSoundAudioOutput");
        }
        JavaSoundAudioOutput jsoutput = (JavaSoundAudioOutput)output;
        if (jsoutput.isActive()) {
            jsoutput.stop();
        }
        jsoutput.close();
        this.outputs.remove(output);
    }

    public IOAudioProcess openAudioInput(String name, String label) throws Exception {
        this.checkFormat();
        if (name == null) {
            name = this.getAvailableInputNames().get(0);
            System.out.println(String.valueOf(label) + " null name specified, using " + name);
        }
        JavaSoundAudioInput input = new JavaSoundAudioInput(this.format, this.inputForName(name), label);
        input.open();
        this.inputs.add(input);
        if (this.isRunning) {
            input.start();
        }
        return input;
    }

    public void closeAudioInput(IOAudioProcess input) {
        if (!(input instanceof JavaSoundAudioInput)) {
            throw new IllegalArgumentException(String.valueOf(input.getName()) + " is not a JavaSoundAudioInput");
        }
        JavaSoundAudioInput jsinput = (JavaSoundAudioInput)input;
        if (jsinput.isActive()) {
            jsinput.stop();
        }
        jsinput.close();
        this.inputs.remove(input);
    }

    @Override
    public void setLatencyMilliseconds(float ms) {
        if (ms < this.getLatencyMilliseconds()) {
            this.minimiseInputLatency();
        }
        super.setLatencyMilliseconds(ms);
    }

    protected void minimiseInputLatency() {
        for (JavaSoundAudioInput input : this.inputs) {
            input.flush();
        }
    }

    @Override
    protected void controlGained() {
        this.minimiseInputLatency();
        super.controlGained();
    }

    @Override
    public String getConfigKey() {
        return "javasound";
    }

    protected abstract class JavaSoundAudioLine
    implements AudioLine {
        protected AudioFormat format;
        protected Mixer.Info mixerInfo;
        protected String label;
        protected int latencyFrames = -1;
        protected ChannelFormat channelFormat;

        public JavaSoundAudioLine(AudioFormat format, Mixer.Info info, String label) {
            this.format = format;
            this.mixerInfo = info;
            this.label = label;
            switch (format.getChannels()) {
                case 1: {
                    this.channelFormat = ChannelFormat.MONO;
                    break;
                }
                case 2: {
                    this.channelFormat = ChannelFormat.STEREO;
                }
            }
        }

        public String getName() {
            return this.label;
        }

        public ChannelFormat getChannelFormat() {
            return this.channelFormat;
        }

        public int getLatencyFrames() {
            return this.latencyFrames;
        }

        public abstract void start() throws Exception;

        public abstract void stop() throws Exception;

        public abstract boolean isActive();
    }

    protected class JavaSoundAudioOutput
    extends JavaSoundAudioLine {
        protected SourceDataLine lineOut;
        protected DataLine.Info infoOut;
        protected long framesWritten;

        public JavaSoundAudioOutput(AudioFormat format, Mixer.Info info, String label) throws LineUnavailableException {
            super(format, info, label);
            this.framesWritten = 0L;
            this.infoOut = new DataLine.Info(SourceDataLine.class, format);
            if (!AudioSystem.getMixer(this.mixerInfo).isLineSupported(this.infoOut)) {
                throw new LineUnavailableException(info + " does not support " + this.infoOut);
            }
            if (JavaSoundAudioServer.this.syncLine == null) {
                JavaSoundAudioServer.this.syncLine = this;
            }
        }

        public void open() throws Exception {
            if (this.lineOut != null && this.lineOut.isOpen()) {
                return;
            }
            this.lineOut = (SourceDataLine)AudioSystem.getMixer(this.mixerInfo).getLine(this.infoOut);
            this.lineOut.open(this.format, JavaSoundAudioServer.this.lineBufferBytes);
            if (JavaSoundAudioServer.this.syncLine == this) {
                if (this.lineOut.getBufferSize() != JavaSoundAudioServer.this.lineBufferBytes) {
                    System.out.println("JavaSound Line buffer: " + JavaSoundAudioServer.this.lineBufferBytes + " bytes requested, " + this.lineOut.getBufferSize() + " bytes returned.");
                    JavaSoundAudioServer.this.lineBufferBytes = this.lineOut.getBufferSize();
                }
                JavaSoundAudioServer.this.maximumLatencyMilliseconds = (float)(1000 * JavaSoundAudioServer.this.lineBufferBytes / this.format.getFrameSize()) / this.format.getSampleRate();
                JavaSoundAudioServer.this.maximumLatencyMilliseconds -= 10.0f;
            }
        }

        public void start() throws Exception {
            this.framesWritten = this.lineOut.getLongFramePosition();
            this.lineOut.start();
        }

        public void stop() {
            this.lineOut.stop();
            this.lineOut.flush();
        }

        public void close() {
            if (this.lineOut != null && this.lineOut.isOpen()) {
                this.lineOut.close();
            }
        }

        public int processAudio(AudioBuffer buffer) {
            if (!buffer.isRealTime()) {
                return 0;
            }
            int nbytes = buffer.convertToByteArray(JavaSoundAudioServer.this.sharedByteBuffer, 0, this.format);
            if (this.lineOut.available() > JavaSoundAudioServer.this.sharedByteBuffer.length) {
                this.lineOut.write(JavaSoundAudioServer.this.sharedByteBuffer, 0, nbytes);
                this.framesWritten += (long)(nbytes / this.format.getFrameSize());
            }
            long framePos = this.lineOut.getLongFramePosition();
            this.latencyFrames = (int)(this.framesWritten - framePos);
            if (this.latencyFrames < 0) {
                this.latencyFrames = 0;
            }
            return 0;
        }

        public boolean isActive() {
            if (this.lineOut == null) {
                return false;
            }
            return this.lineOut.isActive();
        }
    }

    protected class JavaSoundAudioInput
    extends JavaSoundAudioLine {
        protected TargetDataLine lineIn;
        protected DataLine.Info infoIn;
        protected AudioBuffer.MetaInfo metaInfo;
        protected long framesRead;
        private boolean doFlush;

        public JavaSoundAudioInput(AudioFormat format, Mixer.Info info, String label) throws LineUnavailableException {
            super(format, info, label);
            this.framesRead = 0L;
            this.doFlush = false;
            this.infoIn = new DataLine.Info(TargetDataLine.class, format);
            if (!AudioSystem.getMixer(this.mixerInfo).isLineSupported(this.infoIn)) {
                throw new LineUnavailableException(this.mixerInfo + " does not support " + this.infoIn);
            }
            this.metaInfo = new AudioBuffer.MetaInfo(label);
        }

        public void open() throws Exception {
            if (this.lineIn != null && this.lineIn.isOpen()) {
                return;
            }
            this.lineIn = (TargetDataLine)AudioSystem.getMixer(this.mixerInfo).getLine(this.infoIn);
            this.lineIn.open(this.format, JavaSoundAudioServer.this.lineBufferBytes);
        }

        public void start() throws Exception {
            this.framesRead = this.lineIn.getLongFramePosition();
            this.lineIn.start();
        }

        public void stop() {
            this.lineIn.stop();
            this.lineIn.flush();
        }

        public void close() {
            if (this.lineIn != null && this.lineIn.isOpen()) {
                this.lineIn.close();
            }
        }

        public void flush() {
            this.doFlush = true;
        }

        public int processAudio(AudioBuffer buffer) {
            if (!buffer.isRealTime()) {
                return 1;
            }
            buffer.setMetaInfo(this.metaInfo);
            buffer.setChannelFormat(this.channelFormat);
            int avail = this.lineIn.available();
            if (avail < JavaSoundAudioServer.this.sharedByteBuffer.length) {
                buffer.makeSilence();
            } else {
                this.latencyFrames = (int)(this.lineIn.getLongFramePosition() - this.framesRead);
                this.lineIn.read(JavaSoundAudioServer.this.sharedByteBuffer, 0, JavaSoundAudioServer.this.sharedByteBuffer.length);
                buffer.initFromByteArray(JavaSoundAudioServer.this.sharedByteBuffer, 0, JavaSoundAudioServer.this.sharedByteBuffer.length, this.format);
                this.framesRead += (long)(JavaSoundAudioServer.this.sharedByteBuffer.length / this.format.getFrameSize());
                if (this.doFlush) {
                    long fp;
                    this.lineIn.flush();
                    this.framesRead = fp = this.lineIn.getLongFramePosition();
                    this.latencyFrames = 0;
                    this.doFlush = false;
                }
            }
            return 0;
        }

        public boolean isActive() {
            if (this.lineIn == null) {
                return false;
            }
            return this.lineIn.isActive();
        }
    }
}

