/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.server;

import uk.org.toot.audio.server.AudioClient;
import uk.org.toot.audio.server.AudioSyncLine;
import uk.org.toot.audio.server.AudioTimingStrategy;
import uk.org.toot.audio.server.ExtendedAudioServer;
import uk.org.toot.audio.server.SleepTimingStrategy;

public abstract class AbstractAudioServer
implements Runnable,
ExtendedAudioServer {
    protected AudioClient client;
    protected boolean isRunning = false;
    protected boolean hasStopped = false;
    private static long ONE_MILLION = 1000000L;
    private float bufferMilliseconds;
    private float requestedBufferMilliseconds = this.bufferMilliseconds = 2.0f;
    private float latencyMilliseconds = 70.0f;
    private float actualLatencyMilliseconds = 0.0f;
    private float lowestLatencyMilliseconds = this.bufferMilliseconds;
    private float maximumJitterMilliseconds = 0.0f;
    private int bufferUnderRuns = 0;
    private int bufferUnderRunThreshold = 0;
    private int outputLatencyFrames = 0;
    private int hardwareLatencyFrames = 0;
    private int totalLatencyFrames = -1;
    private long totalTimeNanos = (long)(this.bufferMilliseconds * (float)ONE_MILLION);
    private boolean requestResetMetrics = false;
    protected float maximumLatencyMilliseconds = 140.0f;
    private AudioTimingStrategy timingStrategy;
    private AudioTimingStrategy requestedTimingStrategy;
    private float load = 0.0f;
    private float peakLoad = 0.0f;
    private Thread thread;
    protected AudioSyncLine syncLine;
    private boolean startASAP = false;
    protected boolean started = false;
    protected int stableCount = 0;
    protected int stableThreshold = 1000;

    public AbstractAudioServer() {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    AbstractAudioServer.this.stop();
                }
            });
        }
        catch (Exception e) {
            System.out.println("AbstractAudioServer Failed to add Shutdown Hook");
        }
        String osName = System.getProperty("os.name");
        if (osName.contains("Windows")) {
            this.bufferUnderRunThreshold = 30;
        }
        this.requestedTimingStrategy = new SleepTimingStrategy();
    }

    public void setClient(AudioClient client) {
        this.client = client;
        this.checkStart();
    }

    protected abstract void work();

    protected void checkStart() {
        if (this.startASAP && this.canStart()) {
            this.startImpl();
        }
    }

    protected boolean canStart() {
        return this.client != null && this.syncLine != null;
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        if (this.canStart()) {
            this.startImpl();
        } else {
            System.out.println("AudioServer start requested but delayed");
            this.startASAP = true;
        }
    }

    protected void startImpl() {
        this.started = false;
        this.startASAP = false;
        this.stableCount = 0;
        System.out.println("AudioServer starting");
        this.thread = new Thread((Runnable)this, "AudioServer");
        this.thread.start();
    }

    public void stop() {
        if (!this.isRunning) {
            return;
        }
        this.stopImpl();
        while (!this.hasStopped) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void stopImpl() {
        System.out.println("AudioServer stopping");
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public int getHardwareLatencyFrames() {
        return this.hardwareLatencyFrames;
    }

    public void setHardwareLatencyFrames(int frames) {
        this.hardwareLatencyFrames = frames;
    }

    public int getTotalLatencyFrames() {
        return this.totalLatencyFrames + 2 * this.hardwareLatencyFrames;
    }

    public void run() {
        try {
            this.hasStopped = false;
            this.isRunning = true;
            this.client.setEnabled(true);
            long expiryTimeNanos = System.nanoTime();
            long compensationNanos = 0L;
            while (this.isRunning) {
                long startTimeNanos = System.nanoTime();
                float jitterMillis = (float)(startTimeNanos - expiryTimeNanos) / (float)ONE_MILLION;
                if (jitterMillis > this.maximumJitterMilliseconds) {
                    this.maximumJitterMilliseconds = jitterMillis;
                }
                this.sync();
                this.work();
                long endTimeNanos = System.nanoTime();
                this.load = (float)(endTimeNanos - startTimeNanos) / (float)this.totalTimeNanos;
                if (this.load > this.peakLoad) {
                    this.peakLoad = this.load;
                }
                this.outputLatencyFrames = this.syncLine.getLatencyFrames();
                this.totalLatencyFrames = this.outputLatencyFrames + this.getInputLatencyFrames();
                this.actualLatencyMilliseconds = (float)(1000 * this.outputLatencyFrames) / this.getSampleRate();
                float lowLatencyMillis = this.actualLatencyMilliseconds - this.bufferMilliseconds;
                if (lowLatencyMillis < (float)this.bufferUnderRunThreshold) {
                    if (this.started) {
                        ++this.bufferUnderRuns;
                        this.stableCount = 0;
                    }
                } else {
                    ++this.stableCount;
                    if (this.stableCount == this.stableThreshold) {
                        this.started = true;
                        this.controlGained();
                    }
                }
                if (lowLatencyMillis < this.lowestLatencyMilliseconds) {
                    this.lowestLatencyMilliseconds = lowLatencyMillis;
                }
                if (this.stableCount == 0) continue;
                compensationNanos = (long)((float)ONE_MILLION * (this.actualLatencyMilliseconds - this.latencyMilliseconds));
                expiryTimeNanos = startTimeNanos + this.totalTimeNanos + compensationNanos;
                long now = System.nanoTime();
                long sleepNanos = expiryTimeNanos - now;
                if (sleepNanos > 20000000L) {
                    sleepNanos = 20000000L;
                    expiryTimeNanos = now + sleepNanos;
                }
                if (sleepNanos > 500000L) {
                    this.timingStrategy.block(now, sleepNanos);
                    continue;
                }
                expiryTimeNanos = now;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.hasStopped = true;
        this.client.setEnabled(false);
    }

    protected void sync() {
        if (this.bufferMilliseconds != this.requestedBufferMilliseconds) {
            this.bufferMilliseconds = this.requestedBufferMilliseconds;
            this.totalTimeNanos = (long)(this.bufferMilliseconds * 1000000.0f);
            this.resizeBuffers();
        }
        if (this.requestedTimingStrategy != null) {
            this.timingStrategy = this.requestedTimingStrategy;
            this.thread.setPriority(this.timingStrategy.getThreadPriority());
            this.requestedTimingStrategy = null;
        }
        if (this.requestResetMetrics) {
            this.reset();
            this.requestResetMetrics = false;
        }
    }

    protected void controlGained() {
        this.resetMetrics(false);
    }

    public void resetMetrics(boolean resetUnderruns) {
        this.requestResetMetrics = true;
        if (resetUnderruns) {
            this.bufferUnderRuns = 0;
        }
    }

    protected void reset() {
        this.lowestLatencyMilliseconds = this.actualLatencyMilliseconds;
        this.maximumJitterMilliseconds = 0.0f;
        this.peakLoad = 0.0f;
    }

    public void setLatencyMilliseconds(float ms) {
        this.latencyMilliseconds = ms;
        this.resetMetrics(false);
    }

    public float getLatencyMilliseconds() {
        return this.latencyMilliseconds;
    }

    public float getActualLatencyMilliseconds() {
        return this.actualLatencyMilliseconds;
    }

    public float getLowestLatencyMilliseconds() {
        return this.lowestLatencyMilliseconds;
    }

    public float getMinimumLatencyMilliseconds() {
        return (float)this.bufferUnderRunThreshold + 5.0f;
    }

    public float getMaximumLatencyMilliseconds() {
        return this.maximumLatencyMilliseconds;
    }

    public float getMaximumJitterMilliseconds() {
        return this.maximumJitterMilliseconds;
    }

    public int getBufferUnderRuns() {
        return this.bufferUnderRuns;
    }

    public float getLoad() {
        return this.load;
    }

    public float getPeakLoad() {
        return this.peakLoad;
    }

    public float getBufferMilliseconds() {
        return this.bufferMilliseconds;
    }

    public void setBufferMilliseconds(float ms) {
        this.requestedBufferMilliseconds = ms;
    }

    public void setTimingStrategy(AudioTimingStrategy strategy) {
        this.requestedTimingStrategy = strategy;
    }

    protected abstract void resizeBuffers();
}

