/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.toot.javasoundmultiplexed;

import com.frinika.toot.javasoundmultiplexed.JavaSoundInDevice;
import com.frinika.toot.javasoundmultiplexed.JavaSoundOutDevice;
import java.util.List;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DeviceManager {
    private static int sampleRate = 44100;
    private static boolean bigEndian = false;
    static AudioFormat monoFormat = new AudioFormat(sampleRate, 16, 1, true, bigEndian);
    static AudioFormat stereoFormat = new AudioFormat(sampleRate, 16, 2, true, bigEndian);
    static AudioFormat format = new AudioFormat(sampleRate, 16, 0, true, bigEndian);
    Vector<JavaSoundOutDevice> outDevices = new Vector();
    Vector<JavaSoundInDevice> inDevices = new Vector();
    static DeviceManager the;

    public DeviceManager(int bufferSize) throws MyException {
        if (the != null) {
            throw new MyException(" JavaSoundConnectionManager is a singleton. ");
        }
        the = this;
        Mixer.Info[] mixerInfos = AudioSystem.getMixerInfo();
        int i = 0;
        while (i < mixerInfos.length) {
            block21: {
                System.out.println("********************\n Mixer " + i + ": " + mixerInfos[i].getName() + " desc: " + mixerInfos[i].getDescription() + " vend: " + mixerInfos[i].getVendor() + " ver: " + mixerInfos[i].getVersion());
                if (!mixerInfos[i].getName().startsWith("Port ")) {
                    Line.Info[] sourceLines;
                    Line.Info[] targetLines;
                    Mixer mixer = AudioSystem.getMixer(mixerInfos[i]);
                    if (mixer.isOpen()) {
                        System.out.println(" It's open already ");
                    } else {
                        try {
                            mixer.open();
                        }
                        catch (LineUnavailableException e) {
                            System.out.println(" Unavailable");
                            break block21;
                        }
                    }
                    Line.Info[] infoArray = targetLines = mixer.getTargetLineInfo();
                    int n = 0;
                    int n2 = infoArray.length;
                    while (n < n2) {
                        Line.Info info = infoArray[n];
                        try {
                            Line line = mixer.getLine(info);
                        }
                        catch (LineUnavailableException e) {
                            e.printStackTrace();
                        }
                        if (info instanceof DataLine.Info) {
                            DataLine.Info dinfo = (DataLine.Info)info;
                            AudioFormat widest = null;
                            int frameSize = 0;
                            AudioFormat[] audioFormatArray = dinfo.getFormats();
                            int n3 = 0;
                            int n4 = audioFormatArray.length;
                            while (n3 < n4) {
                                AudioFormat af = audioFormatArray[n3];
                                if (af.getEncoding() == format.getEncoding() && af.isBigEndian() == format.isBigEndian() && af.getSampleSizeInBits() == format.getSampleSizeInBits() && af.getFrameSize() > frameSize) {
                                    widest = af;
                                    frameSize = af.getFrameSize();
                                }
                                ++n3;
                            }
                            if (widest != null) {
                                JavaSoundInDevice device = new JavaSoundInDevice(mixer, new AudioFormat(sampleRate, 16, widest.getChannels(), true, bigEndian), dinfo, bufferSize);
                                System.out.println(" IN: " + device.getName());
                                this.inDevices.add(device);
                            }
                        }
                        ++n;
                    }
                    Line.Info[] infoArray2 = sourceLines = mixer.getSourceLineInfo();
                    n2 = 0;
                    int n5 = infoArray2.length;
                    while (n2 < n5) {
                        block22: {
                            Line.Info info = infoArray2[n2];
                            Line line = null;
                            try {
                                line = mixer.getLine(info);
                                if (!(line instanceof SourceDataLine)) break block22;
                                System.out.println(info + " | " + line);
                            }
                            catch (LineUnavailableException e) {
                                e.printStackTrace();
                            }
                            if (info instanceof DataLine.Info) {
                                DataLine.Info dinfo = (DataLine.Info)info;
                                AudioFormat widest = null;
                                int frameSize = 0;
                                AudioFormat[] audioFormatArray = dinfo.getFormats();
                                int n6 = 0;
                                int n7 = audioFormatArray.length;
                                while (n6 < n7) {
                                    AudioFormat af = audioFormatArray[n6];
                                    if (af.getEncoding() == format.getEncoding() && af.isBigEndian() == format.isBigEndian() && af.getSampleSizeInBits() == format.getSampleSizeInBits() && af.getFrameSize() > frameSize) {
                                        widest = af;
                                        frameSize = af.getFrameSize();
                                    }
                                    ++n6;
                                }
                                if (widest != null) {
                                    JavaSoundOutDevice device = new JavaSoundOutDevice(mixer, new AudioFormat(sampleRate, 16, widest.getChannels(), true, bigEndian), dinfo, bufferSize);
                                    System.out.println(" OUT: " + device.getName());
                                    this.outDevices.add(device);
                                }
                            }
                        }
                        ++n2;
                    }
                    mixer.close();
                }
            }
            ++i;
        }
    }

    JavaSoundOutDevice getOutDevice(String name) {
        for (JavaSoundOutDevice dev : this.outDevices) {
            if (!name.equals(dev.getName())) continue;
            return dev;
        }
        return null;
    }

    JavaSoundInDevice getInDevice(String name) {
        for (JavaSoundInDevice dev : this.inDevices) {
            if (!name.equals(dev.getName())) continue;
            return dev;
        }
        return null;
    }

    List<String> getInDeviceList() {
        Vector<String> list = new Vector<String>();
        for (JavaSoundInDevice in : this.inDevices) {
            list.add(in.getName());
        }
        return list;
    }

    List<String> getOutDeviceList() {
        Vector<String> list = new Vector<String>();
        for (JavaSoundOutDevice in : this.outDevices) {
            list.add(in.getName());
        }
        return list;
    }

    class MyException
    extends Exception {
        MyException(String str) {
            super(str);
        }
    }
}

