/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.toot;

import com.frinika.priority.Priority;
import uk.org.toot.audio.server.BasicAudioServer;

public abstract class PriorityAudioServer
extends BasicAudioServer {
    private int priorityRequested = -1;
    private int priority = 0;
    private boolean watchDogAlert = false;
    private static boolean isLinux = System.getProperty("os.name").equals("Linux");
    private static long watchDogTimestamp;

    static {
        if (isLinux) {
            Thread thr = new Thread(){

                public void run() {
                    while (true) {
                        watchDogTimestamp = System.currentTimeMillis();
                        try {
                            1.sleep(1L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            thr.setPriority(1);
            thr.start();
        }
    }

    public void work() {
        if (isLinux) {
            if (System.currentTimeMillis() - watchDogTimestamp > 100L) {
                if (!this.watchDogAlert) {
                    System.out.println("PRIORITY THREAD WATCHDOG: System was blocked for at least " + (System.currentTimeMillis() - watchDogTimestamp) + " ms, setting temporary normal priority ");
                    Priority.setPriorityOTHER(0);
                    this.watchDogAlert = true;
                }
            } else if (this.watchDogAlert) {
                this.watchDogAlert = false;
                this.priorityRequested = this.priority;
            }
            if (this.priorityRequested != -1 && !this.watchDogAlert) {
                try {
                    int prio = this.priorityRequested;
                    if (prio > 0) {
                        Priority.setPriorityRR(prio);
                    } else {
                        Priority.setPriorityOTHER(prio);
                    }
                    Priority.display();
                }
                catch (Throwable e) {
                    System.err.println("WARN: Problem setting priority " + e.toString());
                }
                this.priority = this.priorityRequested;
                this.priorityRequested = -1;
            }
        }
        super.work();
    }

    public void requestPriority(int i) {
        this.priorityRequested = i;
    }

    public int getPriority() {
        if (this.priorityRequested != -1) {
            return this.priorityRequested;
        }
        return this.priority;
    }

    public void assertPriority() {
        this.priorityRequested = this.priority;
    }
}

