/*
 * Decompiled with CFR 0.152.
 */
package uk.co.simphoney.audio.midi;

import com.frinika.global.FrinikaConfig;
import com.frinika.sequencer.FrinikaSequencer;
import com.frinika.sequencer.model.AudioPart;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.audio.AudioClipReader;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import uk.co.simphoney.audio.constantq.FFTConstantQ;
import uk.co.simphoney.audio.constantq.FreqToBin;
import uk.co.simphoney.audio.gui.SpectrogramPanelOLD;

public class AudioPartToMidi {
    public static MidiPart process(AudioPart part) throws IOException {
        int j;
        int i;
        double dt = 0.01;
        double Fs = FrinikaConfig.sampleRate;
        MidiPart midiPart = new MidiPart();
        int maxpixels = 1000;
        JFrame frame = new JFrame();
        JProgressBar bar = new JProgressBar(0, maxpixels);
        frame.setContentPane(bar);
        frame.pack();
        frame.setVisible(true);
        double minF = 40.0;
        double maxF = Math.pow(2.0, 7.0) * minF;
        int binsPerOctave = 12;
        double thresh = 0.01;
        int chunksize = (int)(Fs * dt);
        dt = (double)chunksize / Fs;
        FFTConstantQ fftCQ = new FFTConstantQ(Fs, minF, maxF, binsPerOctave, thresh, 1.0);
        int fftsize = fftCQ.getFFTSize();
        double[] freq = fftCQ.getFreqs();
        System.out.println(" fftsize/chunkSIze = " + fftsize + "/" + chunksize);
        int nBin = fftCQ.getNumberOfOutputBands();
        double twoPI = Math.PI * 2;
        double[] dPhaRef = new double[nBin];
        for (int i2 = 0; i2 < nBin; ++i2) {
            dPhaRef[i2] = twoPI * freq[i2] * dt;
        }
        double[][] gbuffer = new double[maxpixels][nBin];
        double[][] dgbuffer = new double[maxpixels][nBin];
        double[][] pFreq = new double[maxpixels][nBin];
        double[] fftOut = new double[nBin * 2];
        double[] fftIn = new double[fftsize];
        double[] input = new double[fftsize];
        FrinikaSequencer seq = part.getLane().getProject().getSequencer();
        long startFrame = (long)((double)seq.getMicrosecondPosition() * Fs / 1000000.0);
        System.out.println("start =" + startFrame);
        AudioClipReader reader = part.createClipReader();
        reader.seekFrame(startFrame);
        double testF = minF * 2.0;
        int ch = reader.getChannels();
        double[] buffer = new double[chunksize * ch];
        int pix = 0;
        double realmaxdB = -10000.0;
        double maxdB = -40.0;
        double rangeDb = 40.0;
        double satdB = 20.0;
        double peak = 0.0;
        double[] phase = new double[nBin];
        do {
            int i3;
            if (fftsize != chunksize) {
                for (i3 = 0; i3 < fftsize - chunksize; ++i3) {
                    input[i3] = input[i3 + chunksize];
                }
            }
            reader.readNextDouble(buffer, 0, chunksize);
            i3 = fftsize - chunksize;
            int j2 = 0;
            while (i3 < fftsize) {
                input[i3] = ch == 2 ? buffer[2 * j2 + 1] : buffer[j2];
                if (Math.abs(input[i3]) > peak) {
                    peak = Math.abs(input[i3]);
                }
                ++i3;
                ++j2;
            }
            for (i3 = 0; i3 < fftsize; ++i3) {
                fftIn[i3] = input[i3];
            }
            fftCQ.calc(fftIn, fftOut);
            double[] vertPtr = gbuffer[pix];
            double[] pfPtr = pFreq[pix];
            for (int i4 = 0; i4 < nBin; ++i4) {
                double real = fftOut[2 * i4];
                double imag = fftOut[2 * i4 + 1];
                double magn = Math.sqrt(real * real + imag * imag);
                double pha = Math.atan2(imag, real);
                double dpha = pha - phase[i4];
                vertPtr[i4] = magn;
                phase[i4] = pha;
                dpha = -((dPhaRef[i4] - dpha + Math.PI + twoPI) % twoPI - Math.PI);
                pfPtr[i4] = freq[i4] + dpha / twoPI / dt;
            }
            bar.setValue(++pix);
        } while (!reader.endOfFile() && pix < maxpixels);
        double dMax = 0.0;
        double dMin = 0.0;
        double[] state = new double[nBin];
        double halfLife = 0.01;
        double halfLifeInChunks = halfLife * Fs / (double)chunksize;
        double damp = Math.exp(Math.log(0.5) / halfLifeInChunks);
        double damp2 = 1.0 - damp;
        for (i = 0; i < maxpixels - 1; ++i) {
            for (j = 0; j < nBin; ++j) {
                double stateNew = state[j] * damp + gbuffer[i][j] * damp2;
                dgbuffer[i][j] = stateNew - state[j];
                dMax = Math.max(dgbuffer[i][j], dMax);
                dMin = Math.min(dgbuffer[i][j], dMin);
                state[j] = stateNew;
            }
        }
        for (i = 0; i < maxpixels; ++i) {
            for (j = 0; j < nBin; ++j) {
                dgbuffer[i][j] = (dgbuffer[i][j] - dMin) / (dMax - dMin);
            }
        }
        for (i = 0; i < maxpixels; ++i) {
            for (j = 0; j < nBin; ++j) {
                double dB;
                double magn = gbuffer[i][j];
                gbuffer[i][j] = dB = 20.0 * Math.log10(4.0 * magn + 1.0E-15);
                if (!(dB > realmaxdB)) continue;
                realmaxdB = dB;
            }
        }
        System.out.println(" real max dB= " + realmaxdB + " peak value =" + peak);
        realmaxdB -= satdB;
        for (i = 0; i < maxpixels; ++i) {
            for (j = 0; j < nBin; ++j) {
                gbuffer[i][j] = (gbuffer[i][j] + rangeDb - realmaxdB) / rangeDb;
            }
        }
        SpectrogramPanelOLD panel = new SpectrogramPanelOLD();
        panel.setData(gbuffer, pFreq, freq, dt, new FreqToBin(minF, binsPerOctave), 0.3, dgbuffer);
        JScrollPane scroll = new JScrollPane(panel);
        frame.setContentPane(scroll);
        frame.pack();
        return midiPart;
    }
}

