/*
 * Decompiled with CFR 0.152.
 */
package uk.co.simphoney.audio.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.util.Observable;
import java.util.Observer;
import uk.co.simphoney.audio.Mapper;
import uk.co.simphoney.audio.SpectrogramDataListener;
import uk.co.simphoney.audio.SpectrumDataBuilder;

public class SpectrogramImage
extends Observable
implements SpectrogramDataListener,
Observer {
    private static final long serialVersionUID = 1L;
    BufferedImage img;
    Graphics2D graphic;
    private int[] rgbarray;
    Dimension imageSize;
    Dimension size;
    int scaleX = 1;
    int scaleY = 2;
    private boolean dirty = true;
    private double thresh;
    private SpectrumDataBuilder data;
    static final int nLevel = 256;
    static Color[] fcol = new Color[256];
    int nChunks;
    int nBins;
    private int renderedCount;
    Mapper mapper;

    public SpectrogramImage(SpectrumDataBuilder data, Mapper mapper) {
        for (int i = 0; i < 256; ++i) {
            SpectrogramImage.fcol[i] = new Color(255, 0, 0, i);
        }
        this.renderedCount = 0;
        this.mapper = mapper;
        this.data = data;
    }

    void createGraphics() {
        this.imageSize = new Dimension(this.nChunks, this.nBins);
        this.size = new Dimension(this.nChunks * this.scaleX, this.nBins * this.scaleY);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
        this.img = graphicsConfiguration.createCompatibleImage(this.imageSize.width, this.imageSize.height, 2);
        this.graphic = this.img.createGraphics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeImage() {
        SpectrumDataBuilder spectrumDataBuilder = this.data;
        synchronized (spectrumDataBuilder) {
            float[][] buffer;
            int chunksToRender = this.data.getChunkRenderedCount();
            System.out.println(this.renderedCount + "  ->  " + chunksToRender);
            this.nBins = this.data.getBinCount();
            this.nChunks = this.data.getSizeInChunks();
            if (this.nChunks == 0 || this.nBins == 0) {
                return;
            }
            if (this.imageSize == null || this.nBins != this.imageSize.height || this.nChunks != this.imageSize.width) {
                this.createGraphics();
            }
            if (this.rgbarray == null || this.rgbarray.length < this.nBins) {
                this.rgbarray = new int[this.nBins];
            }
            if ((buffer = this.data.getSMagnitude()) == null) {
                return;
            }
            while (this.renderedCount < chunksToRender) {
                if (Thread.interrupted()) {
                    return;
                }
                for (int i = 0; i < this.nBins; ++i) {
                    int color;
                    int c_r;
                    int bin = this.nBins - i - 1;
                    float val = this.mapper.eval(buffer[this.renderedCount][bin]);
                    if (val < 0.0f) {
                        val = 0.0f;
                    }
                    if ((double)val > 1.0) {
                        val = 1.0f;
                    }
                    int c_g = c_r = (int)(255.0f * val);
                    int c_b = 255 - c_r;
                    this.rgbarray[i] = color = c_b + (c_g << 8) + (c_r << 16) + -16777216;
                }
                this.img.setRGB(this.renderedCount, 0, 1, this.imageSize.height, this.rgbarray, 0, 1);
                ++this.renderedCount;
            }
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void notifySizeChange(Dimension d) {
        this.renderedCount = 0;
        System.out.println(" Completely makeing spectrogram image ");
        this.makeImage();
    }

    public void drawImage(Graphics2D g, int i, int j) {
        if (this.img == null) {
            return;
        }
        g.setColor(Color.WHITE);
        g.drawImage(this.img, i, j, this.size.width, this.size.height, 0, 0, this.imageSize.width, this.imageSize.height, null);
        g.setColor(Color.GREEN);
        g.drawString(" Spectrogram ", i + 10, j + 10);
    }

    public int getHeight() {
        if (this.size == null) {
            return 200;
        }
        return this.size.height;
    }

    public void update(Observable o, Object arg) {
        System.out.println(" Spectrogram image update ");
        this.renderedCount = 0;
        this.makeImage();
    }

    public void notifyMoreDataReady() {
        this.makeImage();
    }
}

