/*
 * Decompiled with CFR 0.152.
 */
package uk.co.simphoney.audio.dft;

import com.frinika.global.FrinikaConfig;
import java.awt.Dimension;
import java.util.Vector;
import rasmus.interpreter.sampled.util.FFT;
import uk.co.simphoney.audio.dft.CyclicSpectrumDataBuilder;
import uk.co.simphoney.audio.gui.CyclicSpectrogramDataListener;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.AudioProcess;

public class CyclicBufferFFTSpectrogramDataBuilder
implements CyclicSpectrumDataBuilder {
    Vector<CyclicSpectrogramDataListener> sizeObservers = new Vector();
    private AudioProcess reader;
    private float[][] magnArray;
    private float[][] smoothMagnArray;
    private float[][] phaseArray;
    private float[][] dPhaseFreqHz;
    float[] freqArray;
    double[] freq;
    int chunkPtr = 0;
    private int sizeInChunks;
    private int nBin;
    double Fs = FrinikaConfig.sampleRate;
    int chunksize;
    int fftsize;
    double dt;
    Dimension size;
    private int chunkStartInSamples;
    private int totalFramesRendered;
    private FFT fft;
    private double[] hanning;
    private double[] dPhaRef;
    private double[] fftOut;
    private double[] input;
    private double[] logMagn;
    private double twoPI;
    private AudioBuffer buffer;
    boolean abortFlag = false;
    private boolean running = false;
    private Thread runThread = null;
    private Thread abortWaiter;

    public CyclicBufferFFTSpectrogramDataBuilder(AudioProcess reader, int bufferSize) {
        this.reader = reader;
        this.sizeInChunks = bufferSize;
        this.twoPI = Math.PI * 2;
    }

    public synchronized void setParameters(int chunksize, int fftsize) {
        System.err.println(" AAAA ");
        if (chunksize == this.chunksize && fftsize == this.fftsize) {
            return;
        }
        System.out.println(" ABORT REQUEST " + System.currentTimeMillis());
        this.abortFlag = true;
        this.abortWaiter = Thread.currentThread();
        while (this.running) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.abortWaiter = null;
        System.out.println(" ABORT DONE " + System.currentTimeMillis());
        this.buffer = new AudioBuffer("TEMP", 1, chunksize, 44100.0f);
        this.Fs = FrinikaConfig.sampleRate;
        this.chunksize = chunksize;
        this.fftsize = fftsize;
        this.dt = (double)chunksize / this.Fs;
        System.out.println(" RESIZE FFT REQUEST " + System.currentTimeMillis());
        this.resize();
        System.out.println(" RESIZE FFT DONE " + System.currentTimeMillis());
        Runnable runner = new Runnable(){

            public void run() {
                CyclicBufferFFTSpectrogramDataBuilder.this.doWork();
                CyclicBufferFFTSpectrogramDataBuilder.this.runThread = null;
            }
        };
        this.runThread = new Thread(runner);
        this.runThread.start();
    }

    public void abortConstruction() {
    }

    public void addSizeObserver(CyclicSpectrogramDataListener o) {
        this.sizeObservers.add(o);
    }

    void notifyMoreDataObservers(float[] buff) {
        for (CyclicSpectrogramDataListener o : this.sizeObservers) {
            o.notifyMoreDataReady(buff);
        }
    }

    public int getSizeInChunks() {
        return this.sizeInChunks;
    }

    public int getChunkRenderedCount() {
        return this.totalFramesRendered;
    }

    public int getBinCount() {
        return this.nBin;
    }

    public float[][] getMagnitude() {
        return this.magnArray;
    }

    public float[][] getSmoothMagnitude() {
        return this.smoothMagnArray;
    }

    synchronized void resize() {
        int i;
        this.fft = new FFT(this.fftsize);
        this.nBin = this.fftsize / 2;
        this.hanning = this.fft.wHanning();
        this.freqArray = new float[this.nBin];
        this.freq = new double[this.nBin];
        for (i = 0; i < this.nBin; ++i) {
            this.freq[i] = (double)i * this.Fs / (double)this.nBin;
            this.freqArray[i] = (float)this.freq[i];
            this.size = new Dimension(this.sizeInChunks, this.nBin);
            this.dPhaseFreqHz = new float[this.sizeInChunks][this.nBin];
            this.magnArray = new float[this.sizeInChunks][this.nBin];
            this.smoothMagnArray = new float[this.sizeInChunks][this.nBin];
            this.logMagn = new double[this.nBin * 2];
            this.phaseArray = new float[this.sizeInChunks][this.nBin];
        }
        this.dPhaRef = new double[this.nBin];
        for (i = 0; i < this.nBin; ++i) {
            this.dPhaRef[i] = this.twoPI * this.freq[i] * this.dt;
        }
        this.fftOut = new double[this.fftsize * 2];
        this.input = new double[this.fftsize];
        System.out.println(" Resized " + this.fftsize);
    }

    protected void doWork() {
        this.running = true;
        this.abortFlag = false;
        this.chunkPtr = 0;
        int nRead = 0;
        this.chunkStartInSamples = 0;
        float[] phaLast = this.phaseArray[0];
        double maxV = 0.0;
        this.totalFramesRendered = 0;
        while (!this.abortFlag) {
            if (this.fftsize != this.chunksize) {
                for (int i = 0; i < this.fftsize - this.chunksize; ++i) {
                    this.input[i] = this.input[i + this.chunksize];
                }
            }
            this.buffer.makeSilence();
            int stat = this.reader.processAudio(this.buffer);
            nRead += this.chunksize;
            float[] left = this.buffer.getChannel(0);
            int i = this.fftsize - this.chunksize;
            int j = 0;
            while (i < this.fftsize) {
                this.input[i] = left[j];
                ++i;
                ++j;
            }
            if (this.chunkPtr < 0) {
                ++this.chunkPtr;
                this.chunkStartInSamples += this.chunksize;
                continue;
            }
            for (i = 0; i < this.fftsize; ++i) {
                this.fftOut[i] = this.input[i] * this.hanning[i];
            }
            this.fft.calcReal(this.fftOut, -1);
            for (i = 0; i < this.nBin; ++i) {
                double real = this.fftOut[2 * i];
                double imag = this.fftOut[2 * i + 1];
                this.magnArray[this.chunkPtr][i] = (float)Math.sqrt(real * real + imag * imag);
                maxV = Math.max(maxV, (double)this.magnArray[this.chunkPtr][i]);
                this.phaseArray[this.chunkPtr][i] = (float)Math.atan2(imag, real);
                double dpha = this.phaseArray[this.chunkPtr][i] - phaLast[i];
                dpha = -((this.dPhaRef[i] - dpha + Math.PI + this.twoPI) % this.twoPI - Math.PI);
                this.dPhaseFreqHz[this.chunkPtr][i] = (float)(this.freq[i] + dpha / this.twoPI / this.dt);
            }
            phaLast = this.phaseArray[this.chunkPtr];
            this.notifyMoreDataObservers(this.magnArray[this.chunkPtr]);
            ++this.chunkPtr;
            ++this.totalFramesRendered;
            if (this.chunkPtr < this.sizeInChunks) continue;
            this.chunkPtr = 0;
        }
        this.running = false;
        this.abortFlag = false;
        if (this.abortWaiter != null) {
            this.abortWaiter.interrupt();
        }
        System.out.println(" ABORTED ");
    }

    public float[] getFreqArray() {
        return this.freqArray;
    }

    public float[] getMagnitudeAt(long chunkPtr) {
        if (this.magnArray == null) {
            return null;
        }
        if (chunkPtr >= (long)this.magnArray.length || chunkPtr < 0L) {
            return null;
        }
        return this.magnArray[(int)chunkPtr];
    }

    public float[] getPhaseAt(long chunkPtr) {
        if (this.phaseArray == null) {
            return null;
        }
        if (chunkPtr >= (long)this.phaseArray.length || chunkPtr < 0L) {
            return null;
        }
        return this.phaseArray[(int)chunkPtr];
    }

    public float[] getPhaseFreqAt(long chunkPtr) {
        if (this.dPhaseFreqHz == null) {
            return null;
        }
        if (chunkPtr >= (long)this.dPhaseFreqHz.length) {
            return null;
        }
        return this.dPhaseFreqHz[(int)chunkPtr];
    }

    public long chunkStartInSamples(long chunkPtr) {
        return (long)this.chunkStartInSamples + chunkPtr * (long)this.chunksize;
    }

    public int getChunkAtFrame(long framePtr) {
        int chunkPtr = (int)((framePtr - (long)this.chunkStartInSamples) / (long)this.chunksize);
        return chunkPtr;
    }

    public boolean validAt(long chunkPtr2) {
        return chunkPtr2 >= 0L && chunkPtr2 < (long)this.chunkPtr;
    }

    public double getSampleRate() {
        return this.Fs;
    }
}

