/*
 * Decompiled with CFR 0.152.
 */
package uk.co.simphoney.audio.dft;

import com.frinika.global.FrinikaConfig;
import com.frinika.sequencer.model.audio.AudioReader;
import java.awt.Dimension;
import java.io.IOException;
import uk.co.simphoney.audio.DataBuilder;
import uk.co.simphoney.audio.SpectrogramDataListener;
import uk.co.simphoney.audio.dft.ChunkReaderProcess;
import uk.co.simphoney.audio.dft.FFTSpectrumClient;
import uk.org.toot.audio.core.AudioBuffer;

public class ChunkFeeder
extends DataBuilder {
    FFTSpectrumClient client;
    private int chunkStartInSamples;
    int chunksize;
    int fftsize;
    private AudioReader reader;
    int chunkPtr = 0;
    int nFrame;
    private int sizeInChunks;
    private Dimension size;
    private int nBin;
    ChunkReaderProcess process;

    public void setParameters(int chunkSize, int fftsize, AudioReader reader, ChunkReaderProcess process, FFTSpectrumClient client) {
        this.abortConstruction();
        this.reader = reader;
        this.process = process;
        this.client = client;
        if (chunkSize == this.chunksize && fftsize == this.fftsize) {
            return;
        }
        this.nFrame = reader.getLengthInFrames();
        System.out.println(" NFRAME = " + this.nFrame);
        if (this.nFrame == 0) {
            System.out.println(" Seeting nFrame to 1000000 ");
            this.nFrame = 100000;
        }
        this.chunksize = chunkSize;
        this.fftsize = fftsize;
        this.sizeInChunks = this.nFrame / this.chunksize;
        System.out.println("SIZE IN CHUNKS = " + this.sizeInChunks);
        double dt = chunkSize / FrinikaConfig.sampleRate;
        process.setParameters(fftsize);
        this.nBin = process.getBinCount();
        this.size = new Dimension(this.sizeInChunks, this.nBin);
        client.setSize(this.sizeInChunks, this.nBin, process.getFreqArray(), dt);
        this.startConstruction();
    }

    protected void doWork() {
        double[] fftOut = new double[this.fftsize * 2];
        double[] input = new double[this.fftsize];
        try {
            this.reader.seekFrame(0L, false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int ch = this.reader.getChannels();
        int nRead = 0;
        AudioBuffer buffer = new AudioBuffer("TEMP", ch, this.chunksize, 44100.0f);
        this.chunkPtr = 0;
        this.notifySizeObservers();
        this.chunkStartInSamples = 0;
        double maxV = 0.0;
        do {
            if (Thread.interrupted()) {
                return;
            }
            if (this.fftsize != this.chunksize) {
                for (int i = 0; i < this.fftsize - this.chunksize; ++i) {
                    input[i] = input[i + this.chunksize];
                }
            }
            buffer.makeSilence();
            try {
                this.reader.processAudio(buffer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            nRead += this.chunksize;
            float[] left = buffer.getChannel(0);
            int i = this.fftsize - this.chunksize;
            int j = 0;
            while (i < this.fftsize) {
                input[i] = left[j];
                ++i;
                ++j;
            }
            for (i = 0; i < this.fftsize; ++i) {
                fftOut[i] = input[i];
            }
            double[] spectrum = this.process.process(fftOut);
            this.client.process(spectrum, this.nBin);
            ++this.chunkPtr;
            this.chunkStartInSamples += this.chunksize;
        } while (this.chunkPtr < this.sizeInChunks);
        System.out.println(" DATA BUILT maqxV " + maxV);
        this.notifyMoreDataObservers();
    }

    public void addSizeObserver(SpectrogramDataListener o) {
        this.sizeObservers.add(o);
    }

    void notifySizeObservers() {
        for (SpectrogramDataListener o : this.sizeObservers) {
            o.notifySizeChange(this.size);
        }
    }

    void notifyMoreDataObservers() {
        for (SpectrogramDataListener o : this.sizeObservers) {
            o.notifyMoreDataReady();
        }
    }

    public long chunkStartInSamples(long chunkPtr) {
        return (long)this.chunkStartInSamples + chunkPtr * (long)this.chunksize;
    }

    public int getChunkAtFrame(long framePtr) {
        int chunkPtr = (int)((framePtr - (long)this.chunkStartInSamples) / (long)this.chunksize);
        return chunkPtr;
    }

    public boolean validAt(long chunkPtr2) {
        return chunkPtr2 >= 0L && chunkPtr2 < (long)this.chunkPtr;
    }
}

