/*
 * Decompiled with CFR 0.152.
 */
package uk.co.simphoney.audio.constantq;

import java.awt.Dimension;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeSet;
import uk.co.simphoney.audio.Oscillator;
import uk.co.simphoney.audio.OscillatorNode;
import uk.co.simphoney.audio.SpectrogramDataListener;
import uk.co.simphoney.audio.constantq.ConstantQSpectrogramDataBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpectrogramToWave
implements SpectrogramDataListener,
Observer {
    public ConstantQSpectrogramDataBuilder data;
    int dataPtr = 0;
    private int nChunk;
    private int nBin;
    Thread buildThread;
    int renderCount;
    boolean rebuild = false;
    TreeSet<Oscillator> activeOscillator = new TreeSet();
    int[] peaks;
    final TreeSet<OscillatorNode> vertCache = new TreeSet();

    public SpectrogramToWave(ConstantQSpectrogramDataBuilder data) {
        this.data = data;
        data.addSizeObserver(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doWork() {
        boolean ptr = false;
        ConstantQSpectrogramDataBuilder constantQSpectrogramDataBuilder = this.data;
        synchronized (constantQSpectrogramDataBuilder) {
            int end = this.data.getChunkRenderedCount();
            while (this.renderCount < end) {
                this.getPeaks(this.renderCount);
                ++this.renderCount;
            }
        }
    }

    public TreeSet<? extends Oscillator> getPeaks(long chunkPtr) {
        this.vertCache.clear();
        if (!this.data.validAt(chunkPtr)) {
            System.out.println(" Data not ready at " + chunkPtr);
            return this.vertCache;
        }
        float[] freqs = this.data.getFreqArray();
        this.peaks = new int[freqs.length];
        float[] magn = this.data.getMagnitudeAt(chunkPtr);
        float[] pfreq = this.data.getPhaseFreqAt(chunkPtr);
        float[] phase = this.data.getPhaseAt(chunkPtr);
        long sampleTime = this.data.chunkStartInSamples(chunkPtr);
        int cnt = this.getPeaks(magn, this.peaks, 0.1f);
        for (int i = 0; i < cnt; ++i) {
            int ifreq = this.peaks[i];
        }
        return this.vertCache;
    }

    private int getPeaks(float[] a, int[] peaks, float threshold) {
        float max = 0.0f;
        int imax = -1;
        int cnt = 0;
        for (int i = 1; i < a.length - 1; ++i) {
            if (a[i] < threshold || !(a[i] >= a[i - 1]) || !(a[i] > a[i + 1])) continue;
            peaks[cnt++] = i;
        }
        return cnt;
    }

    @Override
    public void update(Observable arg0, Object arg) {
        this.dataPtr = (Integer)arg;
    }

    @Override
    public void notifySizeChange(Dimension d) {
        this.nChunk = d.width;
        this.nBin = d.height;
        this.rebuild = true;
    }

    @Override
    public void notifyMoreDataReady() {
        this.doWork();
    }

    public TreeSet<? extends Oscillator> getPeaksAtFrame(long framePtr) {
        int chunkPtr = this.data.getChunkAtFrame(framePtr);
        return this.getPeaks(chunkPtr);
    }
}

