/*
 * Decompiled with CFR 0.152.
 */
package uk.co.simphoney.audio.constantq;

import com.frinika.global.FrinikaConfig;
import com.frinika.sequencer.model.audio.AudioReader;
import java.awt.Dimension;
import java.io.IOException;
import rasmus.interpreter.sampled.util.FFT;
import uk.co.simphoney.audio.DataBuilder;
import uk.co.simphoney.audio.SpectrogramDataListener;
import uk.co.simphoney.audio.SpectrumDataBuilder;
import uk.co.simphoney.audio.StaticSpectrogramSynth;
import uk.co.simphoney.audio.constantq.FFTConstantQ;
import uk.org.toot.audio.core.AudioBuffer;

public class ConstantQSpectrogramDataBuilder
extends DataBuilder
implements SpectrumDataBuilder {
    private AudioReader reader;
    private float[][] magnArray;
    private float[][] phaseArray;
    private float[][] dPhaseFreqHz;
    float[] freqArray;
    int chunkPtr = 0;
    private int sizeInChunks;
    private int nBin;
    double dt = 0.01;
    double Fs = FrinikaConfig.sampleRate;
    int nFrame;
    double minF;
    double maxF;
    int binsPerOctave = 12;
    double thresh = 0.01;
    int chunksize;
    Dimension size;
    double spread;
    private int chunkStartInSamples;
    FFTConstantQ fftCQ;

    public void setParameters(AudioReader reader, double minF, double maxF, int binsPerOctave, double thresh, double spread, double dt) {
        this.abortConstruction();
        this.reader = reader;
        if (minF == this.minF && maxF == this.maxF && binsPerOctave == this.binsPerOctave && thresh == this.thresh && this.spread == spread && this.dt == dt) {
            return;
        }
        this.dt = dt;
        this.Fs = FrinikaConfig.sampleRate;
        this.nFrame = reader.getLengthInFrames();
        this.minF = minF;
        this.maxF = maxF;
        this.binsPerOctave = binsPerOctave;
        this.thresh = thresh;
        this.spread = spread;
        this.chunksize = (int)(this.Fs * dt);
        this.sizeInChunks = this.nFrame / this.chunksize;
        this.startConstruction();
    }

    public void addSizeObserver(SpectrogramDataListener o) {
        this.sizeObservers.add(o);
    }

    void notifySizeObservers() {
        for (SpectrogramDataListener o : this.sizeObservers) {
            o.notifySizeChange(this.size);
        }
    }

    void notifyMoreDataObservers() {
        for (SpectrogramDataListener o : this.sizeObservers) {
            o.notifyMoreDataReady();
        }
    }

    public int getSizeInChunks() {
        return this.sizeInChunks;
    }

    public int getChunkRenderedCount() {
        return this.chunkPtr;
    }

    public int getBinCount() {
        return this.nBin;
    }

    public float[][] getMagnitude() {
        return this.magnArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWork() {
        this.chunkPtr = -1;
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            System.out.println(" Interrupted before I even started !! ");
            e.printStackTrace();
            return;
        }
        this.dt = (double)this.chunksize / this.Fs;
        this.fftCQ = new FFTConstantQ(this.Fs, this.minF, this.maxF, this.binsPerOctave, this.thresh, this.spread);
        int fftsize = this.fftCQ.getFFTSize();
        double[] freq = this.fftCQ.freqs;
        ConstantQSpectrogramDataBuilder constantQSpectrogramDataBuilder = this;
        synchronized (constantQSpectrogramDataBuilder) {
            this.freqArray = new float[freq.length];
            for (int i = 0; i < freq.length; ++i) {
                this.freqArray[i] = (float)freq[i];
            }
            System.out.println(" fftsize/chunkSIze = " + fftsize + "/" + this.chunksize);
            this.nBin = this.fftCQ.getNumberOfOutputBands();
            this.size = new Dimension(this.sizeInChunks, this.nBin);
            this.dPhaseFreqHz = new float[this.sizeInChunks][this.nBin];
            this.magnArray = new float[this.sizeInChunks][this.nBin];
            this.phaseArray = new float[this.sizeInChunks][this.nBin];
        }
        double twoPI = Math.PI * 2;
        double[] dPhaRef = new double[this.nBin];
        for (int i = 0; i < this.nBin; ++i) {
            dPhaRef[i] = twoPI * freq[i] * this.dt;
        }
        double[] fftOut = new double[this.nBin * 2];
        double[] fftIn = new double[fftsize];
        double[] input = new double[fftsize];
        try {
            this.reader.seekFrame(0L, false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        double testF = this.minF * 2.0;
        int ch = this.reader.getChannels();
        int nRead = 0;
        AudioBuffer buffer = new AudioBuffer("TEMP", ch, this.chunksize, 44100.0f);
        this.chunkPtr = -fftsize / this.chunksize / 2;
        int extraChunks = -this.chunkPtr;
        this.notifySizeObservers();
        this.chunkStartInSamples = 0;
        do {
            if (Thread.interrupted()) {
                return;
            }
            if (fftsize != this.chunksize) {
                for (int i = 0; i < fftsize - this.chunksize; ++i) {
                    input[i] = input[i + this.chunksize];
                }
            }
            buffer.makeSilence();
            this.reader.processAudio(buffer);
            nRead += this.chunksize;
            float[] left = buffer.getChannel(0);
            int i = fftsize - this.chunksize;
            int j = 0;
            while (i < fftsize) {
                input[i] = left[j];
                ++i;
                ++j;
            }
            if (this.chunkPtr < 0) {
                ++this.chunkPtr;
                this.chunkStartInSamples += this.chunksize;
                continue;
            }
            for (i = 0; i < fftsize; ++i) {
                fftIn[i] = input[i];
            }
            this.fftCQ.calc(fftIn, fftOut);
            for (i = 0; i < this.nBin; ++i) {
                double real = fftOut[2 * i];
                double imag = fftOut[2 * i + 1];
                this.magnArray[this.chunkPtr][i] = (float)Math.sqrt(real * real + imag * imag);
                this.phaseArray[this.chunkPtr][i] = (float)Math.atan2(imag, real);
                double phaLast = this.chunkPtr > 0 ? (double)this.phaseArray[this.chunkPtr - 1][i] : 0.0;
                double dpha = (double)this.phaseArray[this.chunkPtr][i] - phaLast;
                dpha = -((dPhaRef[i] - dpha + Math.PI + twoPI) % twoPI - Math.PI);
                this.dPhaseFreqHz[this.chunkPtr][i] = (float)(freq[i] + dpha / twoPI / this.dt);
            }
            ++this.chunkPtr;
            if (this.chunkPtr % 50 != 0) continue;
            this.notifyMoreDataObservers();
        } while (this.chunkPtr < this.sizeInChunks);
        System.out.println(" DATA BUILT ");
        this.notifyMoreDataObservers();
    }

    public float[] getFreqArray() {
        return this.freqArray;
    }

    public float[] getMagnitudeAt(long chunkPtr) {
        if (this.magnArray == null) {
            return null;
        }
        if (chunkPtr >= (long)this.magnArray.length || chunkPtr < 0L) {
            return null;
        }
        return this.magnArray[(int)chunkPtr];
    }

    public float[] getPhaseAt(long chunkPtr) {
        if (this.phaseArray == null) {
            return null;
        }
        if (chunkPtr >= (long)this.phaseArray.length || chunkPtr < 0L) {
            return null;
        }
        return this.phaseArray[(int)chunkPtr];
    }

    public float[] getPhaseFreqAt(long chunkPtr) {
        if (this.dPhaseFreqHz == null) {
            return null;
        }
        if (chunkPtr >= (long)this.dPhaseFreqHz.length) {
            return null;
        }
        return this.dPhaseFreqHz[(int)chunkPtr];
    }

    public long getLengthInFrames() {
        return this.reader.getLengthInFrames();
    }

    public long chunkStartInSamples(long chunkPtr) {
        return (long)this.chunkStartInSamples + chunkPtr * (long)this.chunksize;
    }

    public int getChunkAtFrame(long framePtr) {
        int chunkPtr = (int)((framePtr - (long)this.chunkStartInSamples) / (long)this.chunksize);
        return chunkPtr;
    }

    public boolean validAt(long chunkPtr2) {
        return chunkPtr2 >= 0L && chunkPtr2 < (long)this.chunkPtr;
    }

    public StaticSpectrogramSynth getSynth() {
        return new StaticSpectrogramSynth(this);
    }

    public FFT getFFT() {
        return this.fftCQ.getFFT();
    }

    public float[] getSMagnitudeAt(long chunkPtr) {
        return null;
    }

    public float[][] getSMagnitude() {
        return this.getMagnitude();
    }
}

