/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.tracker.filedialogs;

import com.frinika.global.FrinikaConfig;
import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.FrinikaSequencer;
import com.frinika.sequencer.model.AudioLane;
import com.frinika.sequencer.model.AudioPart;
import com.frinika.tools.MyMidiRenderer;
import com.frinika.tools.ProgressBarInputStream;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.io.File;
import java.io.FileNotFoundException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import uk.org.toot.audio.core.AudioProcess;

public class BounceToLane
extends JDialog
implements Runnable {
    private static final long serialVersionUID = 1L;
    JProgressBar progressBar;
    MyMidiRenderer midiRenderer;
    ProjectContainer project;
    File file;
    AudioLane lane;
    int numberOfSamples;

    public BounceToLane(JFrame frame, ProjectContainer project, File file, long startTick, long endTick, AudioLane lane) {
        super((Frame)frame, true);
        this.lane = lane;
        this.project = project;
        this.setResizable(false);
        this.setUndecorated(true);
        try {
            this.midiRenderer = new MyMidiRenderer(project.getMixer(), project.getSequencer(), startTick, (int)(endTick - startTick), project.getAudioServer().getSampleRate());
            this.numberOfSamples = this.midiRenderer.available() / 4;
            this.progressBar = new JProgressBar(0, this.midiRenderer.available());
            this.progressBar.setStringPainted(true);
            this.setLayout(new GridLayout(0, 1));
            JLabel lb = new JLabel("Exporting section to " + file.getName());
            lb.setFont(new Font(lb.getFont().getName(), 1, lb.getFont().getSize() * 2));
            this.add(lb);
            this.add(this.progressBar);
            this.file = file;
            new Thread(this).start();
            this.setSize(this.getPreferredSize());
            this.setLocationRelativeTo(frame);
            this.setVisible(true);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void run() {
        this.project.getAudioServer().stop();
        try {
            AudioInputStream ais = new AudioInputStream(new ProgressBarInputStream(this.progressBar, this.midiRenderer), new AudioFormat(FrinikaConfig.sampleRate, 16, 2, true, true), this.numberOfSamples);
            FrinikaSequencer sequencer = this.project.getSequencer();
            sequencer.setRealtime(false);
            sequencer.start();
            AudioSystem.write(ais, AudioFileFormat.Type.WAVE, this.file);
            sequencer.stop();
            sequencer.setRealtime(true);
            this.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.project.getMixer().getMainBus().setOutputProcess((AudioProcess)this.project.getOutputProcess());
        this.project.getAudioServer().start();
        try {
            AudioPart part = new AudioPart(this.lane, this.file, (long)this.midiRenderer.getStartTimeInMicros());
            part.onLoad();
            this.project.getEditHistoryContainer().notifyEditHistoryListeners();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

