/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.tools;

import com.frinika.sequencer.FrinikaSequence;
import com.frinika.sequencer.FrinikaSequencer;
import com.frinika.sequencer.FrinikaTrackWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.AudioProcess;
import uk.org.toot.audio.mixer.AudioMixer;

public class MyMidiRenderer
extends InputStream {
    long tickPosition = 0L;
    double ticksPerSecond;
    AudioMixer mixer;
    double startTimeInMicros;
    FrinikaSequence sequence;
    FrinikaSequencer sequencer;
    double samplePos = 0.0;
    double tickSamples = 0.0;
    float sampleRate;
    int available;
    byte[] buffer;
    HashMap<FrinikaTrackWrapper, Integer> trackIndex = new HashMap();
    int readpos = 0;
    byte[] byteBuffer = null;
    int bufferPos = 0;

    public MyMidiRenderer(AudioMixer mixer, FrinikaSequencer sequencer, long startTick, int ticks, float sampleRate) {
        this.mixer = mixer;
        this.sampleRate = sampleRate;
        this.sequence = (FrinikaSequence)sequencer.getSequence();
        this.sequencer = sequencer;
        this.tickPosition = startTick;
        sequencer.setTickPosition(startTick);
        this.startTimeInMicros = sequencer.getMicrosecondPosition();
        this.available = (int)(this.getNumberOfSamples(ticks) * 4.0);
        this.tickSamples = this.getNumberOfSamples(1);
        AudioProcess audioProcess = new AudioProcess(){

            public void close() {
            }

            public void open() {
            }

            public int processAudio(AudioBuffer buffer) {
                if (MyMidiRenderer.this.byteBuffer == null) {
                    MyMidiRenderer.this.byteBuffer = new byte[buffer.getSampleCount() * 2 * 2];
                }
                int i = 0;
                for (int n = 0; n < buffer.getSampleCount(); ++n) {
                    float floatSample = buffer.getChannel(0)[n];
                    int sample = floatSample >= 1.0f ? Short.MAX_VALUE : (floatSample <= -1.0f ? Short.MIN_VALUE : (int)((short)(floatSample * 32768.0f)));
                    MyMidiRenderer.this.byteBuffer[i++] = (byte)((sample & 0xFF00) >> 8);
                    MyMidiRenderer.this.byteBuffer[i++] = (byte)(sample & 0xFF);
                    floatSample = buffer.getChannel(1)[n];
                    sample = floatSample >= 1.0f ? Short.MAX_VALUE : (floatSample <= -1.0f ? Short.MIN_VALUE : (int)((short)(floatSample * 32768.0f)));
                    MyMidiRenderer.this.byteBuffer[i++] = (byte)((sample & 0xFF00) >> 8);
                    MyMidiRenderer.this.byteBuffer[i++] = (byte)(sample & 0xFF);
                }
                return 0;
            }
        };
        mixer.getMainBus().setOutputProcess(audioProcess);
    }

    public int available() throws IOException {
        return this.available;
    }

    double getNumberOfSamples(int ticks) {
        double ticksPerSecond = (double)((float)this.sequence.getResolution() * this.sequencer.getTempoInBPM()) / 60.0;
        double seconds = (double)ticks / ticksPerSecond;
        return seconds * (double)this.sampleRate;
    }

    void fillBuffer() {
        while (this.byteBuffer == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.mixer.work(-1);
        }
        for (int n = 0; n < this.buffer.length; ++n) {
            if (this.readpos == this.byteBuffer.length) {
                this.mixer.work(-1);
                this.readpos = 0;
            }
            this.buffer[n] = this.byteBuffer[this.readpos++];
        }
    }

    public int read() throws IOException {
        if (this.bufferPos == 0) {
            double newSamplePos = this.samplePos + this.tickSamples;
            int bufferSize = (int)newSamplePos - (int)this.samplePos;
            this.samplePos = newSamplePos;
            if (this.buffer == null || this.buffer.length != bufferSize * 4) {
                this.buffer = new byte[bufferSize * 4];
            }
            this.tickSamples = this.getNumberOfSamples(1);
            this.sequencer.nonRealtimeNextTick();
            this.fillBuffer();
        }
        int ret = 0xFF & this.buffer[this.bufferPos++];
        if (this.bufferPos == this.buffer.length) {
            this.bufferPos = 0;
        }
        --this.available;
        return ret;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        for (int i = off; i < len; ++i) {
            if (this.available == 0) {
                return i - off;
            }
            if (this.bufferPos == 0) {
                double newSamplePos = this.samplePos + this.tickSamples;
                int bufferSize = (int)newSamplePos - (int)this.samplePos;
                this.samplePos = newSamplePos;
                if (this.buffer == null || this.buffer.length != bufferSize * 4) {
                    this.buffer = new byte[bufferSize * 4];
                }
                this.tickSamples = this.getNumberOfSamples(1);
                this.sequencer.nonRealtimeNextTick();
                this.fillBuffer();
            }
            b[i] = this.buffer[this.bufferPos++];
            if (this.bufferPos == this.buffer.length) {
                this.bufferPos = 0;
            }
            --this.available;
        }
        return len;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public double getStartTimeInMicros() {
        return this.startTimeInMicros;
    }
}

