/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.synth.synths;

import com.frinika.audio.Decibel;
import com.frinika.audio.JavaSoundVoiceServer;
import com.frinika.synth.Oscillator;
import com.frinika.synth.Synth;
import com.frinika.synth.SynthRack;
import com.frinika.synth.envelope.VolumeEnvelope;
import com.frinika.synth.filters.LoPass;
import com.frinika.synth.synths.analogika.AnalogikaGUI;
import com.frinika.synth.synths.analogika.settings.AnalogikaSettings;
import com.frinika.synth.synths.analogika.settings.analogikasettingsversions.AnalogikaSettings20050303;
import java.io.Serializable;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;

public final class Analogika
extends Synth {
    static final float PAN_LEFT_0 = Analogika.panLeft(0.0);
    static final float PAN_LEFT_15 = Analogika.panLeft(0.15);
    static final float PAN_LEFT_20 = Analogika.panLeft(0.2);
    static final float PAN_LEFT_25 = Analogika.panLeft(0.25);
    static final float PAN_LEFT_30 = Analogika.panLeft(0.3);
    static final float PAN_LEFT_40 = Analogika.panLeft(0.4);
    static final float PAN_LEFT_45 = Analogika.panLeft(0.45);
    static final float PAN_LEFT_50 = Analogika.panLeft(0.5);
    static final float PAN_LEFT_55 = Analogika.panLeft(0.55);
    static final float PAN_LEFT_60 = Analogika.panLeft(0.6);
    static final float PAN_LEFT_70 = Analogika.panLeft(0.7);
    static final float PAN_LEFT_75 = Analogika.panLeft(0.75);
    static final float PAN_LEFT_80 = Analogika.panLeft(0.8);
    static final float PAN_LEFT_85 = Analogika.panLeft(0.85);
    static final float PAN_RIGHT_15 = Analogika.panRight(0.15);
    static final float PAN_RIGHT_20 = Analogika.panRight(0.2);
    static final float PAN_RIGHT_25 = Analogika.panRight(0.25);
    static final float PAN_RIGHT_30 = Analogika.panRight(0.3);
    static final float PAN_RIGHT_40 = Analogika.panRight(0.4);
    static final float PAN_RIGHT_45 = Analogika.panRight(0.45);
    static final float PAN_RIGHT_50 = Analogika.panRight(0.5);
    static final float PAN_RIGHT_55 = Analogika.panRight(0.55);
    static final float PAN_RIGHT_60 = Analogika.panRight(0.6);
    static final float PAN_RIGHT_70 = Analogika.panRight(0.7);
    static final float PAN_RIGHT_75 = Analogika.panRight(0.75);
    static final float PAN_RIGHT_80 = Analogika.panRight(0.8);
    static final float PAN_RIGHT_85 = Analogika.panRight(0.85);
    static final float PAN_RIGHT_100 = Analogika.panRight(1.0);
    AnalogikaSettings20050303 settings = new AnalogikaSettings20050303();

    static final float panLeft(double position) {
        return Decibel.getAmplitudeRatio(-((float)(-20.0 * Math.log10(Math.sqrt(1.0 - position)))));
    }

    static final float panRight(double position) {
        return Decibel.getAmplitudeRatio(-((float)(-20.0 * Math.log10(Math.sqrt(position)))));
    }

    public Analogika(SynthRack synth) {
        super(synth);
    }

    public AnalogikaSettings getAnalogikaSettings() {
        return this.settings;
    }

    public void loadSettings(Serializable settings) {
        AnalogikaSettings newSettings = (AnalogikaSettings)((Object)settings);
        this.settings.setFreqSpread(newSettings.getFreqSpread());
        this.settings.setLayers(newSettings.getLayers());
        this.settings.setLoPassAttack(newSettings.getLoPassAttack());
        this.settings.setLoPassDecay(newSettings.getLoPassDecay());
        this.settings.setLoPassSustain(newSettings.getLoPassSustain());
        this.settings.setLoPassRelease(newSettings.getLoPassRelease());
        this.settings.setLoPassMax(newSettings.getLoPassMax());
        this.settings.setVolAttack(newSettings.getVolAttack());
        this.settings.setVolDecay(newSettings.getVolDecay());
        this.settings.setVolSustain(newSettings.getVolSustain());
        this.settings.setVolRelease(newSettings.getVolRelease());
        this.settings.setWaveform(newSettings.getWaveform());
        if (newSettings.getInstrumentName() == null) {
            this.setInstrumentName("analogika");
        } else {
            this.setInstrumentName(newSettings.getInstrumentName());
        }
    }

    public Serializable getSettings() {
        this.settings.setInstrumentName(this.getInstrumentName());
        return this.settings;
    }

    public void noteOn(int noteNumber, int velocity) {
        AnalogikaOscillator osc = new AnalogikaOscillator(this);
        osc.setNoteNumber(noteNumber);
        osc.setVelocity(velocity);
        this.addOscillator(noteNumber, osc);
    }

    public void showGUI() {
        new AnalogikaGUI(this);
    }

    public static void main(String[] args) throws Exception {
        JavaSoundVoiceServer audioOutput = new JavaSoundVoiceServer();
        SynthRack synth = new SynthRack(audioOutput);
        synth.open();
        synth.setSynth(0, new Analogika(synth));
        System.out.println("Initializing midi, please wait...");
        MidiDevice midiIn = MidiSystem.getMidiDevice(MidiSystem.getMidiDeviceInfo()[0]);
        midiIn.open();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Recv
        implements Receiver {
            final /* synthetic */ SynthRack val$synth;

            Recv(SynthRack synthRack) {
                this.val$synth = synthRack;
            }

            @Override
            public void send(MidiMessage message, long timeStamp) {
                try {
                    ShortMessage shm = (ShortMessage)message;
                    shm.setMessage(shm.getCommand(), 0, shm.getData1(), shm.getData2());
                    this.val$synth.getReceiver().send(shm, -1L);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }

            @Override
            public void close() {
            }
        }
        midiIn.getTransmitter().setReceiver(new Recv(synth));
        System.out.println("Ready to play!!!");
        AnalogikaGUI gui = new AnalogikaGUI((Analogika)synth.getSynth(0));
        gui.setDefaultCloseOperation(3);
    }

    public String toString() {
        return "Analogika: " + this.getInstrumentName();
    }

    final class AnalogikaOscillator
    extends Oscillator {
        final LoPass leftLoPass;
        final LoPass rightLoPass;
        final VolumeEnvelope volEnvelope;
        final VolumeEnvelope loPassEnvelope;
        final int layers;
        final float freqSpread;
        final float[] waveform;
        final float positionMultiplier;
        final float layerMiddle;
        final float freqBase;
        final float spreadMiddle;

        public AnalogikaOscillator(Synth synth) {
            super(synth);
            this.leftLoPass = new LoPass();
            this.rightLoPass = new LoPass();
            this.volEnvelope = new VolumeEnvelope(Analogika.this.getAudioOutput().getSampleRate(), -100.0f, 0.0f);
            this.loPassEnvelope = new VolumeEnvelope(Analogika.this.getAudioOutput().getSampleRate(), -100.0f, -((float)Analogika.this.settings.getLoPassMax() / 10.0f));
            this.layers = Analogika.this.settings.getLayers();
            this.freqSpread = Analogika.this.settings.getFreqSpread();
            this.waveform = Analogika.this.settings.getWaveform();
            this.positionMultiplier = (float)((double)this.waveform.length / (Math.PI * 2));
            this.layerMiddle = (float)this.layers / 2.0f;
            this.freqBase = 1.0f + (0.5f - this.layerMiddle) / this.layerMiddle * this.freqSpread;
            this.spreadMiddle = this.freqSpread / this.layerMiddle;
            this.volEnvelope.setAttack(Analogika.this.settings.getVolAttack());
            this.volEnvelope.setDecay(Analogika.this.settings.getVolDecay());
            this.volEnvelope.setSustain(Analogika.this.settings.getVolSustain());
            this.volEnvelope.setRelease(Analogika.this.settings.getVolRelease());
            this.loPassEnvelope.setAttack(Analogika.this.settings.getLoPassAttack());
            this.loPassEnvelope.setDecay(Analogika.this.settings.getLoPassDecay());
            this.loPassEnvelope.setSustain(Analogika.this.settings.getLoPassSustain());
            this.loPassEnvelope.setRelease(Analogika.this.settings.getLoPassRelease());
        }

        final float getSample(float layerIndex) {
            return this.waveform[(int)(this.position * (layerIndex * this.spreadMiddle + this.freqBase)) % this.waveform.length];
        }

        public final void fillBuffer(int startBufferPos, int endBufferPos, float[] buffer) {
            if (this.release) {
                this.volEnvelope.release();
            }
            int n = startBufferPos;
            while (n < endBufferPos) {
                float left = 0.0f;
                float right = 0.0f;
                switch (this.layers) {
                    case 1: {
                        right = left = this.getSample(0.0f) * PAN_LEFT_50;
                        break;
                    }
                    case 2: {
                        left = this.getSample(0.0f) * PAN_LEFT_0;
                        right = this.getSample(1.0f) * PAN_RIGHT_100;
                        break;
                    }
                    case 3: {
                        right = left = this.getSample(0.0f) * PAN_LEFT_50;
                        left += this.getSample(1.0f) * PAN_LEFT_0;
                        right += this.getSample(2.0f) * PAN_RIGHT_100;
                        break;
                    }
                    case 4: {
                        left = this.getSample(0.0f) * PAN_LEFT_0;
                        right = this.getSample(1.0f) * PAN_RIGHT_100;
                        float tmpSample = this.getSample(2.0f);
                        left += tmpSample * PAN_LEFT_25;
                        right += tmpSample * PAN_RIGHT_25;
                        tmpSample = this.getSample(3.0f);
                        left += tmpSample * PAN_LEFT_75;
                        right += tmpSample * PAN_RIGHT_75;
                        break;
                    }
                    case 5: {
                        right = left = this.getSample(0.0f) * PAN_LEFT_50;
                        left += this.getSample(1.0f) * PAN_LEFT_0;
                        right += this.getSample(2.0f) * PAN_RIGHT_100;
                        float tmpSample = this.getSample(3.0f);
                        left += tmpSample * PAN_LEFT_25;
                        right += tmpSample * PAN_RIGHT_25;
                        tmpSample = this.getSample(4.0f);
                        left += tmpSample * PAN_LEFT_75;
                        right += tmpSample * PAN_RIGHT_75;
                        break;
                    }
                    case 6: {
                        left = this.getSample(0.0f) * PAN_LEFT_0;
                        right = this.getSample(1.0f) * PAN_RIGHT_100;
                        float tmpSample = this.getSample(2.0f);
                        left += tmpSample * PAN_LEFT_20;
                        right += tmpSample * PAN_RIGHT_20;
                        tmpSample = this.getSample(3.0f);
                        left += tmpSample * PAN_LEFT_80;
                        right += tmpSample * PAN_RIGHT_80;
                        tmpSample = this.getSample(4.0f);
                        left += tmpSample * PAN_LEFT_40;
                        right += tmpSample * PAN_RIGHT_40;
                        tmpSample = this.getSample(5.0f);
                        left += tmpSample * PAN_LEFT_60;
                        right += tmpSample * PAN_RIGHT_60;
                        break;
                    }
                    case 7: {
                        right = left = this.getSample(0.0f) * PAN_LEFT_50;
                        left += this.getSample(1.0f) * PAN_LEFT_0;
                        right += this.getSample(2.0f) * PAN_RIGHT_100;
                        float tmpSample = this.getSample(3.0f);
                        left += tmpSample * PAN_LEFT_20;
                        right += tmpSample * PAN_RIGHT_20;
                        tmpSample = this.getSample(4.0f);
                        left += tmpSample * PAN_LEFT_80;
                        right += tmpSample * PAN_RIGHT_80;
                        tmpSample = this.getSample(5.0f);
                        left += tmpSample * PAN_LEFT_40;
                        right += tmpSample * PAN_RIGHT_40;
                        tmpSample = this.getSample(6.0f);
                        left += tmpSample * PAN_LEFT_60;
                        right += tmpSample * PAN_RIGHT_60;
                        break;
                    }
                    case 8: {
                        left = this.getSample(0.0f) * PAN_LEFT_0;
                        right = this.getSample(1.0f) * PAN_RIGHT_100;
                        float tmpSample = this.getSample(2.0f);
                        left += tmpSample * PAN_LEFT_15;
                        right += tmpSample * PAN_RIGHT_15;
                        tmpSample = this.getSample(3.0f);
                        left += tmpSample * PAN_LEFT_85;
                        right += tmpSample * PAN_RIGHT_85;
                        tmpSample = this.getSample(4.0f);
                        left += tmpSample * PAN_LEFT_30;
                        right += tmpSample * PAN_RIGHT_30;
                        tmpSample = this.getSample(5.0f);
                        left += tmpSample * PAN_LEFT_70;
                        right += tmpSample * PAN_RIGHT_70;
                        tmpSample = this.getSample(6.0f);
                        left += tmpSample * PAN_LEFT_45;
                        right += tmpSample * PAN_RIGHT_45;
                        tmpSample = this.getSample(7.0f);
                        left += tmpSample * PAN_LEFT_55;
                        right += tmpSample * PAN_RIGHT_55;
                    }
                }
                this.position += this.increment * this.positionMultiplier * Analogika.this.preOscillator.getLfoBuffer()[n / 2];
                float volEnvelopeAttenuation = this.volEnvelope.getAttenuation();
                float loPassEnvelopeSample = this.loPassEnvelope.getAttenuation();
                this.leftLoPass.setCutOff(loPassEnvelopeSample);
                left = this.leftLoPass.filter(left);
                this.rightLoPass.setCutOff(loPassEnvelopeSample);
                right = this.rightLoPass.filter(right);
                int n2 = n++;
                ((Analogika)Analogika.this).preOscillator.sampleBuffer[n2] = ((Analogika)Analogika.this).preOscillator.sampleBuffer[n2] + left * this.level * volEnvelopeAttenuation;
                int n3 = n++;
                ((Analogika)Analogika.this).preOscillator.sampleBuffer[n3] = ((Analogika)Analogika.this).preOscillator.sampleBuffer[n3] + right * this.level * volEnvelopeAttenuation;
                if (!this.release || !((double)volEnvelopeAttenuation < 0.01)) continue;
                Analogika.this.getAudioOutput().removeTransmitter(this);
                break;
            }
        }
    }
}

