/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.synth.soundbank;

import com.frinika.synth.Synth;
import com.frinika.synth.soundbank.SynthRackInstrument;
import java.util.HashMap;
import java.util.Map;
import javax.sound.midi.Instrument;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import javax.sound.midi.SoundbankResource;

public class SynthRackSoundbank
implements Soundbank {
    Map<Integer, Instrument> instruments = new HashMap<Integer, Instrument>();

    public static int getInstrumentMapKey(Patch patch) {
        return patch.getBank() * 128 + patch.getProgram();
    }

    public String getDescription() {
        return null;
    }

    public Instrument getInstrument(Patch patch) {
        return this.instruments.get(SynthRackSoundbank.getInstrumentMapKey(patch));
    }

    public Instrument[] getInstruments() {
        return this.instruments.values().toArray(new Instrument[this.instruments.size()]);
    }

    public String getName() {
        return "Frinika Synthrack soundbank";
    }

    public SoundbankResource[] getResources() {
        return null;
    }

    public String getVendor() {
        return "petersalomonsen.com";
    }

    public String getVersion() {
        return "0.5";
    }

    public void createAndRegisterInstrument(Patch patch, Synth synth) {
        this.instruments.put(SynthRackSoundbank.getInstrumentMapKey(patch), new SynthRackInstrument(this, synth, patch));
    }
}

