/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.synth.importers.soundfont;

import com.frinika.synth.importers.soundfont.SoundFontFileFilter;
import com.frinika.synth.importers.soundfont.SoundFontImporter;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

public class SoundFontImporterGUI
extends JFrame {
    static File lastSelectedPath;
    SoundFontImporter sfi;
    private JComboBox cb = null;

    public SoundFontImporterGUI(SoundFontImporter sfi) {
        this.setLayout(new FlowLayout());
        this.sfi = sfi;
        this.initialize();
    }

    private void initialize() {
        JButton but = new JButton("Open soundfont");
        but.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                try {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setDialogTitle("Open soundfont");
                    chooser.setFileFilter(new SoundFontFileFilter());
                    if (lastSelectedPath != null) {
                        chooser.setSelectedFile(lastSelectedPath);
                    }
                    if (chooser.showOpenDialog(SoundFontImporterGUI.this) == 0) {
                        File soundFontFile;
                        lastSelectedPath = soundFontFile = chooser.getSelectedFile();
                        SoundFontImporterGUI.this.sfi.getSoundFont(soundFontFile);
                        SoundFontImporterGUI.this.updateInstrumentList();
                        SoundFontImporterGUI.this.pack();
                        SoundFontImporterGUI.this.repaint();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.add(but);
        this.updateInstrumentList();
        this.setSize(100, 200);
        this.pack();
        this.setVisible(true);
    }

    public static void getMissingSoundFont(File file, SoundFontImporter sfi) throws Exception {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("A soundfont is missing");
        chooser.setFileFilter(new SoundFontFileFilter());
        chooser.setSelectedFile(file);
        if (chooser.showOpenDialog(null) == 0) {
            File soundFontFile = chooser.getSelectedFile();
            sfi.getSoundFont(soundFontFile);
        }
    }

    void updateInstrumentList() {
        if (this.sfi.inst != null) {
            if (this.cb != null) {
                this.remove(this.cb);
            }
            this.cb = new JComboBox();
            this.cb.addItem("");
            for (String name : this.sfi.getInstrumentNames()) {
                this.cb.addItem(name);
            }
            this.cb.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    try {
                        SoundFontImporterGUI.this.sfi.getInstrument(SoundFontImporterGUI.this.cb.getSelectedIndex() - 1);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.add(this.cb);
        }
    }
}

