/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.synth.importers.soundfont;

import java.io.FileInputStream;

class Chunk {
    String name;
    int length;
    FileInputStream fis;

    public Chunk(FileInputStream fis, String name) throws Exception {
        this.fis = fis;
        byte[] b = new byte[4];
        while (!new String(b).equals(name) & fis.available() > 0) {
            b[0] = b[2];
            b[1] = b[3];
            fis.read(b, 2, 2);
        }
        this.name = name;
        fis.read(b);
        this.length = (b[0] & 0xFF) + ((b[1] & 0xFF) << 8) + ((b[2] & 0xFF) << 16) + ((b[3] & 0xFF) << 24);
    }

    public String readString(int length) throws Exception {
        int n;
        byte[] b = new byte[length];
        this.fis.read(b);
        for (n = 0; n < length && b[n] != 0; ++n) {
        }
        return new String(b, 0, n);
    }

    public int readInt16() throws Exception {
        byte[] b = new byte[2];
        this.fis.read(b);
        return (b[0] & 0xFF) + ((b[1] & 0xFF) << 8);
    }

    public int readInt32() throws Exception {
        byte[] b = new byte[4];
        this.fis.read(b);
        return (b[0] & 0xFF) + ((b[1] & 0xFF) << 8) + ((b[2] & 0xFF) << 16) + ((b[3] & 0xFF) << 24);
    }

    public char readChar() throws Exception {
        return (char)this.fis.read();
    }

    public byte readByte() throws Exception {
        return (byte)this.fis.read();
    }
}

