/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.synth.envelope;

import com.frinika.audio.Decibel;

public final class VolumeEnvelope {
    static final int ENVELOPESTATE_DELAY = 0;
    static final int ENVELOPESTATE_ATTACK = 1;
    static final int ENVELOPESTATE_HOLD = 2;
    static final int ENVELOPESTATE_DECAY = 3;
    static final int ENVELOPESTATE_SUSTAIN = 4;
    static final int ENVELOPESTATE_RELEASE = 5;
    float min;
    float max;
    float maxdB;
    int sampleRate;
    int envelopeState = 0;
    int delaySampleCount;
    int holdSampleCount;
    float attackDeltaLevelPerSample;
    float decayAttenuationPerSample;
    float releaseAttenuationPerSample;
    float attenuation;
    float sustainAttenuation;
    boolean isReleased = false;

    public VolumeEnvelope(int sampleRate, float mindB, float maxdB) {
        this.min = Decibel.getAmplitudeRatio(mindB);
        this.max = Decibel.getAmplitudeRatio(maxdB);
        this.maxdB = maxdB;
        this.attenuation = this.min;
        this.sampleRate = sampleRate;
        this.setDelay(Short.MIN_VALUE);
        this.setAttack(0);
        this.setHold(Short.MIN_VALUE);
        this.setDecay(0);
        this.setSustain(400);
        this.setRelease(0);
    }

    public final void setDelay(int delayTimeCents) {
        this.delaySampleCount = this.timeCentsToSampleCount(delayTimeCents);
    }

    public final void setAttack(int attackTimeCents) {
        this.attackDeltaLevelPerSample = 1.0f / (float)this.timeCentsToSampleCount(attackTimeCents);
    }

    public final void setHold(int holdTimeCents) {
        this.holdSampleCount = this.timeCentsToSampleCount(holdTimeCents);
    }

    public final void setDecay(int decayTimeCents) {
        this.decayAttenuationPerSample = this.getAttenuationPerSample(-100.0f, decayTimeCents);
    }

    public final void setSustain(int centiBelsDecrease) {
        float dB = this.maxdB - (float)centiBelsDecrease / 10.0f;
        if (dB < -100.0f) {
            dB = -100.0f;
        }
        this.sustainAttenuation = Decibel.getAmplitudeRatio(dB);
    }

    public final void setRelease(int releaseTimeCents) {
        this.releaseAttenuationPerSample = this.getAttenuationPerSample(-100.0f, releaseTimeCents);
    }

    public final void release() {
        this.envelopeState = 5;
    }

    public final boolean isReleased() {
        return this.isReleased;
    }

    public final float getAttenuation() {
        switch (this.envelopeState) {
            case 0: {
                if (--this.delaySampleCount >= 0) break;
                this.envelopeState = 1;
            }
            case 1: {
                if (this.attenuation >= this.max) {
                    this.envelopeState = 2;
                } else {
                    this.attenuation += this.attackDeltaLevelPerSample;
                    if (!(this.attenuation >= this.max)) break;
                    this.attenuation = this.max;
                    break;
                }
            }
            case 2: {
                if (--this.holdSampleCount >= 0) break;
                this.envelopeState = 3;
            }
            case 3: {
                if (this.attenuation <= this.sustainAttenuation) {
                    this.envelopeState = 4;
                    break;
                }
                this.attenuation *= this.decayAttenuationPerSample;
                break;
            }
            case 5: {
                if (this.attenuation <= this.min) {
                    this.isReleased = true;
                    break;
                }
                this.attenuation *= this.releaseAttenuationPerSample;
            }
        }
        return this.attenuation;
    }

    final int timeCentsToSampleCount(int timeCents) {
        return (int)((double)this.sampleRate * Math.pow(2.0, (double)timeCents / 1200.0) + 1.0);
    }

    public final float getAttenuationPerSample(float deciBels, int timeCents) {
        return (float)Math.pow(10.0, deciBels / (float)(20 * this.timeCentsToSampleCount(timeCents)));
    }

    public static void main(String[] args) {
        int n;
        VolumeEnvelope env = new VolumeEnvelope(10, -100.0f, 0.0f);
        env.setAttack(0);
        env.setSustain(500);
        System.out.println(env.timeCentsToSampleCount(7973));
        System.out.println(Decibel.getAmplitudeRatio(-40.0f));
        for (n = 0; n < 50; ++n) {
            System.out.println(n + " " + env.getAttenuation() + " " + env.envelopeState);
        }
        env.release();
        for (n = 0; n < 50; ++n) {
            System.out.println(n + " " + env.getAttenuation() + " " + env.envelopeState);
        }
    }
}

