/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.synth;

public class Overdrive {
    static final float[] divisor = new float[128];
    static final float[] atan;

    static final float process(float signal, int amount) {
        if ((signal *= (float)amount) >= 10.0f) {
            signal = 9.999695f;
        } else if (signal < -10.0f) {
            signal = -10.0f;
        }
        return atan[(int)(signal * 3276.7f + 32768.0f)] / divisor[amount];
    }

    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        for (float n = -10.0f; n < 10.0f; n += 3.0517578E-4f) {
            Overdrive.process(n, 20);
        }
        System.out.println(System.currentTimeMillis() - start);
    }

    static {
        for (int n = 0; n < divisor.length; ++n) {
            Overdrive.divisor[n] = (float)(Math.log(n * 2) / Math.log(2.0));
        }
        atan = new float[65536];
        for (float n = -10.0f; n < 10.0f; n += 3.0517578E-4f) {
            Overdrive.atan[(int)(n * 3276.8f + 32768.0f)] = (float)Math.atan(n);
        }
    }
}

