/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.synth;

import com.frinika.audio.Voice;
import com.frinika.audio.VoiceInterrupt;
import com.frinika.global.FrinikaConfig;
import com.frinika.synth.Synth;
import com.frinika.synth.envelope.MidiVolume;

public abstract class Oscillator
extends Voice {
    protected float frequency;
    protected float increment;
    protected float level;
    protected float position = 0.0f;
    protected int sampleRate = FrinikaConfig.sampleRate;
    protected boolean release = false;
    protected boolean triggeredRelease = false;
    protected Synth synth;

    public Oscillator(Synth synth) {
        this.synth = synth;
    }

    public void setNoteNumber(int noteNumber) {
        this.frequency = Oscillator.getFrequency(noteNumber);
        this.updateIncrement();
    }

    public static final float getFrequency(int noteNumber) {
        return (float)(440.0 * Math.pow(2.0, ((double)noteNumber - 69.0) / 12.0));
    }

    private static final float getIncrement(float frequency, int sampleRate) {
        return (float)(Math.PI * 2 * (double)frequency / ((double)sampleRate * 1.0));
    }

    protected void updateIncrement() {
        this.increment = Oscillator.getIncrement(this.frequency, this.sampleRate);
    }

    public void setVelocity(int velocity) {
        this.level = MidiVolume.midiVolumeToAmplitudeRatio(velocity);
    }

    public void release() {
        if (!this.triggeredRelease) {
            this.synth.getAudioOutput().interruptTransmitter(this, new VoiceInterrupt(){

                public void doInterrupt() {
                    Oscillator.this.release = true;
                }
            });
            this.triggeredRelease = true;
        }
    }
}

