/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model.util;

import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.Part;
import com.frinika.sequencer.model.util.EventFilter;
import com.frinika.sequencer.model.util.EventIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventsInPartsIterator
implements Iterator<MultiEvent> {
    Iterator<Part> partIter = null;
    EventIterator eventIter = null;
    EventFilter filter;

    public EventsInPartsIterator(Collection<Part> partList, EventFilter filter) {
        this.filter = filter;
        this.partIter = partList.iterator();
        this.advanceToNextMidiPart();
    }

    public EventsInPartsIterator(Part part, EventFilter filter) {
        this.filter = filter;
        this.partIter = null;
        this.eventIter = new EventIterator(((MidiPart)part).getMultiEvents(), filter);
    }

    private boolean advanceToNextMidiPart() {
        if (this.partIter == null) {
            return false;
        }
        Part part = null;
        while (this.partIter.hasNext()) {
            SortedSet<MultiEvent> list;
            part = this.partIter.next();
            if (!(part instanceof MidiPart) || (list = ((MidiPart)part).getMultiEvents()).size() == 0) continue;
            this.eventIter = new EventIterator(((MidiPart)part).getMultiEvents(), this.filter);
            if (!this.eventIter.hasNext()) continue;
            return true;
        }
        this.eventIter = null;
        return false;
    }

    @Override
    public boolean hasNext() {
        if (this.eventIter == null) {
            return false;
        }
        if (this.eventIter.hasNext()) {
            return true;
        }
        return this.advanceToNextMidiPart();
    }

    @Override
    public MultiEvent next() {
        while (this.eventIter.hasNext()) {
            MultiEvent ev = this.eventIter.next();
            assert (ev != null);
            if (!this.filter.isValidEvent(ev)) continue;
            return ev;
        }
        if (this.advanceToNextMidiPart()) {
            return this.next();
        }
        return null;
    }

    @Override
    public void remove() {
        assert (false);
    }
}

