/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model.timesignature;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeSignatureList {
    private transient TreeMap<Integer, TimeSignatureEvent> eventByBar = new TreeMap();
    private transient Vector<TimeSignatureEvent> list = new Vector();
    private transient boolean dirty = true;
    static double tol = 1.0E-6;

    public void remove(int bar) {
        this.eventByBar.remove(bar);
        this.dirty = true;
    }

    public synchronized void add(int bar, int nBeatPerBar) {
        if (this.eventByBar.remove(bar) != null) {
            System.out.println(" TIME SIG AT" + bar + " REMOVED ");
        }
        this.eventByBar.put(bar, new TimeSignatureEvent(bar, nBeatPerBar));
        this.dirty = true;
    }

    public synchronized void remove(int tick1, int tick2) {
        this.eventByBar.subMap(tick1, tick2).clear();
        this.dirty = true;
    }

    public synchronized void reco() {
        if (!this.dirty) {
            return;
        }
        TimeSignatureEvent prev = null;
        this.list.clear();
        for (Map.Entry<Integer, TimeSignatureEvent> e : this.eventByBar.entrySet()) {
            TimeSignatureEvent ptr = e.getValue();
            ptr.beat = prev != null ? prev.beat + (ptr.bar - prev.bar) * prev.beatsPerBar : 0;
            prev = ptr;
            this.list.add(ptr);
        }
        this.dirty = false;
    }

    public synchronized Vector<TimeSignatureEvent> getList() {
        this.reco();
        return this.list;
    }

    public int getBeatAtBar(int bar) {
        TimeSignatureEvent ev = this.getTimeSignutureEventAtBar(bar);
        return ev.beat + ev.beatsPerBar * (bar - ev.bar);
    }

    public TimeSignatureEvent getTimeSignutureEventAtBar(int bar) {
        int itick;
        SortedMap<Integer, TimeSignatureEvent> head;
        if (this.dirty) {
            this.reco();
        }
        if ((head = this.eventByBar.headMap(itick = bar + 1)).isEmpty()) {
            return null;
        }
        Integer lastKey = head.lastKey();
        TimeSignatureEvent ev = (TimeSignatureEvent)head.get(lastKey);
        return ev;
    }

    public int getBarContaining(int beat) {
        TimeSignatureEvent ev = this.getEventAtBeat(beat);
        return ev.bar + (beat - ev.beat) / ev.beatsPerBar;
    }

    public TimeSignatureEvent getEventAtBeat(int beat) {
        if (this.dirty) {
            this.reco();
        }
        assert (beat >= 0);
        Object ret = null;
        Object next = null;
        Iterator<Map.Entry<Integer, TimeSignatureEvent>> iter = this.eventByBar.entrySet().iterator();
        TimeSignatureEvent ts1 = iter.next().getValue();
        if (!iter.hasNext()) {
            return ts1;
        }
        do {
            TimeSignatureEvent ts2 = iter.next().getValue();
            if (ts1.beat <= beat && ts2.beat > beat) {
                return ts1;
            }
            ts1 = ts2;
        } while (iter.hasNext());
        return ts1;
    }

    void display() {
        this.reco();
        for (Map.Entry<Integer, TimeSignatureEvent> me : this.eventByBar.entrySet()) {
            System.out.println(me.getKey() + " @" + me.getValue().bar + "  * " + me.getValue().beat + " : " + " : " + me.getValue().beatsPerBar);
        }
    }

    public QStepIterator createQStepIterator(double beat1, double beat2, double step) {
        if (step > 0.0) {
            return new QStepIteratorDef(beat1, beat2, step);
        }
        return new QStepIteratorBar((int)Math.ceil(beat1), (int)Math.floor(beat2));
    }

    public static void main(String[] args) {
        TimeSignatureList list = new TimeSignatureList();
        list.add(0, 4);
        list.add(2, 3);
        list.add(3, 5);
        double beat1 = 0.0;
        double beat2 = 20.0;
        QStepIterator iter = list.createQStepIterator(beat1, beat2, 1.0);
        while (iter.hasNext()) {
            iter.next();
            System.out.print("@" + iter.getBeat());
            TimeSignatureEvent ev = list.getEventAtBeat((int)iter.getBeat());
            System.out.println(" Event =" + ev.beat + "  " + ev.bar + "  " + ev.beatsPerBar);
        }
    }

    class QStepIteratorDef
    implements QStepIterator {
        public double beat;
        public boolean isBar;
        double step;
        int count;
        public Iterator<Map.Entry<Integer, TimeSignatureEvent>> tsIter;
        TimeSignatureEvent ts;
        private TimeSignatureEvent tsNext;

        QStepIteratorDef(double beat1, double beat2, double step) {
            if (TimeSignatureList.this.dirty) {
                TimeSignatureList.this.reco();
            }
            this.tsIter = TimeSignatureList.this.eventByBar.entrySet().iterator();
            this.beat = beat1 - step;
            this.step = step;
            this.count = (int)((beat2 + tol - beat1) / step);
            while (this.tsIter.hasNext()) {
                this.ts = this.tsIter.next().getValue();
                if (!((double)this.ts.beat >= this.beat - tol)) continue;
                if (this.tsIter.hasNext()) {
                    this.tsNext = this.tsIter.next().getValue();
                    break;
                }
                this.tsNext = null;
                break;
            }
        }

        public boolean hasNext() {
            return this.count >= 0;
        }

        public void next() {
            this.beat += this.step;
            this.isBar = Math.abs((this.beat + tol - (double)this.ts.beat) % (double)this.ts.beatsPerBar) < 2.0 * tol;
            --this.count;
            if (this.isBar && this.tsNext != null && Math.abs(this.beat - (double)this.tsNext.beat) < tol) {
                this.ts = this.tsNext;
                this.tsNext = this.tsIter.hasNext() ? this.tsIter.next().getValue() : null;
            }
        }

        public double getBeat() {
            return this.beat;
        }

        public boolean isBar() {
            return this.isBar;
        }

        public int getBar() {
            return this.ts.bar + (int)(this.beat - (double)this.ts.beat) / this.ts.beatsPerBar;
        }
    }

    public class QStepIteratorBar
    implements QStepIterator {
        public Iterator<Map.Entry<Integer, TimeSignatureEvent>> tsIter;
        TimeSignatureEvent ts = null;
        TimeSignatureEvent tsNext = null;
        int beatNext = Integer.MAX_VALUE;
        int beatNow = Integer.MIN_VALUE;
        int beat2;
        int barNow;

        QStepIteratorBar(int beat1, int beat2) {
            if (TimeSignatureList.this.dirty) {
                TimeSignatureList.this.reco();
            }
            this.beat2 = beat2;
            this.tsIter = TimeSignatureList.this.eventByBar.entrySet().iterator();
            this.ts = this.tsIter.next().getValue();
            while (this.tsIter.hasNext()) {
                this.tsNext = this.tsIter.next().getValue();
                if ((double)this.tsNext.beat > (double)beat1 + tol) {
                    this.beatNext = this.ts.beat + (beat1 - this.ts.beat) / this.ts.beatsPerBar * this.ts.beatsPerBar;
                    this.barNow = this.ts.bar + (beat1 - this.ts.beat) / this.ts.beatsPerBar - 1;
                    return;
                }
                this.ts = this.tsNext;
            }
            this.beatNext = this.ts.beat + (beat1 - this.ts.beat) / this.ts.beatsPerBar * this.ts.beatsPerBar;
            this.barNow = this.ts.bar + (beat1 - this.ts.beat) / this.ts.beatsPerBar - 1;
            this.tsNext = null;
        }

        public boolean hasNext() {
            return this.beatNext <= this.beat2;
        }

        public void next() {
            ++this.barNow;
            this.beatNow = this.beatNext;
            this.beatNext = this.beatNow + this.ts.beatsPerBar;
            if (this.tsNext != null && this.beatNext == this.tsNext.beat) {
                this.ts = this.tsNext;
                this.tsNext = this.tsIter.hasNext() ? this.tsIter.next().getValue() : null;
            }
        }

        public double getBeat() {
            return this.beatNow;
        }

        public boolean isBar() {
            return true;
        }

        public int getBar() {
            return this.barNow;
        }
    }

    public static interface QStepIterator {
        public boolean hasNext();

        public void next();

        public double getBeat();

        public boolean isBar();

        public int getBar();
    }

    public class TimeSignatureEvent {
        public final int bar;
        public int beat;
        public final int beatsPerBar;

        TimeSignatureEvent(int bar, int nBeatPerbar) {
            this.beatsPerBar = nBeatPerbar;
            this.bar = bar;
            this.beat = -1;
        }

        void display() {
            System.out.print(this.beatsPerBar);
        }
    }
}

