/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model.audio;

import java.io.IOException;
import java.io.RandomAccessFile;
import javax.sound.sampled.AudioFormat;

public class AudioWavReader {
    protected static String sp = "     ";
    static String indent = sp + "     ";
    protected long audioDataStartBytePtr;
    protected int audioDataByteLength;
    protected int lengthInFrames = 0;
    protected int bytecount = 0;
    protected int riffdata = 0;
    protected AudioFormat format;
    protected int nChannels;
    private RandomAccessFile fis;

    public AudioWavReader(RandomAccessFile fis) throws IOException {
        String sfield = "";
        this.fis = fis;
        fis.seek(0L);
        long filesize = fis.length();
        this.readChunkHeader(fis);
        while (this.bytecount < this.riffdata) {
            sfield = "";
            for (int i = 1; i <= 4; ++i) {
                sfield = sfield + (char)fis.readByte();
            }
            int chunkSize = 0;
            for (int i = 0; i < 4; ++i) {
                chunkSize += fis.readUnsignedByte() * (int)Math.pow(256.0, i);
            }
            if (sfield.equals("data")) {
                this.audioDataStartBytePtr = fis.getFilePointer();
                this.audioDataByteLength = (int)(filesize - this.audioDataStartBytePtr);
            }
            this.bytecount += 8 + chunkSize;
            if (sfield.equals("fmt ")) {
                this.readFormat(fis, chunkSize);
            } else {
                fis.skipBytes(chunkSize);
            }
            this.lengthInFrames = chunkSize / this.format.getFrameSize();
        }
        if (8 + this.bytecount != (int)filesize) {
            System.out.println(sp + "!!!!!!! Problem with file structure  !!!!!!!!! ");
        }
    }

    public int getDataSize() throws IOException {
        long ptr = this.fis.getFilePointer();
        this.fis.seek(40L);
        int chunkSize = 0;
        for (int i = 0; i < 4; ++i) {
            chunkSize += this.fis.readUnsignedByte() * (int)Math.pow(256.0, i);
        }
        this.riffdata = chunkSize;
        this.fis.seek(ptr);
        this.lengthInFrames = chunkSize / this.format.getFrameSize();
        System.out.println(" GET DATA SIZE " + this.lengthInFrames);
        return chunkSize;
    }

    protected void readChunkHeader(RandomAccessFile fis) throws IOException {
        int i;
        String sfield = "";
        int chunkSize = 0;
        for (i = 1; i <= 4; ++i) {
            sfield = sfield + (char)fis.readByte();
        }
        if (!sfield.equals("RIFF")) {
            System.out.println(" ****  Not a valid RIFF file  ****");
            return;
        }
        for (i = 0; i < 4; ++i) {
            chunkSize += fis.readUnsignedByte() * (int)Math.pow(256.0, i);
        }
        sfield = "";
        for (i = 1; i <= 4; ++i) {
            sfield = sfield + (char)fis.readByte();
        }
        this.riffdata = chunkSize;
        this.bytecount = 4;
    }

    public int getLengthInFrames() {
        return this.lengthInFrames;
    }

    protected void readFormat(RandomAccessFile fis, int chunkSize) throws IOException {
        if (chunkSize < 16) {
            System.out.println(" ****  Not a valid fmt chunk  ****");
            return;
        }
        int wFormatTag = fis.readUnsignedByte();
        fis.skipBytes(1);
        this.nChannels = fis.readUnsignedByte();
        fis.skipBytes(1);
        int nSamplesPerSec = 0;
        for (int i = 0; i < 4; ++i) {
            nSamplesPerSec += fis.readUnsignedByte() * (int)Math.pow(256.0, i);
        }
        int nAvgBytesPerSec = 0;
        for (int i = 0; i < 4; ++i) {
            nAvgBytesPerSec += fis.readUnsignedByte() * (int)Math.pow(256.0, i);
        }
        int nBlockAlign = 0;
        for (int i = 0; i < 2; ++i) {
            nBlockAlign += fis.readUnsignedByte() * (int)Math.pow(256.0, i);
        }
        int nBitsPerSample = 0;
        if (wFormatTag == 1) {
            nBitsPerSample = fis.readUnsignedByte();
            fis.skipBytes(1);
        } else {
            fis.skipBytes(2);
        }
        fis.skipBytes(chunkSize - 16);
        this.format = new AudioFormat(nSamplesPerSec, nBitsPerSample, this.nChannels, true, false);
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public int getChannels() {
        return this.nChannels;
    }
}

