/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model.audio;

import com.frinika.audio.toot.SynchronizedAudioProcess;
import com.frinika.sequencer.FrinikaSequencer;
import com.frinika.sequencer.SongPositionListener;
import com.frinika.sequencer.model.audio.AudioReader;
import java.io.IOException;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.server.AudioServer;

public class AudioStreamVoice
extends SynchronizedAudioProcess {
    AudioReader ais;
    boolean running = false;
    byte[] byteBuffer = null;
    int nChannel;
    long clipStartPositionInMillis;
    long clipStartPositionInFrames;
    long framePos = -1L;
    private float sampleRate;

    public AudioStreamVoice(final AudioServer audioServer, final FrinikaSequencer sequencer, AudioReader ais, long clipStartTimePosition1) throws Exception {
        super(audioServer, 0L);
        this.sampleRate = audioServer.getSampleRate();
        this.ais = ais;
        this.setRealStartTime(clipStartTimePosition1);
        this.nChannel = ais.getFormat().getChannels();
        sequencer.addSongPositionListener(new SongPositionListener(){

            public void notifyTickPosition(long tick) {
                AudioStreamVoice.this.setRunning(sequencer.isRunning());
                AudioStreamVoice.this.setFramePos(AudioStreamVoice.getFramePos(sequencer, audioServer, AudioStreamVoice.this.clipStartPositionInMillis));
            }

            public boolean requiresNotificationOnEachTick() {
                return false;
            }
        });
    }

    long milliToFrame(double t) {
        return (long)(t * (double)this.sampleRate / 1000000.0);
    }

    private static long getFramePos(FrinikaSequencer sequencer, AudioServer audioServer, long clipStartTimePosition) {
        return (long)((float)(sequencer.getMicrosecondPosition() - clipStartTimePosition) * audioServer.getSampleRate() / 1000000.0f);
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public void processAudioSynchronized(AudioBuffer buffer) {
        long seekPos;
        if (!this.running) {
            return;
        }
        boolean realTime = buffer.isRealTime();
        if (this.byteBuffer == null || this.byteBuffer.length != buffer.getSampleCount() * 2 * this.nChannel) {
            this.byteBuffer = new byte[buffer.getSampleCount() * 2 * this.nChannel];
        }
        if ((seekPos = this.getFramePos()) != this.framePos) {
            try {
                this.ais.seekFrame(seekPos, realTime);
                this.framePos = seekPos;
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        this.ais.processAudio(buffer);
        if (this.ais.getChannels() == 1) {
            buffer.copyChannel(0, 1);
        }
        this.framePos += (long)buffer.getSampleCount();
    }

    public void setRealStartTime(long realStartTime) {
        this.clipStartPositionInMillis = realStartTime;
        this.clipStartPositionInFrames = (long)((float)this.clipStartPositionInMillis * this.sampleRate / 1000000.0f);
    }

    public void close() {
    }

    public void open() {
    }
}

