/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model.audio;

import com.frinika.sequencer.model.audio.AudioWavReader;
import com.frinika.sequencer.model.audio.BlockableAudioProcess;
import com.frinika.sequencer.model.audio.RandomAccessFileIF;
import java.io.IOException;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.AudioProcess;

public class AudioReader
extends AudioWavReader
implements BlockableAudioProcess,
AudioProcess {
    RandomAccessFileIF bfis;
    long startByte;
    long endByte;
    byte[] byteBuff;
    long fPtrBytes;
    double sampleRate;
    private boolean closed;

    public AudioReader(RandomAccessFileIF fisIF) throws IOException {
        super(fisIF.getRandomAccessFile());
        this.sampleRate = this.format.getSampleRate();
        this.startByte = 0L;
        this.endByte = this.audioDataByteLength;
        this.closed = this.endByte != 0L;
        this.bfis = fisIF;
        fisIF.seek(this.audioDataStartBytePtr, false);
    }

    final long milliToByte(double milli) {
        return (long)(this.nChannels * 2) * (long)(milli * this.sampleRate / 1000000.0);
    }

    public void seekTimeInMicros(double micros, boolean realTime) throws IOException {
        long framePos = (long)(micros * this.sampleRate / 1000000.0);
        this.seekFrame(framePos, realTime);
    }

    public void seekFrame(long framePos, boolean realTime) throws IOException {
        this.fPtrBytes = framePos * 2L * (long)this.nChannels;
        if (this.fPtrBytes >= this.startByte) {
            if (this.fPtrBytes < (long)this.audioDataByteLength && this.fPtrBytes < this.endByte) {
                this.bfis.seek(this.fPtrBytes + this.audioDataStartBytePtr, realTime);
            }
        } else {
            this.bfis.seek(this.audioDataStartBytePtr + this.startByte, realTime);
        }
    }

    public boolean eof() {
        try {
            return this.fPtrBytes - this.audioDataStartBytePtr >= this.bfis.length();
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
    }

    public void setBoundsInMicros(double start, double end) {
        assert (start <= end);
        this.startByte = Math.max(0L, this.milliToByte(start));
        this.endByte = Math.min((long)this.audioDataByteLength, this.milliToByte(end));
    }

    public void close() {
    }

    public void open() {
    }

    public void processAudioBlock(AudioBuffer buffer) throws Exception {
        if (this.closed) {
            this.processAudio(buffer);
            return;
        }
        int n = buffer.getSampleCount();
        while ((long)n + this.fPtrBytes - this.audioDataStartBytePtr >= this.bfis.length()) {
            if (this.getLengthInFrames() > 0) {
                this.closed = true;
                break;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        int nBytes = this.nChannels * 2 * buffer.getSampleCount();
        boolean realTime = buffer.isRealTime();
        if (this.byteBuff == null || this.byteBuff.length != nBytes) {
            this.byteBuff = new byte[nBytes];
        }
        int nread = this.bfis.read(this.byteBuff, 0, nBytes, false);
        this.fill(buffer, 0, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int processAudio(AudioBuffer buffer) {
        int nBytes = this.nChannels * 2 * buffer.getSampleCount();
        boolean realTime = buffer.isRealTime();
        if (this.byteBuff == null || this.byteBuff.length != nBytes) {
            this.byteBuff = new byte[nBytes];
        }
        int startChunk = 0;
        int endChunk = nBytes;
        long minEndByte = Math.min(this.endByte, (long)this.audioDataByteLength);
        try {
            if (this.fPtrBytes < this.startByte) {
                int nRead = (int)((long)nBytes + this.fPtrBytes - this.startByte);
                if (nRead <= 0) {
                    this.fPtrBytes += (long)nBytes;
                    return 0;
                }
                startChunk = nBytes - nRead;
                this.bfis.read(this.byteBuff, startChunk, nRead, realTime);
            } else {
                if (this.fPtrBytes > minEndByte) {
                    this.fPtrBytes += (long)nBytes;
                    return 0;
                }
                int nExtra = (int)(this.fPtrBytes + (long)nBytes - minEndByte);
                if (nExtra > 0) {
                    endChunk = nBytes - nExtra;
                    this.bfis.read(this.byteBuff, 0, endChunk, realTime);
                } else {
                    int nread = this.bfis.read(this.byteBuff, 0, nBytes, realTime);
                    if (nread != nBytes) {
                        try {
                            throw new Exception(" Ooops only read " + nread + " out of " + nBytes);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            this.processAudioImp(buffer, startChunk, endChunk);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.fPtrBytes += (long)nBytes;
        return 0;
    }

    protected void processAudioImp(AudioBuffer buffer, int startChunk, int endChunk) {
        this.fill(buffer, startChunk, endChunk);
    }

    protected void fillLinearInterpolate(AudioBuffer buffer, int startChunk, int endChunk, double gain1, double gain2) {
        double dG = (gain2 - gain1) / (double)(endChunk - startChunk) / (double)this.nChannels / 2.0;
        if (this.nChannels == 2) {
            float[] left = buffer.getChannel(0);
            float[] right = buffer.getChannel(1);
            for (int n = startChunk / 2; n < endChunk / 2; ++n) {
                float sample = (float)((short)((0xFF & this.byteBuff[n * 2 + 0]) + (0xFF & this.byteBuff[n * 2 + 1]) * 256)) / 32768.0f;
                sample = (float)((double)sample * gain1);
                if (n % 2 == 0) {
                    int n2 = n / 2;
                    left[n2] = left[n2] + sample;
                } else {
                    int n3 = n / 2;
                    right[n3] = right[n3] + sample;
                }
                gain1 += dG;
            }
        } else {
            float[] left = buffer.getChannel(0);
            for (int n = startChunk; n < endChunk; n += 2) {
                float val = (float)((short)((0xFF & this.byteBuff[n]) + (0xFF & this.byteBuff[n + 1]) * 256)) / 32768.0f;
                int n4 = n / 2;
                left[n4] = (float)((double)left[n4] + (double)val * gain1);
                gain1 += dG;
            }
        }
    }

    protected void fillConstantGain(AudioBuffer buffer, int startChunk, int endChunk, double gain) {
        if (this.nChannels == 2) {
            float[] left = buffer.getChannel(0);
            float[] right = buffer.getChannel(1);
            for (int n = startChunk / 2; n < endChunk / 2; ++n) {
                float sample = (float)((short)((0xFF & this.byteBuff[n * 2 + 0]) + (0xFF & this.byteBuff[n * 2 + 1]) * 256)) / 32768.0f;
                sample = (float)((double)sample * gain);
                if (n % 2 == 0) {
                    int n2 = n / 2;
                    left[n2] = left[n2] + sample;
                    continue;
                }
                int n3 = n / 2;
                right[n3] = right[n3] + sample;
            }
        } else {
            float[] left = buffer.getChannel(0);
            for (int n = startChunk; n < endChunk; n += 2) {
                float val = (float)((short)((0xFF & this.byteBuff[n]) + (0xFF & this.byteBuff[n + 1]) * 256)) / 32768.0f;
                int n4 = n / 2;
                left[n4] = (float)((double)left[n4] + (double)val * gain);
            }
        }
    }

    protected void fill(AudioBuffer buffer, int startChunk, int endChunk) {
        if (this.nChannels == 2) {
            float[] left = buffer.getChannel(0);
            float[] right = buffer.getChannel(1);
            for (int n = startChunk / 2; n < endChunk / 2; ++n) {
                float sample = (float)((short)((0xFF & this.byteBuff[n * 2 + 0]) + (0xFF & this.byteBuff[n * 2 + 1]) * 256)) / 32768.0f;
                if (n % 2 == 0) {
                    int n2 = n / 2;
                    left[n2] = left[n2] + sample;
                    continue;
                }
                int n3 = n / 2;
                right[n3] = right[n3] + sample;
            }
        } else {
            float[] left = buffer.getChannel(0);
            for (int n = startChunk; n < endChunk; n += 2) {
                float val = (float)((short)((0xFF & this.byteBuff[n]) + (0xFF & this.byteBuff[n + 1]) * 256)) / 32768.0f;
                int n4 = n / 2;
                left[n4] = left[n4] + val;
            }
        }
    }
}

