/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model;

import com.frinika.global.Toolbox;
import com.frinika.localization.CurrentLocale;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.model.AbstractSysexMacro;
import com.frinika.sequencer.model.EditHistoryAction;
import com.frinika.sequencer.model.EditHistoryRecordable;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.SysexMacro;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.StringTokenizer;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.SysexMessage;
import javax.swing.JOptionPane;

public class SysexEvent
extends MultiEvent {
    private static final long serialVersionUID = 1L;
    protected String macro;
    protected transient MidiEvent[] midiEvents = new MidiEvent[0];

    public SysexEvent(MidiPart part, long startTick) {
        super(part, startTick);
    }

    public SysexEvent(MidiPart part, long startTick, String macro) {
        this(part, startTick);
        this.setMacroString(macro);
    }

    public SysexEvent(MidiPart part, long startTick, byte[] data) {
        this(part, startTick);
        this.setData(data);
    }

    public void setMacroString(String macro) {
        this.macro = macro;
        try {
            this.midiEvents = this.parseMacro(macro);
        }
        catch (InvalidMidiDataException imde) {
            this.midiEvents = new MidiEvent[0];
            imde.printStackTrace();
        }
    }

    public void setData(byte[] data) {
        try {
            SysexMessage syxm = new SysexMessage();
            syxm.setMessage(data, data.length);
            this.midiEvents = new MidiEvent[]{new MidiEvent(syxm, this.startTick)};
        }
        catch (InvalidMidiDataException imde) {
            imde.printStackTrace();
        }
    }

    public boolean isSuccessfullyParsed() {
        return this.midiEvents != null;
    }

    protected MidiEvent[] parseMacro(String macro) throws InvalidMidiDataException {
        if (macro == null || macro.trim().length() == 0) {
            return new MidiEvent[0];
        }
        SysexMacro m = AbstractSysexMacro.findMacro(macro);
        if (m == null) {
            throw new InvalidMidiDataException("Cannot find macro '" + Toolbox.firstWord(macro) + "'.");
        }
        MidiMessage[] mm = null;
        mm = m.parseMessages(macro);
        if (mm == null) {
            throw new InvalidMidiDataException("Parsing of '" + macro + "' failed.");
        }
        MidiEvent[] me = new MidiEvent[mm.length];
        for (int i = 0; i < mm.length; ++i) {
            me[i] = new MidiEvent(mm[i], this.getStartTick());
        }
        return me;
    }

    public void showEditorGUI(ProjectFrame frame) {
        boolean err;
        final String oldMacroString = this.macro;
        do {
            err = false;
            final String s = JOptionPane.showInputDialog(frame, CurrentLocale.getMessage("sequencer.sysex.edit_sysex") + ":", oldMacroString);
            if (s != null) {
                if (s.equals(oldMacroString)) continue;
                try {
                    final MidiEvent[] events = this.parseMacro(s);
                    final MidiEvent[] oldEvents = this.midiEvents;
                    ProjectContainer project = frame.getProjectContainer();
                    project.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.sysex.edit_sysex"));
                    EditHistoryAction action = new EditHistoryAction(){

                        public void redo() {
                            SysexEvent.this.macro = s;
                            SysexEvent.this.commitRemove();
                            SysexEvent.this.midiEvents = events;
                            SysexEvent.this.commitAdd();
                        }

                        public void undo() {
                            SysexEvent.this.macro = oldMacroString;
                            SysexEvent.this.commitRemove();
                            SysexEvent.this.midiEvents = oldEvents;
                            SysexEvent.this.commitAdd();
                        }
                    };
                    action.redo();
                    project.getEditHistoryContainer().push(action);
                    project.getEditHistoryContainer().notifyEditHistoryListeners();
                }
                catch (InvalidMidiDataException imde) {
                    frame.error(imde.getMessage());
                    err = true;
                }
                continue;
            }
            this.macro = oldMacroString;
        } while (err);
    }

    public void commitAddImpl() {
        for (int i = 0; i < this.midiEvents.length; ++i) {
            this.getTrack().add(this.midiEvents[i]);
        }
        this.zombie = false;
    }

    void commitRemoveImpl() {
        for (int i = 0; i < this.midiEvents.length; ++i) {
            this.getTrack().remove(this.midiEvents[i]);
        }
        this.zombie = true;
    }

    public long getEndTick() {
        return this.getStartTick();
    }

    public void restoreFromClone(EditHistoryRecordable object) {
        SysexEvent other = (SysexEvent)object;
        this.part = other.part;
        this.setMacroString(other.macro);
        this.startTick = other.startTick;
    }

    public static byte[] parseHex(String s) {
        StringTokenizer st = new StringTokenizer(s, " \t\n\r", false);
        int size = st.countTokens();
        byte[] data = new byte[size];
        for (int i = 0; i < data.length; ++i) {
            int b;
            String tok = st.nextToken();
            try {
                b = (byte)(Integer.parseInt(tok, 16) & 0xFF);
            }
            catch (NumberFormatException nfe) {
                b = -1;
            }
            data[i] = b;
        }
        return data;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.setMacroString(this.macro);
    }
}

