/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model;

import com.frinika.audio.toot.AudioPeakMonitor;
import com.frinika.audio.toot.FrinikaAudioServer;
import com.frinika.audio.toot.FrinikaAudioSystem;
import com.frinika.global.FrinikaConfig;
import com.frinika.localization.CurrentLocale;
import com.frinika.project.MidiDeviceDescriptor;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.FrinikaSequence;
import com.frinika.sequencer.FrinikaSequencer;
import com.frinika.sequencer.gui.mixer.MidiDeviceIconProvider;
import com.frinika.sequencer.gui.mixer.SynthWrapper;
import com.frinika.sequencer.model.AudioPart;
import com.frinika.sequencer.model.EditHistoryRecordable;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.Part;
import com.frinika.sequencer.model.RecordableLane;
import com.frinika.sequencer.model.Selectable;
import com.frinika.sequencer.model.audio.AudioWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.AudioProcess;
import uk.org.toot.audio.mixer.MixControls;

public class SynthLane
extends Lane
implements RecordableLane {
    private static final long serialVersionUID = 1L;
    MidiDeviceDescriptor midiDeviceDescriptor = null;
    private boolean isRendered = false;
    transient AudioProcess audioSynthProcess;
    transient AudioProcess audioProcess;
    transient AudioPeakMonitor peakMonitor;
    transient File clipFile = null;
    static int stripNo = 0;
    private transient MixControls mixerControls = null;
    private transient boolean isRendering = false;
    transient boolean isInstalled = false;

    public SynthLane() {
    }

    public SynthLane(ProjectContainer project, MidiDeviceDescriptor desc) {
        super(null, project);
        this.install(desc);
        this.channelLabel = new AudioBuffer.MetaInfo(this.getName());
    }

    public void attachAudioProcessToMixer() {
        this.peakMonitor = new AudioPeakMonitor();
        this.audioProcess = new AudioProcess(){

            public void close() {
            }

            public void open() {
            }

            public int processAudio(AudioBuffer buffer) {
                if (!SynthLane.this.isInstalled) {
                    return 0;
                }
                if (!SynthLane.this.isRendered) {
                    SynthLane.this.audioSynthProcess.processAudio(buffer);
                } else {
                    buffer.makeSilence();
                    if (!SynthLane.this.parts.isEmpty() && SynthLane.this.parts.get(0) != null) {
                        ((AudioPart)SynthLane.this.parts.get(0)).getAudioProcess().processAudio(buffer);
                    }
                }
                SynthLane.this.peakMonitor.processAudio(buffer);
                buffer.setMetaInfo(SynthLane.this.channelLabel);
                return 0;
            }
        };
        try {
            this.mixerControls = this.project.addMixerInput(this.audioProcess, stripNo++ + "X");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return this.midiDeviceDescriptor.getProjectName();
    }

    public void setName(String name) {
        ProjectFrame frame;
        if (name != null && this.midiDeviceDescriptor != null) {
            this.midiDeviceDescriptor.setProjectName(name);
        }
        if ((frame = ProjectFrame.findFrame(this.project)) != null) {
            frame.getMidiDevicesPanel().updateDeviceTabs();
        }
        this.channelLabel = new AudioBuffer.MetaInfo(name);
    }

    public void removeFromModel() {
        ProjectFrame frame = ProjectFrame.findFrame(this.project);
        if (frame != null) {
            frame.getMidiDevicesPanel().remove(this.getMidiDescriptor().getMidiDevice());
            frame.getMidiDevicesPanel().updateDeviceTabs();
        }
        super.removeFromModel();
    }

    public Selectable deepCopy(Selectable parent) {
        return null;
    }

    public void deepMove(long tick) {
    }

    public void restoreFromClone(EditHistoryRecordable object) {
    }

    public boolean install(MidiDeviceDescriptor desc) {
        if (this.midiDeviceDescriptor != null && this.midiDeviceDescriptor != desc) {
            try {
                throw new Exception(" Synthlane already attached to a different device ");
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        this.midiDeviceDescriptor = desc;
        if (!(this.midiDeviceDescriptor.getMidiDevice() instanceof SynthWrapper)) {
            try {
                throw new Exception(" SynthLane can not attach to " + this.midiDeviceDescriptor.getMidiDevice());
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        this.audioSynthProcess = ((SynthWrapper)this.midiDeviceDescriptor.getMidiDevice()).getAudioProcess();
        this.isInstalled = true;
        if (!this.parts.isEmpty()) {
            try {
                ((Part)this.parts.get(0)).onLoad();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private File getAudioFile() {
        if (this.clipFile != null) {
            return this.clipFile;
        }
        if (!this.parts.isEmpty()) {
            AudioPart part = (AudioPart)this.parts.get(0);
            this.clipFile = part.getAudioFile();
            return this.clipFile;
        }
        ProjectContainer proj = this.getProject();
        File audioDir = proj.getAudioDirectory();
        String audioFileName = this.getName() + ".wav";
        this.clipFile = new File(audioDir, audioFileName);
        int cnt = 1;
        while (this.clipFile.exists()) {
            audioFileName = this.getName() + "_" + cnt++ + ".wav";
            this.clipFile = new File(audioDir, audioFileName);
        }
        return this.clipFile;
    }

    private void setAudioFile(File clipFile, double startTimeInMicros) {
        if (!this.parts.isEmpty()) {
            this.remove((Part)this.parts.get(0));
        }
        if (clipFile != null) {
            try {
                AudioPart newPart = new AudioPart(this, clipFile, startTimeInMicros);
                newPart.onLoad();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        this.project.getEditHistoryContainer().notifyEditHistoryListeners();
    }

    public double getMonitorValue() {
        if (this.peakMonitor == null) {
            return 0.0;
        }
        return this.peakMonitor.getPeak();
    }

    public void setMute(boolean b) {
        if (this.mixerControls == null) {
            return;
        }
        this.mixerControls.getMuteControl().setValue(b);
    }

    public void setSolo(boolean b) {
        if (this.mixerControls == null) {
            return;
        }
        this.mixerControls.getSoloControl().setValue(b);
    }

    public boolean isRecording() {
        if (this.mixerControls == null) {
            return false;
        }
        return this.isRendered;
    }

    public boolean isSynthesizer() {
        return this.mixerControls != null;
    }

    public void setRecording(boolean b) {
        if (this.mixerControls == null) {
            return;
        }
        if (this.isRendering) {
            return;
        }
        if (b == this.isRendered) {
            return;
        }
        if (b) {
            this.isRendering = true;
            SynthRenderer renderer = new SynthRenderer();
            Thread t = new Thread(renderer);
            t.start();
        } else {
            this.isRendered = false;
            this.setAudioFile(null, 0.0);
        }
    }

    public MixControls getMixerControls() {
        return this.mixerControls;
    }

    public boolean isMute() {
        if (this.mixerControls == null) {
            return false;
        }
        return this.mixerControls.getMuteControl().getValue();
    }

    public boolean isSolo() {
        if (this.mixerControls == null) {
            return false;
        }
        return this.mixerControls.getSoloControl().getValue();
    }

    public MidiDeviceDescriptor getMidiDescriptor() {
        return this.midiDeviceDescriptor;
    }

    public Part createPart() {
        try {
            throw new Exception(" Attempt to create an SynthlanePart");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Icon getIcon() {
        return ((MidiDeviceIconProvider)((Object)this.getMidiDescriptor().getMidiDevice())).getIcon();
    }

    class SynthRenderer
    implements Runnable {
        private static final long serialVersionUID = 1L;
        FrinikaSequencer sequencer;
        FrinikaSequence sequence;
        JProgressBar bar;
        JFrame frame;
        double sampleRate;
        long currentPos;
        long startTick;
        long stopTick;

        SynthRenderer() {
        }

        public void run() {
            AudioWriter writer;
            this.sequencer = SynthLane.this.project.getSequencer();
            this.sequence = SynthLane.this.project.getSequence();
            int ticksPerbeat = this.sequence.getResolution();
            this.currentPos = this.sequencer.getTickPosition();
            this.startTick = this.sequencer.getLoopStartPoint();
            this.stopTick = this.sequencer.getLoopEndPoint();
            this.frame = new JFrame();
            this.bar = new JProgressBar(0, (int)(this.stopTick - this.startTick));
            this.frame.setContentPane(this.bar);
            this.frame.pack();
            this.frame.setVisible(true);
            SynthLane.this.project.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.project.render_synth"));
            this.sampleRate = FrinikaConfig.sampleRate;
            double samplesPerTick = this.samplesPerTick();
            int samplesPerFrame = 128;
            AudioFormat format = new AudioFormat(FrinikaConfig.sampleRate, 16, 2, true, false);
            FrinikaAudioServer server = FrinikaAudioSystem.getAudioServer();
            File clipFile = SynthLane.this.getAudioFile();
            try {
                writer = new AudioWriter(clipFile, format);
            }
            catch (IOException e) {
                e.printStackTrace();
                if (this.frame != null) {
                    this.frame.dispose();
                }
                return;
            }
            AudioBuffer buffer = new AudioBuffer("renderbuf", 2, samplesPerFrame, (float)this.sampleRate);
            samplesPerFrame = buffer.getSampleCount();
            this.sequencer.setTickPosition(this.startTick);
            FrinikaAudioSystem.stealAudioServer(this, null);
            server.stop();
            this.sequencer.setRealtime(false);
            this.sequencer.start();
            double samplesRendered = 0.0;
            double samplesTarget = 0.0;
            do {
                this.sequencer.nonRealtimeNextTick();
                samplesTarget += this.samplesPerTick();
                while (samplesRendered < samplesTarget) {
                    SynthLane.this.audioSynthProcess.processAudio(buffer);
                    writer.processAudio(buffer);
                    samplesRendered += (double)samplesPerFrame;
                }
                this.bar.setValue((int)(this.sequencer.getTickPosition() - this.startTick));
            } while (this.sequencer.getTickPosition() < this.stopTick);
            this.sequencer.stop();
            this.sequencer.setRealtime(true);
            this.sequencer.setTickPosition(this.currentPos);
            writer.close();
            double startTime = SynthLane.this.project.getTempoList().getTimeAtTick(this.startTick);
            SynthLane.this.setAudioFile(clipFile, startTime * 1000000.0);
            SynthLane.this.project.getEditHistoryContainer().notifyEditHistoryListeners();
            server.start();
            FrinikaAudioSystem.returnAudioServer(this);
            SynthLane.this.isRendering = false;
            SynthLane.this.isRendered = true;
            if (this.frame != null) {
                this.frame.dispose();
            }
        }

        double samplesPerTick() {
            double ticksPerSecond = (double)((float)this.sequence.getResolution() * this.sequencer.getTempoInBPM()) / 60.0;
            double seconds = 1.0 / ticksPerSecond;
            return seconds * this.sampleRate;
        }
    }
}

