/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model;

import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.gui.ItemPanel;
import com.frinika.sequencer.model.AudioLane;
import com.frinika.sequencer.model.AudioPart;
import com.frinika.sequencer.model.EditHistoryAction;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.Part;
import java.io.FileNotFoundException;
import java.util.Vector;

public class SplitPartAction
implements EditHistoryAction {
    ProjectContainer project;
    ItemPanel panel;
    Vector<Part> victims = new Vector();
    Vector<Part> newParts = null;
    long splitTick;

    public SplitPartAction(ProjectContainer project, long tick) {
        this.splitTick = tick;
        for (Part part : project.getPartSelection().getSelected()) {
            Lane lane = part.getLane();
            if (!(lane instanceof MidiLane) && !(lane instanceof AudioLane) || part.getStartTick() >= tick || part.getEndTick() <= tick) continue;
            this.victims.add(part);
        }
        this.project = project;
    }

    public void undo() {
        for (Part part : this.newParts) {
            ((MidiPart)part).commitEventsRemove();
            part.lane.parts.remove(part);
        }
        for (Part part : this.victims) {
            part.lane.parts.add(part);
            part.commitEventsAdd();
        }
        this.project.getPartSelection().removeSelected(this.newParts);
    }

    public void redo() {
        if (this.newParts != null) {
            for (Part part : this.victims) {
                part.commitEventsRemove();
                part.lane.parts.remove(part);
            }
            for (Part part : this.newParts) {
                ((MidiPart)part).commitEventsAdd();
            }
            return;
        }
        this.newParts = new Vector();
        Part focus = (Part)this.project.getPartSelection().getFocus();
        for (Part part : this.victims) {
            if (part instanceof MidiPart) {
                this.midiPartRedo((MidiPart)part);
                continue;
            }
            if (!(part instanceof AudioPart)) continue;
            this.audioPartRedo((AudioPart)part);
        }
        this.project.getPartSelection().removeSelected(this.victims);
        this.project.getPartSelection().addSelected(this.newParts);
    }

    void midiPartRedo(MidiPart part) {
        part.commitEventsRemove();
        part.lane.parts.remove(part);
        MidiPart left = new MidiPart((MidiLane)part.getLane());
        left.setStartTick(part.getStartTick());
        left.setEndTick(this.splitTick);
        MidiPart right = new MidiPart((MidiLane)part.getLane());
        right.setStartTick(this.splitTick);
        right.setEndTick(part.getEndTick());
        this.newParts.add(left);
        this.newParts.add(right);
        for (MultiEvent ev : part.getMultiEvents()) {
            MidiPart dst = ev.getStartTick() < this.splitTick ? left : right;
            MultiEvent eNew = (MultiEvent)ev.deepCopy(dst);
            dst.getMultiEvents().add(eNew);
        }
        left.commitEventsAdd();
        right.commitEventsAdd();
    }

    void audioPartRedo(AudioPart part) {
        part.lane.parts.remove(part);
        AudioPart left = (AudioPart)part.deepCopy(part.getLane());
        left.getEvelope().setTFall(0.0);
        left.setStartTick(part.getStartTick());
        left.setEndTick(this.splitTick);
        try {
            left.onLoad();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        AudioPart right = (AudioPart)part.deepCopy(part.getLane());
        right.getEvelope().setTRise(0.0);
        right.setStartTick(this.splitTick);
        right.setEndTick(part.getEndTick());
        try {
            right.onLoad();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.newParts.add(left);
        this.newParts.add(right);
    }
}

