/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model;

import com.frinika.sequencer.midi.groovepattern.GroovePattern;
import com.frinika.sequencer.midi.groovepattern.GroovePatternManager;
import com.frinika.sequencer.model.NoteEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;

public class Quantization
implements Serializable {
    private static final long serialVersionUID = 1L;
    public int interval = 64;
    public float intensity = 1.0f;
    public float swing = 0.0f;
    public boolean quantizeNoteStart = true;
    public boolean quantizeNoteLength = false;
    public float smudge = 0.5f;
    public float velocity = 0.0f;
    public transient GroovePattern groovePattern = null;
    private String groovePatternName;
    private static final int[] DUMMY = new int[1];

    public long quantize(long tick, int[] velocityByRef) {
        long t = tick + (long)(this.interval / 2);
        long rest = t % (long)this.interval;
        long target = t - rest;
        long swingShift = 0L;
        if (this.swing != 0.0f && target / (long)this.interval % 2L == 1L) {
            swingShift += (long)Math.round((float)this.interval * this.swing);
        }
        if (this.groovePattern != null) {
            target = this.groovePattern.quantize(target, this.interval, this.smudge, velocityByRef);
        }
        int diff = (int)((target += swingShift) - tick);
        int sDiff = Math.round((float)diff * this.intensity);
        return tick + (long)sDiff;
    }

    public MidiEvent quantize(MidiEvent event) {
        byte[] data = event.getMessage().getMessage();
        int status = data[0] & 0xF0;
        int vel = data[2];
        if (this.quantizeNoteStart && status == 144 && vel != 0 || this.quantizeNoteLength && (status == 128 || vel == 0 && status == 144)) {
            MidiMessage message;
            long tick = event.getTick();
            int[] velocityByRef = new int[]{-1};
            long qTick = this.quantize(tick, velocityByRef);
            int targetVel = velocityByRef[0];
            if (vel != 0 && targetVel != -1 && this.velocity != 0.0f && this.groovePattern != null) {
                int d;
                if ((vel += (d = Math.round((float)(targetVel - vel) * this.velocity))) < 1) {
                    vel = 1;
                } else if (vel > 127) {
                    vel = 127;
                }
                message = new ShortMessage();
                try {
                    ((ShortMessage)message).setMessage(data[0], data[1], vel);
                }
                catch (InvalidMidiDataException imde) {
                    System.err.println("something went wrong while quantizing a MidiEvent");
                    return event;
                }
            } else {
                message = event.getMessage();
            }
            if ((status == 128 || vel == 0) && qTick != tick && qTick > 0L) {
                --qTick;
            }
            MidiEvent newEvent = new MidiEvent(message, qTick);
            return newEvent;
        }
        return event;
    }

    public void quantize(NoteEvent note) {
        if (this.quantizeNoteStart) {
            long tick = note.getStartTick();
            int[] velocityByRef = new int[]{-1};
            long qTick = this.quantize(tick, velocityByRef);
            note.setStartTick(qTick);
            int targetVel = velocityByRef[0];
            if (targetVel != -1 && this.velocity != 0.0f && this.groovePattern != null) {
                int vel = note.getVelocity();
                if ((vel = Math.round((float)vel + (float)(targetVel - vel) * this.velocity)) > 127) {
                    vel = 127;
                } else if (vel < 1) {
                    vel = 1;
                }
                note.setVelocity(vel);
            }
        }
        if (this.quantizeNoteLength) {
            long len = note.getDuration();
            long qLen = this.quantize(len, DUMMY);
            if (qLen == 0L) {
                qLen = this.interval;
            }
            note.setDuration(--qLen);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.groovePatternName = this.groovePattern != null ? this.groovePattern.getName() : null;
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        if (this.groovePatternName != null) {
            this.groovePattern = GroovePatternManager.getInstance().getGroovePattern(this.groovePatternName);
        } else {
            this.groovePatternName = null;
        }
    }
}

