/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model;

import com.frinika.sequencer.model.EditHistoryAction;
import com.frinika.sequencer.model.EditHistoryContainer;
import com.frinika.sequencer.model.EditHistoryRecordable;
import com.frinika.sequencer.model.EditHistoryRecorder;

public class EditHistoryRecordableAction
implements EditHistoryAction {
    private int editHistoryType;
    EditHistoryRecordable recordable;
    EditHistoryRecordable recordableClone = null;
    EditHistoryContainer editHistoryContainer;
    EditHistoryRecorder editHistoryRecorder;
    public static final int EDIT_HISTORY_TYPE_ADD = 0;
    public static final int EDIT_HISTORY_TYPE_REMOVE = 1;

    public EditHistoryRecordableAction(EditHistoryContainer editHistoryContainer, EditHistoryRecorder recorder, int editHistoryType, EditHistoryRecordable recordable) {
        this.editHistoryRecorder = recorder;
        this.editHistoryContainer = editHistoryContainer;
        this.editHistoryType = editHistoryType;
        this.recordable = recordable;
        try {
            this.recordableClone = (EditHistoryRecordable)recordable.clone();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public int getEditHistoryType() {
        return this.editHistoryType;
    }

    public EditHistoryRecordable getRecordable() {
        return this.recordable;
    }

    public void undo() {
        this.editHistoryContainer.disableRecording();
        if (this.editHistoryType == 0) {
            this.editHistoryRecorder.remove(this.recordable);
        } else if (this.editHistoryType == 1) {
            if (this.recordableClone != null) {
                try {
                    EditHistoryRecordable redoClone = (EditHistoryRecordable)this.recordable.clone();
                    this.recordable.restoreFromClone(this.recordableClone);
                    this.recordableClone = redoClone;
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
            }
            this.editHistoryRecorder.add(this.recordable);
        }
        this.editHistoryContainer.enableRecording();
    }

    public void redo() {
        this.editHistoryContainer.disableRecording();
        if (this.editHistoryType == 1) {
            if (this.recordableClone != null) {
                try {
                    EditHistoryRecordable undoClone = (EditHistoryRecordable)this.recordable.clone();
                    this.recordable.restoreFromClone(this.recordableClone);
                    this.recordableClone = undoClone;
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
            }
            this.editHistoryRecorder.remove(this.recordable);
        } else if (this.editHistoryType == 0) {
            this.editHistoryRecorder.add(this.recordable);
        }
        this.editHistoryContainer.enableRecording();
    }

    public String toString() {
        String editHistoryTypeString = this.editHistoryType == 0 ? "Add" : "Remove";
        return "EditHistoryEntry: " + editHistoryTypeString + " " + this.recordable;
    }

    public EditHistoryRecordableAction getInvertedClone() {
        return new EditHistoryRecordableAction(this.editHistoryContainer, this.editHistoryRecorder, ~this.editHistoryType & 1, this.recordable);
    }
}

