/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model;

import com.frinika.audio.toot.AudioPeakMonitor;
import com.frinika.audio.toot.FrinikaAudioSystem;
import com.frinika.global.FrinikaConfig;
import com.frinika.localization.CurrentLocale;
import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.FrinikaSequencer;
import com.frinika.sequencer.SequencerListener;
import com.frinika.sequencer.model.AudioPart;
import com.frinika.sequencer.model.EditHistoryRecordable;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.Part;
import com.frinika.sequencer.model.RecordableLane;
import com.frinika.sequencer.model.Selectable;
import com.frinika.sequencer.model.audio.AudioWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.sound.sampled.AudioFormat;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import rasmus.midi.provider.RasmusSynthesizer;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.AudioProcess;
import uk.org.toot.audio.core.ChannelFormat;
import uk.org.toot.audio.mixer.MixControls;
import uk.org.toot.audio.server.AudioServer;
import uk.org.toot.audio.server.IOAudioProcess;

public class AudioLane
extends Lane
implements RecordableLane,
SequencerListener {
    transient AudioProcess audioInProcess = null;
    protected transient AudioProcess audioInsert = null;
    static Icon icon = new ImageIcon(RasmusSynthesizer.class.getResource("/icons/audiolane.png"));
    public static int stripNo = 1;
    transient AudioProcess audioProcess;
    transient AudioPeakMonitor peakMonitor;
    transient boolean armed = false;
    transient boolean isRecording = false;
    transient boolean hasRecorded = false;
    transient AudioWriter writer = null;
    private transient long recordStartTimeInMicros;
    private transient FrinikaSequencer sequencer;
    private transient MixControls mixerControls = null;
    transient int stripInt = -1;
    private static final long serialVersionUID = 1L;
    protected transient File clipFile;
    static int nameCount = 0;

    public AudioLane(ProjectContainer project) {
        super("Audio " + nameCount++, project);
        this.attachAudioProcessToMixer();
    }

    public void dispose() {
        this.project.getSequencer().removeSequencerListener(this);
        this.writer.discard();
    }

    public void removeFromModel() {
        this.project.removeStrip(this.stripInt + "");
        super.removeFromModel();
    }

    private void attachAudioProcessToMixer() {
        this.peakMonitor = new AudioPeakMonitor();
        this.audioProcess = new AudioProcess(){

            public void close() {
            }

            public void open() {
            }

            public int processAudio(AudioBuffer buffer) {
                if (AudioLane.this.armed) {
                    AudioLane.this.audioInProcess.processAudio(buffer);
                    AudioLane.this.peakMonitor.processAudio(buffer);
                    if (AudioLane.this.audioInsert != null) {
                        AudioLane.this.audioInsert.processAudio(buffer);
                    }
                    if (AudioLane.this.isRecording) {
                        AudioLane.this.writer.processAudio(buffer);
                        AudioLane.this.hasRecorded = true;
                    }
                    if (FrinikaConfig.getDirectMonitoring()) {
                        buffer.makeSilence();
                    }
                } else if (AudioLane.this.project.getSequencer().isRunning()) {
                    buffer.setChannelFormat(ChannelFormat.STEREO);
                    buffer.makeSilence();
                    for (Part part : AudioLane.this.getParts()) {
                        if (((AudioPart)part).getAudioProcess() == null) continue;
                        ((AudioPart)part).getAudioProcess().processAudio(buffer);
                    }
                    AudioLane.this.peakMonitor.processAudio(buffer);
                } else {
                    buffer.makeSilence();
                }
                buffer.setMetaInfo(AudioLane.this.channelLabel);
                return 0;
            }
        };
        try {
            this.stripInt = stripNo++;
            this.mixerControls = this.project.addMixerInput(this.audioProcess, this.stripInt + "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.sequencer = this.project.getSequencer();
        this.sequencer.addSequencerListener(this);
    }

    public void restoreFromClone(EditHistoryRecordable object) {
        System.out.println("AudioLane restroeFromClone");
    }

    public Selectable deepCopy(Selectable parent) {
        return null;
    }

    public void deepMove(long tick) {
    }

    public boolean isRecording() {
        return this.armed;
    }

    public boolean isMute() {
        return this.mixerControls.getMuteControl().getValue();
    }

    public boolean isSolo() {
        return this.mixerControls.getSoloControl().getValue();
    }

    public void setRecording(boolean b) {
        if (b && this.audioInProcess == null) {
            this.armed = false;
            this.project.message(CurrentLocale.getMessage("recording.please_select_audio_input"));
            return;
        }
        this.armed = b;
    }

    public void setMute(boolean b) {
        this.mixerControls.getMuteControl().setValue(b);
    }

    public void setSolo(boolean b) {
        this.mixerControls.getSoloControl().setValue(b);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.attachAudioProcessToMixer();
    }

    public AudioProcess getAudioInDevice() {
        return this.audioInProcess;
    }

    public void setAudioInDevice(AudioProcess handle) {
        this.audioInProcess = handle;
        if (this.writer != null) {
            this.writer.close();
        }
        this.writer = this.newAudioWriter();
    }

    public double getMonitorValue() {
        return this.peakMonitor.getPeak();
    }

    public AudioWriter newAudioWriter() {
        this.clipFile = this.newFilename();
        AudioFormat format = new AudioFormat(FrinikaConfig.sampleRate, 16, ((IOAudioProcess)this.audioInProcess).getChannelFormat().getCount(), true, false);
        try {
            return new AudioWriter(this.clipFile, format);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public File newFilename() {
        ProjectContainer proj = this.getProject();
        File audioDir = proj.getAudioDirectory();
        String audioFileName = this.getName() + ".wav";
        File clipFile = new File(audioDir, audioFileName);
        int cnt = 1;
        while (clipFile.exists()) {
            audioFileName = this.getName() + "_" + cnt++ + ".wav";
            clipFile = new File(audioDir, audioFileName);
        }
        return clipFile;
    }

    public void beforeStart() {
    }

    public void start() {
        this.isRecording = this.project.getSequencer().isRecording();
        if (this.isRecording) {
            this.recordStartTimeInMicros = this.sequencer.getMicrosecondPosition();
        }
    }

    public void stop() {
        this.isRecording = false;
        if (this.hasRecorded) {
            this.project.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.audiolane.record"));
            this.writer.close();
            this.hasRecorded = false;
            AudioServer server = this.project.getAudioServer();
            int latencyInframes = FrinikaAudioSystem.getTotalLatency();
            System.out.println(" latency in frames is " + latencyInframes);
            double latencyInMicros = (double)latencyInframes * 1000000.0 / (double)server.getSampleRate();
            this.recordStartTimeInMicros = (long)((double)this.recordStartTimeInMicros - latencyInMicros);
            try {
                AudioPart part = new AudioPart(this, this.writer.getFile(), this.recordStartTimeInMicros);
                part.onLoad();
                this.writer = this.newAudioWriter();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            this.project.getEditHistoryContainer().notifyEditHistoryListeners();
        }
    }

    public MixControls getMixerControls() {
        return this.mixerControls;
    }

    public Part createPart() {
        try {
            throw new Exception(" Attempt to create an AudiPart");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Icon getIcon() {
        return icon;
    }
}

