/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.midi.sysex;

import com.frinika.sequencer.midi.sysex.RolandSysexMacroAbstract;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;

abstract class E70SysexMacroAbstract
extends RolandSysexMacroAbstract {
    public static final byte MODEL_ID_E70 = 63;
    public static final int USER_PROGRAM_BASE_ADDR = 94298;
    public static final int USER_PROGRAM_SIZE = 270;

    E70SysexMacroAbstract() {
    }

    protected byte[] e70Set(int addr, byte[] data) {
        return this.rolandSysexSet((byte)63, addr, data);
    }

    protected byte[] e70Req(int addr, int size) {
        return this.rolandSysexReq((byte)63, addr, size);
    }

    protected byte[] e70UserProgramSet(int userProgram, int offset, byte[] data) {
        return this.e70Set(94298 + 270 * userProgram + offset, data);
    }

    protected byte[] e70UserProgramReq(int userProgram, int offset, int size) {
        return this.e70Req(94298 + 270 * userProgram + offset, size);
    }

    public static MidiMessage[] usrPrgChg(int pgmnr, int chn) throws InvalidMidiDataException {
        ShortMessage bankselectMSB = new ShortMessage();
        bankselectMSB.setMessage(176, chn, 0, 0);
        ShortMessage bankselectLSB = new ShortMessage();
        bankselectLSB.setMessage(176, chn, 32, 0);
        ShortMessage pgmChg = new ShortMessage();
        pgmChg.setMessage(192, chn, pgmnr, 0);
        return new MidiMessage[]{bankselectMSB, bankselectLSB, pgmChg};
    }
}

