/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.midi.groovepattern;

import com.frinika.global.FrinikaConfig;
import com.frinika.sequencer.midi.groovepattern.GroovePattern;
import com.frinika.sequencer.midi.groovepattern.GroovePatternFromSequence;
import com.frinika.sequencer.model.MidiPart;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovePatternManager {
    public static final String PRESETS_PACKAGE = "groovepatterns";
    public static final String[] PRESETS = new String[]{"test1"};
    private static GroovePatternManager instance;
    private static Map<String, GroovePattern> presetPatterns;
    private static Map<String, GroovePatternFromSequence> userPatterns;

    public static GroovePatternManager getInstance() {
        if (instance == null) {
            GroovePatternManager.initPresets();
            GroovePatternManager.loadUserPatterns();
            instance = new GroovePatternManager();
        }
        return instance;
    }

    private static void initPresets() {
        presetPatterns = new HashMap<String, GroovePattern>();
        for (int i = 0; i < PRESETS.length; ++i) {
            String name = PRESETS[i];
            InputStream res = ClassLoader.getSystemResourceAsStream("groovepatterns/" + name + ".mid");
            try {
                GroovePatternManager.loadPresetPattern(presetPatterns, name, res);
                continue;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private static void loadUserPatterns() {
        userPatterns = new HashMap<String, GroovePatternFromSequence>();
        File dir = FrinikaConfig.GROOVE_PATTERN_DIRECTORY;
        if (dir.exists()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                String name = file.getName();
                if (!name.endsWith(".mid")) continue;
                name = name.substring(0, name.length() - 4);
                try {
                    FileInputStream in = new FileInputStream(file);
                    GroovePatternManager.loadPresetPattern(userPatterns, name, in);
                    in.close();
                    continue;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    private static void loadPresetPattern(Map map, String name, InputStream in) throws IOException {
        GroovePatternFromSequence gp = new GroovePatternFromSequence();
        gp.importFromMidiFile(name, in);
        map.put(name, gp);
    }

    private static void addUserPattern(GroovePatternFromSequence gp) {
        userPatterns.put(gp.getName(), gp);
    }

    private static void removeUserPattern(GroovePatternFromSequence gp) {
        userPatterns.remove(gp.getName());
    }

    private static boolean hasUserPattern(String name) {
        return userPatterns != null && userPatterns.get(name) != null;
    }

    private static void storeUserPattern(GroovePatternFromSequence groovePattern) throws IOException {
        File dir = FrinikaConfig.GROOVE_PATTERN_DIRECTORY;
        dir.mkdir();
        groovePattern.saveAsMidiFile(GroovePatternManager.storageFile(groovePattern));
    }

    public static String normalizeName(String name) {
        return name.replace(' ', '_').replace('\t', '_').replace('.', '_').replace(':', '_').replace('/', '_').replace('\\', '_').replace('?', '_').replace('*', '_');
    }

    private GroovePatternManager() {
    }

    public Collection<GroovePattern> getGroovePatterns() {
        ArrayList<GroovePattern> l = new ArrayList<GroovePattern>();
        l.addAll(this.getPresetGroovePatterns());
        l.addAll(this.getUserGroovePatterns());
        return l;
    }

    public GroovePattern getGroovePattern(String name) {
        for (GroovePattern gp : this.getGroovePatterns()) {
            if (!gp.getName().equals(name)) continue;
            return gp;
        }
        return null;
    }

    public Collection<GroovePattern> getPresetGroovePatterns() {
        return presetPatterns.values();
    }

    public Collection<GroovePatternFromSequence> getUserGroovePatterns() {
        return userPatterns.values();
    }

    public GroovePatternFromSequence importUserGroovePattern(File midiFile) throws IOException {
        GroovePatternFromSequence gp = new GroovePatternFromSequence();
        gp.importFromMidiFile(midiFile);
        GroovePatternManager.ensureUniqueName(gp.getName());
        GroovePatternManager.addUserPattern(gp);
        GroovePatternManager.storeUserPattern(gp);
        return gp;
    }

    public GroovePatternFromSequence importUserGroovePattern(String name, MidiPart part) throws IOException {
        GroovePatternManager.ensureUniqueName(name);
        GroovePatternFromSequence gp = new GroovePatternFromSequence();
        gp.importFromMidiPart(name, part);
        GroovePatternManager.addUserPattern(gp);
        GroovePatternManager.storeUserPattern(gp);
        return gp;
    }

    public void removeUserGroovePattern(GroovePatternFromSequence gp) throws IOException {
        if (GroovePatternManager.hasUserPattern(gp.getName())) {
            GroovePatternManager.removeUserPattern(gp);
            File file = GroovePatternManager.storageFile(gp);
            if (!file.delete()) {
                throw new IOException("unable to delete file " + file.getAbsolutePath());
            }
        }
    }

    private static File storageFile(GroovePatternFromSequence gp) {
        return new File(FrinikaConfig.GROOVE_PATTERN_DIRECTORY, GroovePatternManager.normalizeName(gp.getName()) + ".mid");
    }

    private static void ensureUniqueName(String name) throws IOException {
        if (GroovePatternManager.hasUserPattern(name)) {
            throw new IOException("a groove pattern named '" + name + "' already exists");
        }
    }
}

