/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.midi.groovepattern;

import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.midi.groovepattern.GroovePattern;
import com.frinika.sequencer.midi.groovepattern.GroovePatternManager;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.NoteEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

public class GroovePatternFromSequence
implements GroovePattern {
    protected String name;
    protected Sequence sequence;
    protected long length;
    protected int lengthInBeats;
    protected int notesCount;

    public GroovePatternFromSequence() {
    }

    public GroovePatternFromSequence(String name, Sequence sequence) {
        this();
        this.setName(name);
        this.setSequence(sequence);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
        Track track = this.getTrack();
        this.notesCount = 0;
        long start = -1L;
        long end = -1L;
        int size = track.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                MidiEvent ev = track.get(i);
                MidiMessage msg = ev.getMessage();
                if (!(msg instanceof ShortMessage) || ((ShortMessage)msg).getCommand() != 144) continue;
                ++this.notesCount;
                if (start == -1L) {
                    start = ev.getTick();
                }
                end = ev.getTick();
            }
            int resolution = sequence.getResolution();
            long b1 = (start + (long)(resolution / 4)) / (long)resolution;
            long b2 = (end - (long)(resolution / 4)) / (long)resolution;
            this.lengthInBeats = (int)(b2 - b1 + 1L);
            this.length = this.lengthInBeats * resolution;
        } else {
            this.length = 0L;
        }
    }

    public long quantize(long tick, int quantizeResolution, float smudge, int[] velocityByRef) {
        int[] v2;
        long q2;
        long qDiff2;
        long t = tick % this.length;
        long diff = tick - t;
        long q = this.findNearest(t, velocityByRef);
        long qDiff = t - q;
        if (qDiff < 0L) {
            qDiff = -qDiff;
        }
        if (qDiff > (long)quantizeResolution) {
            return tick;
        }
        if (smudge != 0.0f && (qDiff2 = t - (q2 = this.findFurthest(t, quantizeResolution, v2 = new int[1]))) > qDiff) {
            long d = q2 - q;
            d = Math.round((float)d * smudge);
            q += d;
            int n = v2[0] - velocityByRef[0];
            velocityByRef[0] = velocityByRef[0] + Math.round((float)n * smudge);
        }
        return q + diff;
    }

    private long findNearest(long tick, int[] v) {
        boolean isNote;
        if (this.notesCount == 0) {
            return tick;
        }
        Track track = this.getTrack();
        int size = track.size();
        int shift = 4 * this.sequence.getResolution();
        long t = tick % this.length;
        t = tick + (long)shift;
        int i = 0;
        long nearest = -1L;
        v[0] = 100;
        long tt = t;
        do {
            MidiEvent ev = track.get(i++);
            tt = ev.getTick();
            MidiMessage msg = ev.getMessage();
            boolean bl = isNote = msg instanceof ShortMessage && ((ShortMessage)msg).getCommand() == 144;
            if (!isNote || tt >= t && tt - t >= t - nearest) continue;
            nearest = tt;
            v[0] = ((ShortMessage)msg).getData2();
        } while (i < size && (!isNote || tt < t));
        return nearest - (long)shift;
    }

    private long findFurthest(long tick, int q, int[] v) {
        MidiEvent ev;
        long tt;
        if (this.notesCount == 0) {
            return tick;
        }
        Track track = this.getTrack();
        int size = track.size();
        int shift = 4 * this.sequence.getResolution();
        long t = tick % this.length;
        t = tick + (long)shift;
        int i = 0;
        long furthest = t;
        v[0] = 100;
        int q2 = q / 2;
        while (i < size && (tt = (ev = track.get(i++)).getTick()) < t + (long)q2) {
            MidiMessage msg = ev.getMessage();
            if (!(msg instanceof ShortMessage) || ((ShortMessage)msg).getCommand() != 144) continue;
            long d = t - tt;
            if (d < 0L) {
                d = -d;
            }
            if (d > (long)q2 || GroovePatternFromSequence.abs(furthest - t) >= d) continue;
            furthest = tt;
            v[0] = ((ShortMessage)msg).getData2();
        }
        return furthest - (long)shift;
    }

    private static long abs(long a) {
        if (a < 0L) {
            return -a;
        }
        return a;
    }

    public void importFromMidiPart(String name, MidiPart part) throws IOException {
        this.sequence = null;
        this.name = GroovePatternManager.normalizeName(name);
        try {
            this.sequence = new Sequence(0.0f, part.getLane().getProject().getSequence().getResolution(), 1);
            GroovePatternFromSequence.normalize(part, this.sequence);
            this.setSequence(this.sequence);
        }
        catch (InvalidMidiDataException imde) {
            imde.printStackTrace();
            throw new IOException("unable to import MIDI part as groove pattern");
        }
    }

    public void importFromMidiFile(String name, InputStream in) throws IOException {
        this.sequence = null;
        this.name = GroovePatternManager.normalizeName(name);
        try {
            Sequence seq = MidiSystem.getSequence(in);
            if (seq == null) {
                throw new IOException("unable to load groove pattern " + name);
            }
            this.sequence = new Sequence(0.0f, seq.getResolution(), 1);
            GroovePatternFromSequence.normalize(seq, this.sequence);
            this.setSequence(this.sequence);
        }
        catch (InvalidMidiDataException imde) {
            imde.printStackTrace();
            throw new IOException("unable to load groove pattern " + name + " - " + imde.getMessage());
        }
    }

    public void importFromMidiFile(File file) throws IOException {
        String name = file.getName();
        int dot = name.lastIndexOf(46);
        if (dot != 1) {
            name = name.substring(0, dot);
        }
        FileInputStream in = new FileInputStream(file);
        this.importFromMidiFile(name, in);
        in.close();
    }

    public void saveAsMidiFile(File file) throws IOException {
        MidiSystem.write(this.sequence, 1, file);
    }

    public void openAsOwnProject() throws Exception {
        ProjectContainer newProject = new ProjectContainer(this.sequence);
        ProjectFrame newProjectFrame = new ProjectFrame(newProject);
    }

    static void normalize(MidiPart part, Sequence sequence) {
        int resolutionPart = part.getLane().getProject().getSequence().getResolution();
        int resolutionSeq = sequence.getResolution();
        Track track = sequence.getTracks()[0];
        boolean firstNote = true;
        long shift = 4 * resolutionPart;
        for (MultiEvent ev : part.getMultiEvents()) {
            if (!(ev instanceof NoteEvent)) continue;
            NoteEvent n = (NoteEvent)ev;
            long start = n.getStartTick();
            long end = n.getEndTick();
            int note = n.getNote();
            int vel = n.getVelocity();
            if (firstNote) {
                shift -= (start + (long)(resolutionPart / 4)) / (long)resolutionPart * (long)resolutionPart;
                firstNote = false;
            }
            start += shift;
            end += shift;
            if (resolutionPart != resolutionSeq) {
                start = GroovePatternFromSequence.translateResolution(start, resolutionPart, resolutionSeq);
                end = GroovePatternFromSequence.translateResolution(end, resolutionPart, resolutionSeq);
            }
            try {
                ShortMessage sm = new ShortMessage();
                sm.setMessage(144, 0, note, vel);
                MidiEvent event = new MidiEvent(sm, start);
                track.add(event);
                sm = new ShortMessage();
                sm.setMessage(128, 0, note, vel);
                event = new MidiEvent(sm, end);
                track.add(event);
            }
            catch (InvalidMidiDataException imde) {
                imde.printStackTrace();
            }
        }
    }

    static void normalize(Sequence seq, Sequence sequence) {
        int srcRes = seq.getResolution();
        int dstRes = sequence.getResolution();
        Track track = sequence.getTracks()[0];
        boolean firstNote = true;
        long shift = 4 * srcRes;
        Track[] srcTracks = seq.getTracks();
        for (int i = 0; i < srcTracks.length; ++i) {
            Track srcTrack = srcTracks[i];
            int size = srcTrack.size();
            for (int j = 0; j < size; ++j) {
                ShortMessage sh;
                int cmd;
                MidiEvent ev = srcTrack.get(j);
                MidiMessage msg = ev.getMessage();
                if (!(msg instanceof ShortMessage) || (cmd = (sh = (ShortMessage)msg).getCommand()) != 144 && cmd != 128) continue;
                int note = sh.getData1();
                int vel = sh.getData2();
                long start = ev.getTick();
                if (firstNote) {
                    shift -= (start + (long)(srcRes / 4)) / (long)srcRes * (long)srcRes;
                    firstNote = false;
                }
                start += shift;
                if (srcRes != dstRes) {
                    start = GroovePatternFromSequence.translateResolution(start, srcRes, dstRes);
                }
                try {
                    ShortMessage sm = new ShortMessage();
                    sm.setMessage(cmd, 0, note, vel);
                    MidiEvent event = new MidiEvent(sm, start);
                    track.add(event);
                    continue;
                }
                catch (InvalidMidiDataException imde) {
                    imde.printStackTrace();
                }
            }
        }
    }

    static long translateResolution(long tick, int srcRes, int destRes) {
        return Math.round((double)tick / (double)srcRes * (double)destRes);
    }

    public String toString() {
        return this.getName() + " [" + this.lengthInBeats + " beats, " + this.notesCount + " notes]";
    }

    public Track getTrack() {
        return this.sequence.getTracks()[0];
    }
}

