/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.midi;

import com.frinika.sequencer.midi.MidiMessageListener;
import java.util.Collection;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorReceiver
implements Receiver {
    protected Receiver chained;
    protected Collection<MidiMessageListener> listeners;
    private static boolean isLinux = System.getProperty("os.name").equals("Linux");

    public MonitorReceiver(Collection<MidiMessageListener> listeners, Receiver chained) {
        this.chained = chained;
        this.listeners = listeners;
    }

    @Override
    public void send(MidiMessage message, long timeStamp) {
        if (message.getStatus() >= 241) {
            return;
        }
        if (isLinux && message.getStatus() == 224) {
            ShortMessage mess = (ShortMessage)message;
            short low = (byte)mess.getData1();
            short high = (byte)mess.getData2();
            int channel = mess.getChannel();
            low = (byte)mess.getData1();
            high = (byte)mess.getData2();
            high = (short)(high + 64 & 0x7F);
            try {
                mess.setMessage(224, channel, low, high);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
        }
        this.chained.send(message, timeStamp);
        this.notifyListeners(message);
    }

    @Override
    public void close() {
        this.chained.close();
    }

    protected void notifyListeners(MidiMessage message) {
        for (MidiMessageListener l : this.listeners) {
            l.midiMessage(message);
        }
    }
}

