/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.midi;

import com.frinika.sequencer.MidiResource;
import com.frinika.sequencer.gui.mixer.MidiDeviceMixerPanel;
import com.frinika.sequencer.midi.MidiListProvider;
import com.frinika.sequencer.model.ControllerListProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidiOutDeviceWrapper
implements MidiDevice,
MidiListProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    transient ControllerListProvider controllerList;
    transient MidiDevice midiDevice;
    transient MidiDeviceMixerPanel gui;
    transient Receiver receiver = new Receiver(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void send(MidiMessage message, long timeStamp) {
            try {
                MidiOutDeviceWrapper.this.midiDevice.getReceiver().send(message, timeStamp);
                if (!(message instanceof ShortMessage)) return;
                ShortMessage shm = (ShortMessage)message;
                int channel = shm.getChannel();
                if (shm.getCommand() == 144) return;
                if (shm.getCommand() == 176) {
                    if (MidiOutDeviceWrapper.this.gui != null && shm.getData1() == 7) {
                        MidiOutDeviceWrapper.this.gui.mixerSlots[channel].setVolume(shm.getData2());
                        return;
                    } else {
                        if (MidiOutDeviceWrapper.this.gui == null || shm.getData1() != 10) return;
                        MidiOutDeviceWrapper.this.gui.mixerSlots[channel].setPan(shm.getData2());
                    }
                    return;
                }
                if (shm.getCommand() != 224) return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        public void close() {
            try {
                MidiOutDeviceWrapper.this.midiDevice.getReceiver().close();
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
            }
        }
    };

    public MidiOutDeviceWrapper(MidiDevice midiDevice) {
        this.midiDevice = midiDevice;
        this.controllerList = MidiResource.getDefaultControllerList();
    }

    @Override
    public Receiver getReceiver() throws MidiUnavailableException {
        return this.receiver;
    }

    @Override
    public List<Receiver> getReceivers() {
        ArrayList<Receiver> receivers = new ArrayList<Receiver>();
        receivers.add(this.receiver);
        for (Receiver recv : this.midiDevice.getReceivers()) {
            try {
                if (recv == this.midiDevice.getReceiver()) continue;
                receivers.add(recv);
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
            }
        }
        return receivers;
    }

    @Override
    public Transmitter getTransmitter() throws MidiUnavailableException {
        return this.midiDevice.getTransmitter();
    }

    @Override
    public List<Transmitter> getTransmitters() {
        return this.midiDevice.getTransmitters();
    }

    @Override
    public MidiDevice.Info getDeviceInfo() {
        return this.midiDevice.getDeviceInfo();
    }

    @Override
    public void open() throws MidiUnavailableException {
        this.midiDevice.open();
    }

    @Override
    public void close() {
        this.midiDevice.close();
    }

    @Override
    public boolean isOpen() {
        return this.midiDevice.isOpen();
    }

    @Override
    public long getMicrosecondPosition() {
        return this.midiDevice.getMicrosecondPosition();
    }

    @Override
    public int getMaxReceivers() {
        return this.midiDevice.getMaxReceivers();
    }

    @Override
    public int getMaxTransmitters() {
        return this.midiDevice.getMaxTransmitters();
    }

    @Override
    public ControllerListProvider getControllerList() {
        return this.controllerList;
    }
}

