/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.transport;

import com.frinika.localization.CurrentLocale;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.FrinikaSequencer;
import com.frinika.sequencer.gui.RecordingDialog;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class RecordAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private FrinikaSequencer sequencer;
    private ProjectFrame projectFrame;

    public RecordAction(ProjectFrame project) {
        super(CurrentLocale.getMessage("sequencer.project.record"));
        this.sequencer = project.getProjectContainer().getSequencer();
        this.projectFrame = project;
    }

    public void actionPerformed(ActionEvent e) {
        final JOptionPane recordingOptionPane = new JOptionPane(CurrentLocale.getMessage("sequencer.recording.takes"));
        final RecordingDialog recordingDialog = new RecordingDialog(recordingOptionPane, this.sequencer);
        recordingOptionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String prop = evt.getPropertyName();
                if (recordingDialog.isVisible() && evt.getSource() == recordingOptionPane && prop.equals("value")) {
                    int[] deployableTakes = recordingDialog.getDeployableTakes();
                    if (deployableTakes.length > 0) {
                        RecordAction.this.projectFrame.getProjectContainer().getEditHistoryContainer().mark(CurrentLocale.getMessage("recording"));
                        RecordAction.this.sequencer.deployTake(deployableTakes);
                        RecordAction.this.projectFrame.getProjectContainer().getEditHistoryContainer().notifyEditHistoryListeners();
                    }
                    RecordAction.this.sequencer.stop();
                }
            }
        });
        this.sequencer.startRecording();
    }
}

