/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.tracker;

import com.frinika.localization.CurrentLocale;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.FrinikaSequence;
import com.frinika.sequencer.FrinikaSequencer;
import com.frinika.sequencer.model.ChannelEvent;
import com.frinika.sequencer.model.ControllerEvent;
import com.frinika.sequencer.model.EditHistoryAction;
import com.frinika.sequencer.model.EditHistoryListener;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MovePartEditAction;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.MultiEventChangeRecorder;
import com.frinika.sequencer.model.NoteEvent;
import com.frinika.sequencer.model.PitchBendEvent;
import com.frinika.sequencer.model.SysexEvent;
import com.frinika.sequencer.model.util.TimeUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackerTableModel
extends AbstractTableModel
implements EditHistoryListener {
    private static final long serialVersionUID = 1L;
    private static final String[] ColumnNames = new String[]{"Time", "Note", "Vel", "Len"};
    static final int COLUMN_TIME = 0;
    static final int COLUMN_CHANNEL = -1;
    static final int COLUMN_NOTEORCC = 1;
    static final int COLUMN_VELORVAL = 2;
    static final int COLUMN_LEN = 3;
    static final int COLUMNS = ColumnNames.length;
    double ticksPerRow;
    FrinikaSequence sequence;
    FrinikaSequencer sequencer;
    MidiPart midiPart;
    int columnCount = 1;
    long startTick = 0L;
    int beatCount = 0;
    int editVelocity = 100;
    double editDuration = 1.0;
    TimeUtils timeUtils;
    ProjectFrame frame;
    private int lastRow = -1;
    private Collection<MultiEvent> lastRowEvents;
    private int lastCol = -1;
    private MultiEvent lastCellEvent;

    public TrackerTableModel(ProjectFrame frame) {
        this.frame = frame;
        ProjectContainer project = frame.getProjectContainer();
        this.sequence = project.getSequence();
        this.ticksPerRow = (double)this.sequence.getResolution() / 4.0;
        this.sequencer = project.getSequencer();
        this.timeUtils = new TimeUtils(project);
        project.getEditHistoryContainer().addEditHistoryListener(this);
    }

    public void setMidiPart(MidiPart part) {
        if (part == null) {
            this.startTick = 0L;
            this.beatCount = 0;
            this.midiPart = null;
        } else {
            this.midiPart = part;
            this.startTick = part.getStartTick() - part.getStartTick() % (long)this.sequence.getResolution();
            this.beatCount = (int)((part.getEndTick() - this.startTick) / (long)this.sequence.getResolution());
            if ((part.getEndTick() - this.startTick) % (long)this.sequence.getResolution() > 0L) {
                ++this.beatCount;
            }
        }
        this.fireTableDataChanged();
    }

    public void setStartBeat(int startBeat) {
        this.startTick = startBeat * this.sequence.getResolution();
        this.fireTableDataChanged();
    }

    public void setBeatCount(int beatCount) {
        this.beatCount = beatCount;
        this.fireTableDataChanged();
    }

    public int getTicksPerRow() {
        return (int)((double)this.sequence.getResolution() / this.ticksPerRow);
    }

    public void setRowsPerBeat(int rowsPerBeat) {
        this.ticksPerRow = (double)this.sequence.getResolution() / (double)rowsPerBeat;
        this.fireTableDataChanged();
    }

    public int getEditVelocity() {
        return this.editVelocity;
    }

    public void setEditVelocity(int editVelocity) {
        this.editVelocity = editVelocity;
    }

    public double getEditDuration() {
        return this.editDuration;
    }

    public void setEditDuration(double editDuration) {
        this.editDuration = editDuration;
    }

    @Override
    public int getRowCount() {
        return (int)((double)(this.beatCount * this.sequence.getResolution()) / this.ticksPerRow);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Integer.class;
        }
        switch ((columnIndex - 1) % COLUMNS) {
            case 0: {
                return Double.class;
            }
            case 3: {
                return Double.class;
            }
        }
        return Integer.class;
    }

    @Override
    public String getColumnName(int column) {
        if (column != 0) {
            return ColumnNames[(column - 1) % COLUMNS];
        }
        return "Bar.Beat";
    }

    @Override
    public int getColumnCount() {
        return this.columnCount * COLUMNS + 1;
    }

    public final long getTickForRow(int row) {
        return (long)((double)row * this.ticksPerRow + (double)this.startTick);
    }

    public final int getRowForTick(long tick) {
        return (int)Math.round((double)(tick - this.startTick) / this.ticksPerRow);
    }

    public final int getPlayingRow() {
        return this.getRowForTick(this.sequencer.getTickPosition());
    }

    public final Collection<MultiEvent> getRowEvents(int row) {
        if (row == this.lastRow) {
            return this.lastRowEvents;
        }
        long rowTick = this.getTickForRow(row);
        SortedSet<MultiEvent> tmpRowEvents = this.midiPart.getMultiEventSubset((long)((double)rowTick - this.ticksPerRow / 2.0), (long)((double)rowTick + this.ticksPerRow / 2.0));
        Vector<MultiEvent> rowEvents = new Vector<MultiEvent>();
        for (MultiEvent multiEvent : tmpRowEvents) {
            if (multiEvent.getTrackerColumn() != null) {
                int columnIndex = multiEvent.getTrackerColumn();
                while (columnIndex > rowEvents.size()) {
                    rowEvents.add(null);
                }
                if (columnIndex < rowEvents.size() && rowEvents.get(columnIndex) == null) {
                    rowEvents.remove(columnIndex);
                }
                rowEvents.add(columnIndex, multiEvent);
                continue;
            }
            rowEvents.add(multiEvent);
        }
        if (rowEvents.size() + 1 > this.columnCount) {
            this.columnCount = rowEvents.size() + 1;
            this.fireTableStructureChanged();
        }
        this.lastRow = row;
        this.lastRowEvents = rowEvents;
        return rowEvents;
    }

    public final MultiEvent getCellEvent(int row, int col) {
        int c;
        if (row == this.lastRow && col == this.lastCol) {
            return this.lastCellEvent;
        }
        Collection<MultiEvent> rowEvents = this.getRowEvents(row);
        Iterator<MultiEvent> it = rowEvents.iterator();
        MultiEvent event = null;
        for (c = -1; c < col && it.hasNext(); ++c) {
            event = it.next();
        }
        this.lastCol = col;
        if (c == col) {
            if (event != null && event.getTrackerColumn() == null) {
                event.setTrackerColumn(col);
            }
            this.lastCellEvent = event;
            return event;
        }
        this.lastCellEvent = null;
        return null;
    }

    public final int tableColumnToTrackerColumn(int tableColumn) {
        return (tableColumn - 1) / COLUMNS;
    }

    public MultiEvent getMultiEventAt(int row, int column) {
        return this.getCellEvent(row, this.tableColumnToTrackerColumn(column));
    }

    @Override
    public Object getValueAt(int row, int columnIndex) {
        if (columnIndex == 0) {
            long tick = this.getTickForRow(row);
            double beat = (double)tick / (double)this.sequence.getResolution();
            if (beat % 1.0 == 0.0) {
                return this.timeUtils.tickToBarBeat(tick);
            }
            return "";
        }
        int col = this.tableColumnToTrackerColumn(columnIndex);
        int eventCol = (columnIndex - 1) % COLUMNS;
        MultiEvent me = this.getCellEvent(row, col);
        if (me != null) {
            if (eventCol == 0) {
                long relativeTick = me.getStartTick() - this.startTick;
                long rowTick = (long)((double)row * this.ticksPerRow);
                return (double)(relativeTick - rowTick) / this.ticksPerRow;
            }
            if (me instanceof ChannelEvent) {
                ChannelEvent event = (ChannelEvent)me;
                switch (eventCol) {
                    case -1: {
                        return new Integer(event.getChannel());
                    }
                    case 1: {
                        if (event instanceof NoteEvent) {
                            return ((NoteEvent)event).getNoteName();
                        }
                        if (event instanceof ControllerEvent) {
                            return "CC" + ((ControllerEvent)event).getControlNumber();
                        }
                        if (event instanceof PitchBendEvent) {
                            return "PB";
                        }
                        return null;
                    }
                    case 2: {
                        if (event instanceof NoteEvent) {
                            return ((NoteEvent)event).getVelocity();
                        }
                        if (event instanceof ControllerEvent) {
                            return ((ControllerEvent)event).getValue();
                        }
                        if (event instanceof PitchBendEvent) {
                            return ((PitchBendEvent)event).getValue() >> 7;
                        }
                        return null;
                    }
                    case 3: {
                        if (!(event instanceof NoteEvent)) break;
                        return (double)((NoteEvent)event).getDuration() / this.ticksPerRow;
                    }
                }
                return null;
            }
            if (me instanceof SysexEvent) {
                switch (eventCol) {
                    case 1: {
                        return "SYX";
                    }
                }
                return null;
            }
            return null;
        }
        return null;
    }

    @Override
    public void setValueAt(final Object value, int row, int columnIndex) {
        int col = this.tableColumnToTrackerColumn(columnIndex);
        int eventCol = (columnIndex - 1) % COLUMNS;
        MultiEvent me = this.getCellEvent(row, col);
        if (me == null) {
            if (eventCol == 1) {
                Integer val = (Integer)value;
                if (val > 0) {
                    this.midiPart.getEditHistoryContainer().mark("new note");
                    NoteEvent event = new NoteEvent(this.midiPart, this.getTickForRow(row), (int)((Integer)value), this.editVelocity, 1, (long)(this.ticksPerRow * this.getEditDuration()));
                    this.addMultiEvent(event, col);
                    this.midiPart.getEditHistoryContainer().notifyEditHistoryListeners();
                } else if (val >= -127) {
                    this.midiPart.getEditHistoryContainer().mark("new control change");
                    ControllerEvent event = new ControllerEvent(this.midiPart, this.getTickForRow(row), -((Integer)value).intValue(), 0);
                    this.addMultiEvent(event, col);
                    this.midiPart.getEditHistoryContainer().notifyEditHistoryListeners();
                } else if (val == -128) {
                    this.midiPart.getEditHistoryContainer().mark("new pitch bend");
                    PitchBendEvent event = new PitchBendEvent(this.midiPart, this.getTickForRow(row), 8192);
                    this.addMultiEvent(event, col);
                    this.midiPart.getEditHistoryContainer().notifyEditHistoryListeners();
                } else if (val == -129) {
                    SysexEvent event = new SysexEvent(this.midiPart, this.getTickForRow(row));
                    event.showEditorGUI(this.frame);
                    if (event.isSuccessfullyParsed()) {
                        this.midiPart.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.sysex.new_sysex"));
                        this.addMultiEvent(event, col);
                        this.midiPart.getEditHistoryContainer().notifyEditHistoryListeners();
                    }
                }
            }
            this.lastRow = -1;
            this.fireTableRowsUpdated(row, row);
        } else {
            try {
                switch (eventCol) {
                    case 0: {
                        final long newTick = (long)((double)this.getTickForRow(row) + (Double)value * this.ticksPerRow);
                        new MultiEventChangeRecorder("move event", me){

                            public void doChange(MultiEvent me) {
                                me.setStartTick(newTick);
                            }
                        };
                        int newRow = this.getRowForTick(newTick);
                        if (newRow == row) break;
                        this.lastRow = -1;
                        this.fireTableRowsUpdated(row, row);
                        if (newRow < 0 || newRow >= this.getRowCount()) break;
                        this.fireTableRowsUpdated(newRow, newRow);
                        break;
                    }
                    case 1: {
                        if (value.equals(-2101)) {
                            if (me instanceof NoteEvent) {
                                this.midiPart.getEditHistoryContainer().mark("delete note");
                            } else if (me instanceof ControllerEvent) {
                                this.midiPart.getEditHistoryContainer().mark("delete control change");
                            } else if (me instanceof PitchBendEvent) {
                                this.midiPart.getEditHistoryContainer().mark("delete pitch bend");
                            } else if (me instanceof SysexEvent) {
                                this.midiPart.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.sysex.delete_sysex"));
                            } else {
                                this.midiPart.getEditHistoryContainer().mark("delete event");
                            }
                            this.midiPart.remove(me);
                            this.midiPart.getEditHistoryContainer().notifyEditHistoryListeners();
                            break;
                        }
                        if (me instanceof NoteEvent) {
                            new MultiEventChangeRecorder("change note", me){

                                public void doChange(MultiEvent me) {
                                    ((NoteEvent)me).setNote((Integer)value);
                                }
                            };
                            break;
                        }
                        if (!(me instanceof SysexEvent)) break;
                        ((SysexEvent)me).showEditorGUI(this.frame);
                        break;
                    }
                    case 2: {
                        if (me instanceof NoteEvent) {
                            new MultiEventChangeRecorder("change velocity", me){

                                public void doChange(MultiEvent me) {
                                    ((NoteEvent)me).setVelocity((Integer)value);
                                }
                            };
                            break;
                        }
                        if (me instanceof ControllerEvent) {
                            new MultiEventChangeRecorder("change controller value", me){

                                public void doChange(MultiEvent me) {
                                    ((ControllerEvent)me).setValue((Integer)value);
                                }
                            };
                            break;
                        }
                        if (!(me instanceof PitchBendEvent)) break;
                        new MultiEventChangeRecorder("change pitchbend value", me){

                            public void doChange(MultiEvent me) {
                                ((PitchBendEvent)me).setValue((Integer)value << 7);
                            }
                        };
                        break;
                    }
                    case 3: {
                        if (!(me instanceof NoteEvent)) break;
                        new MultiEventChangeRecorder("change duration", me){

                            public void doChange(MultiEvent me) {
                                ((NoteEvent)me).setDuration((long)((Double)value * TrackerTableModel.this.ticksPerRow));
                            }
                        };
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println(value + " " + row);
    }

    private void addMultiEvent(MultiEvent event, int column) {
        event.setTrackerColumn(column);
        this.midiPart.add(event);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    @Override
    public void fireSequenceDataChanged(EditHistoryAction[] edithistoryActions) {
        if (edithistoryActions.length > 0 && edithistoryActions[0] instanceof MovePartEditAction && ((MovePartEditAction)edithistoryActions[0]).getPart() == this.midiPart) {
            this.setMidiPart((MidiPart)((MovePartEditAction)edithistoryActions[0]).getPart());
        } else {
            this.fireTableRowsUpdated(0, this.getRowCount());
        }
    }

    public void dispose() {
        this.midiPart.getEditHistoryContainer().removeEditHistoryListener(this);
    }
}

