/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.pianoroll;

import com.frinika.localization.CurrentLocale;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.FrinikaSequence;
import com.frinika.sequencer.SwingSongPositionListenerWrapper;
import com.frinika.sequencer.gui.ColorScheme;
import com.frinika.sequencer.gui.DragViewTool;
import com.frinika.sequencer.gui.EraseTool;
import com.frinika.sequencer.gui.Item;
import com.frinika.sequencer.gui.ItemScrollPane;
import com.frinika.sequencer.gui.Layout;
import com.frinika.sequencer.gui.MyCursors;
import com.frinika.sequencer.gui.RectZoomTool;
import com.frinika.sequencer.gui.SelectTool;
import com.frinika.sequencer.gui.WriteTool;
import com.frinika.sequencer.gui.pianoroll.AudioFeedBack;
import com.frinika.sequencer.gui.pianoroll.DragEventListener;
import com.frinika.sequencer.gui.pianoroll.ItemPanelMultiEventListener;
import com.frinika.sequencer.gui.pianoroll.ItemPanelPartListener;
import com.frinika.sequencer.gui.pianoroll.PianoRollPanelAdapter;
import com.frinika.sequencer.gui.pianoroll.WarpToPartLeftAction;
import com.frinika.sequencer.gui.selection.DragList;
import com.frinika.sequencer.model.EditHistoryAction;
import com.frinika.sequencer.model.EditHistoryContainer;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.NoteEvent;
import com.frinika.sequencer.model.Part;
import com.frinika.sequencer.model.timesignature.TimeSignatureList;
import com.frinika.sequencer.model.util.EventFilter;
import com.frinika.sequencer.model.util.EventsInPartsIterator;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.Vector;

public class PianoRoll
extends PianoRollPanelAdapter {
    private int noteItemHeight;
    int pitchTop = 128;
    int yScreenBot;
    int velocity = 100;
    int channel = 1;
    private static final long serialVersionUID = 1L;
    private static final Color selCol = new Color(127, 127, 127, 200);
    private static final Color noteCol = Color.RED;
    private static final Color dragCol = Color.BLACK;
    Iterable<MultiEvent> notesOnScreen;
    Iterable<MultiEvent> notesInFocus;
    boolean pasteing = false;
    EditHistoryContainer editHistory;
    private ItemPanelMultiEventListener multiEventListener;
    private ItemPanelPartListener partListener;
    private NoteEvent newNote;
    AudioFeedBack audioFeedBack;
    Point writeAtPoint;
    private boolean drumWriteMode = false;
    final Rectangle rectTmp = new Rectangle();
    final int[] xp = new int[4];
    final int[] yp = new int[4];
    final Polygon drumShape = new Polygon(this.xp, this.yp, 4);

    public PianoRoll(ProjectFrame frame, ItemScrollPane scroller) {
        super(frame, scroller, true, true);
        final ProjectContainer project = frame.getProjectContainer();
        this.notesOnScreen = new Iterable<MultiEvent>(){

            @Override
            public Iterator<MultiEvent> iterator() {
                return new EventsInPartsIterator(project.getPartSelection().getSelected(), (EventFilter)PianoRoll.this);
            }
        };
        this.notesInFocus = new Iterable<MultiEvent>(){

            @Override
            public Iterator<MultiEvent> iterator() {
                Part focus = (Part)project.getPartSelection().getFocus();
                if (focus == null) {
                    return null;
                }
                return new EventsInPartsIterator((Part)project.getPartSelection().getFocus(), (EventFilter)PianoRoll.this);
            }
        };
        this.audioFeedBack = new AudioFeedBack(project);
        this.sequencer = project.getSequencer();
        this.multiEventListener = new ItemPanelMultiEventListener(this);
        this.partListener = new ItemPanelPartListener(this);
        project.getMultiEventSelection().addSelectionListener(this.multiEventListener);
        project.getPartSelection().addSelectionListener(this.partListener);
        this.sequencer.addSongPositionListener(new SwingSongPositionListenerWrapper(this));
        FrinikaSequence seq = (FrinikaSequence)this.sequencer.getSequence();
        this.editHistory = project.getEditHistoryContainer();
        this.editHistory.addEditHistoryListener(this);
        project.getDragList().addDragEventListener(new DragEventListener(){

            public void update() {
                PianoRoll.this.repaintItems();
            }
        });
        this.ticksPerBeat = seq.getResolution();
        if (project.getPianoRollSnapQuantization() == 0.0) {
            project.setPianoRollSnapQuantization(this.ticksPerBeat);
        }
        this.setLayout(null);
        this.setBackground(Color.WHITE);
        this.repaintItems();
        this.addComponentListener(this);
        this.makeTools();
        this.enableEvents(16L);
        this.setFocusable(true);
    }

    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            this.grabFocus();
        }
        super.processMouseEvent(e);
    }

    public void dispose() {
        this.project.getMultiEventSelection().removeSelectionListener(this.multiEventListener);
        this.project.getPartSelection().removeSelectionListener(this.partListener);
        this.editHistory.removeEditHistoryListener(this);
    }

    public void dragTo(Point p) {
        long tick;
        int dxDragged = p.x - this.xAnchor;
        int dyDragged = p.y - this.yAnchor;
        NoteEvent dddNote = null;
        long dtick = this.screenToTickRel(this.xAnchor, dxDragged, this.project.isPianoRollSnapQuantized());
        int dpitch = 0;
        if (this.dragMode == 1) {
            dpitch = -dyDragged / this.noteItemHeight;
        }
        if (dtick == 0L && dpitch == 0 && !this.altIsDown) {
            return;
        }
        if (this.dragArmed) {
            this.startDrag();
        }
        this.dragArmed = false;
        DragList dragList = this.project.getDragList();
        if (dragList.isEmpty()) {
            return;
        }
        if (this.altIsDown && this.project.isPianoRollSnapQuantized()) {
            long newTick;
            long screenPos;
            long refTick;
            dddNote = (NoteEvent)dragList.get(0);
            if (this.dragMode != 2) {
                refTick = dddNote.getStartTick();
                screenPos = (int)this.userToScreen(refTick);
                newTick = this.screenToTickAbs((int)(screenPos + (long)dxDragged), true);
                dtick = newTick - refTick;
            } else {
                refTick = dddNote.getEndTick();
                screenPos = (int)this.userToScreen(refTick);
                newTick = this.screenToTickAbs((int)(screenPos + (long)dxDragged), true);
                dtick = newTick - refTick;
            }
            if (dtick == 0L) {
                return;
            }
        }
        if (dpitch != 0) {
            int pitlim = dpitch > 0 ? 0 : 127;
            for (Item it : dragList) {
                NoteEvent ev = (NoteEvent)it;
                int pitch = ev.getNote() + dpitch;
                if (dpitch > 0) {
                    pitlim = Math.max(pitch, pitlim);
                    continue;
                }
                pitlim = Math.min(pitch, pitlim);
            }
            if (dpitch > 0 && pitlim > 127) {
                dpitch -= pitlim - 127;
            } else if (dpitch < 0 && pitlim < 0) {
                dpitch -= pitlim;
            }
        }
        long dt = 0L;
        for (Item it : dragList) {
            NoteEvent ev = (NoteEvent)it;
            switch (this.dragMode) {
                case 1: {
                    tick = ev.getStartTick() + dtick;
                    int pitch = ev.getNote() + dpitch;
                    dt = Math.min(dt, tick);
                    ev.setStartTick(tick);
                    ev.setNote(pitch);
                    break;
                }
                case 2: {
                    long dur = ev.getDuration() + dtick;
                    dur = Math.max(1L, dur);
                    ev.setDuration(dur);
                    break;
                }
                case 3: {
                    long dur = ev.getDuration() - dtick;
                    long st = ev.getStartTick() + dtick;
                    dur = Math.max(1L, dur);
                    ev.setDuration(dur);
                    ev.setStartTick(st);
                    break;
                }
                default: {
                    System.err.println(" unknown dragmode " + this.dragMode);
                }
            }
            if (dpitch == 0) continue;
            this.feedBack(ev);
        }
        if (dt != 0L) {
            for (Item it : dragList) {
                NoteEvent ev = (NoteEvent)it;
                tick = ev.getStartTick() - dt;
                ev.setStartTick(tick);
            }
        }
        this.project.getDragList().notifyDragEventListeners();
        this.project.getDragList().notifyFeedbackItemListeners();
        this.xAnchor += (int)((double)dtick * this.userToScreen);
        this.yAnchor -= dpitch * this.noteItemHeight;
    }

    public void clientClearSelection() {
        this.project.getMultiEventSelection().clearSelection();
    }

    public void startDrag() {
        this.project.getDragList().startDrag(this.dragItem);
    }

    public synchronized void selectInRect(Rectangle rect, boolean shift) {
        Vector<MultiEvent> addTmp = new Vector<MultiEvent>();
        Vector<MultiEvent> delTmp = new Vector<MultiEvent>();
        Part focusPart = (Part)this.project.getPartSelection().getFocus();
        if (!(focusPart instanceof MidiPart)) {
            return;
        }
        Iterable<MultiEvent> list = focusPart != null ? ((MidiPart)focusPart).getMultiEvents() : this.notesOnScreen;
        for (MultiEvent note : list) {
            if (!(note instanceof NoteEvent) || !rect.intersects(this.getItemBounds((NoteEvent)note))) continue;
            if (shift) {
                if (note.isSelected()) {
                    delTmp.add(note);
                    continue;
                }
                addTmp.add(note);
                continue;
            }
            addTmp.add(note);
        }
        this.project.getMultiEventSelection().removeSelected(delTmp);
        this.project.getMultiEventSelection().addSelected(addTmp);
        this.project.getMultiEventSelection().notifyListeners();
    }

    protected void writeReleasedAt(Point p) {
        if (this.newNote == null) {
            return;
        }
        this.newNote.getPart().add(this.newNote);
        this.project.getMultiEventSelection().setSelected(this.newNote);
        this.project.getEditHistoryContainer().notifyEditHistoryListeners();
        this.project.getMultiEventSelection().notifyListeners();
        this.newNote = null;
        this.writeAtPoint = null;
    }

    public synchronized void writeDraggedAt(Point p) {
        if (this.newNote == null) {
            return;
        }
        long tick = this.screenToTickAbs(p.x, true);
        long tick1 = this.newNote.getStartTick();
        long tick2 = tick1 + this.newNote.getDuration();
        int pitch = this.screenToPitch(p.y);
        boolean doit = false;
        if (this.drumWriteMode) {
            if (tick != tick1) {
                if (this.writeAtPoint != null) {
                    p.y = this.writeAtPoint.y;
                }
                this.writeReleasedAt(p);
                this.writePressedAt(p);
                doit = true;
            }
        } else {
            if (tick > tick2) {
                this.newNote.setDuration(tick - tick1);
                doit = true;
            } else if (tick < tick2 && tick > tick1) {
                this.newNote.setDuration(tick - tick1);
                doit = true;
            }
            if (pitch != this.newNote.getNote() && pitch >= 0 && pitch < 128) {
                doit = true;
                this.newNote.setNote(pitch);
                this.feedBack(this.newNote);
            }
            this.project.getDragList().notifyFeedbackItemListeners(this.newNote);
        }
        if (doit) {
            this.repaintItems();
        }
    }

    protected synchronized void writePressedAt(Point p) {
        Part focusPart = (Part)this.project.getPartSelection().getFocus();
        if (focusPart == null || !(focusPart instanceof MidiPart)) {
            System.out.println(" Please slectect a part ");
            return;
        }
        if (this.writeAtPoint == null) {
            this.writeAtPoint = p;
        }
        long tick = this.screenToTickAbs(p.x, true);
        int pitch = this.screenToPitch(p.y);
        assert (pitch > 0);
        assert (pitch < 128);
        this.project.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.pianoroll.add_note"));
        if (this.drumWriteMode) {
            this.newNote = new NoteEvent((MidiPart)focusPart, tick, pitch, this.velocity, this.channel, 0L);
        } else {
            long quant = (long)this.project.getPianoRollSnapQuantization();
            if (quant <= 0L) {
                quant = this.project.getTicksPerBeat();
            }
            this.newNote = new NoteEvent((MidiPart)focusPart, tick, pitch, this.velocity, this.channel, quant);
        }
        this.feedBack(this.newNote);
        this.project.getDragList().notifyFeedbackItemListeners(this.newNote);
        this.repaintItems();
    }

    private int screenToPitch(int y) {
        return this.pitchTop - y / this.noteItemHeight;
    }

    public Item itemAt(Point p) {
        MultiEvent at = null;
        for (MultiEvent note : this.notesOnScreen) {
            if (!this.getItemBounds(note).contains(p)) continue;
            if (note.isSelected()) {
                return note;
            }
            if (at != null) continue;
            at = note;
        }
        return at;
    }

    int pitchToScreen(int pitch) {
        return (this.pitchTop - pitch) * this.noteItemHeight;
    }

    public void fireSequenceDataChanged(EditHistoryAction[] edithistoryActions) {
        this.repaintItems();
    }

    private Color alphaColor(Color c, float alpha) {
        float[] rgb = c.getRGBComponents(new float[4]);
        return new Color(rgb[0], rgb[1], rgb[2], alpha);
    }

    private Color alphaColor(Color c, int velocity) {
        return this.alphaColor(c, (float)velocity * 0.007874016f);
    }

    private Color alphaColor(Color c, MultiEvent note) {
        return this.alphaColor(c, ((NoteEvent)note).getVelocity());
    }

    public synchronized void paintImageImpl(Rectangle visibleRect, Graphics2D g) {
        Shape shape;
        boolean drawBeat;
        if (g == null) {
            return;
        }
        this.noteItemHeight = Layout.getNoteItemHeight();
        this.yScreenBot = this.pitchTop * this.noteItemHeight;
        Part focusPart = (Part)this.project.getPartSelection().getFocus();
        int w = visibleRect.width;
        int x = visibleRect.x;
        int y = visibleRect.y;
        int h = visibleRect.height;
        int yBot = this.yScreenBot;
        g.setColor(Color.lightGray);
        int p1 = this.screenToPitch(y);
        int y1 = this.pitchToScreen(p1);
        if (y1 <= y - this.noteItemHeight) {
            y1 = this.pitchToScreen(--p1);
        }
        assert (y1 > y - this.noteItemHeight);
        Rectangle frect = new Rectangle(visibleRect);
        if (focusPart != null) {
            g.fill(frect);
            g.setColor(ColorScheme.pianaoRollInvalid);
            int fl = (int)((double)focusPart.getStartTick() * this.userToScreen);
            int fr = (int)((double)focusPart.getEndTick() * this.userToScreen);
            frect.x = fl;
            frect.width = fr - fl;
            frect = frect.intersection(visibleRect);
        }
        Color blackNoteStripColor = new Color(200, 200, 240);
        while (y1 < y + h) {
            boolean drawLine;
            int i = this.noteItemHeight;
            boolean bl = drawLine = y1 >= y;
            if (!drawLine) {
                i -= y - y1;
                y1 = y;
            }
            switch (p1 % 12) {
                case 0: 
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 11: {
                    g.setColor(Color.WHITE);
                    break;
                }
                default: {
                    g.setColor(blackNoteStripColor);
                }
            }
            g.fill(new Rectangle(frect.x, y1, frect.width, this.noteItemHeight));
            if (drawLine) {
                Color cc;
                if (p1 % 12 == 11) {
                    cc = Color.red;
                    g.setXORMode(cc);
                    g.drawLine(x, y1, x + w, y1);
                } else if (p1 % 12 == 4) {
                    cc = Color.gray;
                    g.setXORMode(cc);
                    g.drawLine(x, y1, x + w, y1);
                }
            }
            g.setPaintMode();
            y1 = this.pitchToScreen(--p1);
        }
        int ticksPerBeat = this.project.getSequence().getResolution();
        double beat1 = this.screenToTickAbs(x, true) / (long)ticksPerBeat;
        double beat2 = this.screenToTickAbs(x + w, true) / (long)ticksPerBeat;
        double step = this.project.getPianoRollSnapQuantization() / (double)ticksPerBeat;
        TimeSignatureList.QStepIterator iter = this.project.getTimeSignatureList().createQStepIterator(beat1, beat2, step);
        boolean drawSub = (int)this.userToScreen((long)(step * (double)ticksPerBeat)) > 5;
        boolean bl = drawBeat = (int)this.userToScreen(ticksPerBeat) > 5;
        while (iter.hasNext()) {
            iter.next();
            double beat = iter.getBeat();
            boolean isBar = iter.isBar();
            if (isBar) {
                g.setColor(ColorScheme.partViewLinesBar);
            } else {
                if (!drawBeat) continue;
                if (Math.abs((beat + 1.0E-7) % 1.0) < 2.0E-7) {
                    g.setColor(ColorScheme.partViewLinesBeat);
                } else {
                    if (!drawSub) continue;
                    g.setColor(ColorScheme.partViewLinesSubBeat);
                }
            }
            long tick = (long)(beat * (double)ticksPerBeat);
            int x1 = (int)this.userToScreen(tick);
            g.drawLine(x1, y, x1, y + h);
        }
        if (!(focusPart instanceof MidiPart)) {
            return;
        }
        DragList dragList = this.project.getDragList();
        for (MultiEvent note : this.notesOnScreen) {
            if (focusPart != null && note.getPart() == focusPart) continue;
            Rectangle noteRect = this.getItemBounds(note);
            if (visibleRect != null && !visibleRect.intersects((Rectangle2D)noteRect)) continue;
            shape = this.getItemShape(note);
            if (note.isZombie()) continue;
            if (note.isSelected()) {
                if (!dragList.isEmpty()) continue;
                g.setColor(ColorScheme.selectedColor);
                g.fill(shape);
                continue;
            }
            MidiLane myLane = (MidiLane)note.getPart().getLane();
            if (myLane == null) {
                g.setColor(Color.BLACK);
            } else {
                g.setColor(note.getPart().getColor());
            }
            g.fill(shape);
        }
        if (focusPart != null) {
            for (MultiEvent note : this.notesInFocus) {
                assert (note instanceof NoteEvent);
                Rectangle noteRect = this.getItemBounds(note);
                if (visibleRect != null && !visibleRect.intersects(noteRect)) continue;
                shape = this.getItemShape(note);
                if (note.isSelected()) {
                    if (dragList.isEmpty()) {
                        g.setColor(selCol);
                        g.fill(shape);
                    }
                } else if (!note.isZombie()) {
                    MidiLane myLane = (MidiLane)note.getPart().getLane();
                    if (myLane == null) {
                        g.setColor(Color.BLACK);
                        g.fill(shape);
                    } else {
                        Color col = note.getPart().getColor();
                        g.setColor(this.alphaColor(col, note));
                        g.fill(shape);
                        g.setColor(col);
                        if (!((NoteEvent)note).isDrumHit()) {
                            Rectangle noteRect2 = new Rectangle();
                            noteRect2.width = noteRect.width - 2;
                            noteRect2.height = noteRect.height - 2;
                            noteRect2.x = noteRect.x + 1;
                            noteRect2.y = noteRect.y + 1;
                            g.draw(noteRect2);
                        }
                    }
                }
                g.setColor(Color.BLACK);
                g.draw(shape);
            }
        }
        if (!dragList.isEmpty()) {
            for (Item it : dragList) {
                NoteEvent note = (NoteEvent)it;
                Rectangle noteRect = this.getItemBounds(note);
                if (visibleRect != null && !visibleRect.intersects(noteRect)) continue;
                Shape shape2 = this.getItemShape(note);
                g.setColor(selCol);
                g.fill(noteRect);
                g.setColor(Color.RED);
                g.draw(shape2);
            }
        }
        if (this.newNote != null) {
            Rectangle noteRect = this.getItemBounds(this.newNote);
            Shape shape3 = this.getItemShape(this.newNote);
            g.setColor(selCol);
            g.fill(noteRect);
            g.setColor(Color.BLACK);
            g.draw(shape3);
        }
    }

    private Rectangle getItemBounds(Item it) {
        NoteEvent e = (NoteEvent)it;
        long tick = e.getStartTick();
        int x1 = (int)this.userToScreen(tick);
        int pitch = e.getNote();
        int y1 = this.pitchToScreen(pitch);
        if (!e.isDrumHit()) {
            long dur = e.getDuration();
            int w = (int)this.userToScreen(dur);
            if (w <= 6) {
                w = 6;
            }
            this.rectTmp.setBounds(x1, y1 + 1, w, this.noteItemHeight - 2);
        } else {
            int dd = this.noteItemHeight / 2 - 1;
            this.rectTmp.setBounds(x1 - dd, y1 + 1, 2 * dd, this.noteItemHeight - 2);
        }
        return this.rectTmp;
    }

    private Shape getItemShape(Item it) {
        NoteEvent e = (NoteEvent)it;
        long tick = e.getStartTick();
        int x1 = (int)this.userToScreen(tick);
        int pitch = e.getNote();
        int y1 = this.pitchToScreen(pitch);
        if (!e.isDrumHit()) {
            long dur = e.getDuration();
            int w = (int)this.userToScreen(dur);
            if (w == 0) {
                w = 1;
            }
            this.rectTmp.setBounds(x1, y1 + 1, w, this.noteItemHeight - 2);
            return this.rectTmp;
        }
        int dd = this.noteItemHeight / 2;
        int yc = y1 + dd;
        this.xp[0] = this.xp[2] = x1;
        this.xp[1] = x1 - --dd;
        this.xp[3] = x1 + dd;
        this.yp[0] = yc - dd;
        this.yp[2] = yc + dd;
        this.yp[1] = this.yp[3] = yc;
        return new Polygon(this.xp, this.yp, 4);
    }

    public void endDrag() {
        if (this.dragArmed) {
            this.dragArmed = false;
            return;
        }
        this.project.getDragList().endDrag(this.controlIsDown);
    }

    public void erase(Item it) {
        NoteEvent note = (NoteEvent)it;
        this.editHistory.mark(CurrentLocale.getMessage("sequencer.pianoroll.erase_note"));
        note.getPart().remove(note);
        this.editHistory.notifyEditHistoryListeners();
    }

    public void rightButtonPressedOnItem(int x, int y) {
        System.out.println(" Right button pressed (so what?) ");
    }

    public void feedBack(Item item) {
        this.audioFeedBack.select((NoteEvent)item);
    }

    public void clientAddToSelection(Item item) {
        this.project.getPartSelection().setFocus(((MultiEvent)item).getPart());
        this.project.getMultiEventSelection().addSelected((NoteEvent)item);
        this.project.getMultiEventSelection().notifyListeners();
    }

    public void clientRemoveFromSelection(Item item) {
        this.project.getMultiEventSelection().removeSelected((NoteEvent)item);
        this.project.getMultiEventSelection().notifyListeners();
    }

    public int getHoverStateAt(Point p) {
        Part focusPart = (Part)this.project.getPartSelection().getFocus();
        if (!(focusPart instanceof MidiPart)) {
            return 0;
        }
        int endTol = 20;
        int tol = 20;
        Iterable<MultiEvent> list = focusPart == null ? this.notesOnScreen : ((MidiPart)focusPart).getMultiEvents();
        for (MultiEvent e : list) {
            Rectangle rect;
            if (!(e instanceof NoteEvent) || !(rect = this.getItemBounds(e)).contains(p)) continue;
            if (((NoteEvent)e).isDrumHit()) {
                return 1;
            }
            if (rect.width < 100) {
                tol = rect.width / 3;
            }
            if (p.x - rect.x <= tol) {
                return 3;
            }
            if (rect.x + rect.width - p.x <= tol) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    void makeTools() {
        Cursor c = new Cursor(0);
        this.selectTool = new SelectTool(c);
        this.rectZoomTool = new RectZoomTool(c);
        this.writeTool = new WriteTool(MyCursors.getCursor("pencil"));
        this.eraseTool = new EraseTool(MyCursors.getCursor("eraser"));
        this.dragViewTool = new DragViewTool(MyCursors.getCursor("move"));
    }

    protected void paintImageImplLabel(Graphics2D graphics) {
    }

    public final boolean isValidEvent(MultiEvent event) {
        return event instanceof NoteEvent;
    }

    public void ignorePartWarp(boolean b) {
        WarpToPartLeftAction.ignoreWarp = b;
    }

    public synchronized void componentResized(ComponentEvent arg0) {
        super.componentResized(arg0);
        int extent = (int)this.getVisibleRect().getHeight();
        this.getYRangeModel().setExtent(extent);
    }

    public void selectAll() {
        Part focus = (Part)this.project.getPartSelection().getFocus();
        if (focus == null) {
            return;
        }
        Vector<MultiEvent> notes = new Vector<MultiEvent>();
        for (MultiEvent e : this.notesInFocus) {
            notes.add(e);
        }
        this.project.getMultiEventSelection().setSelected(notes);
        this.project.getMultiEventSelection().notifyListeners();
    }

    void setDrumWriteMode(boolean b) {
        this.drumWriteMode = b;
    }

    class DNoteShape
    extends Polygon
    implements NoteShape {
        DNoteShape() {
        }
    }

    class MNoteShape
    extends Rectangle
    implements NoteShape {
        MNoteShape() {
        }
    }

    static interface NoteShape
    extends Shape {
    }
}

