/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.pianoroll;

import com.frinika.sequencer.gui.Layout;
import com.frinika.sequencer.gui.pianoroll.PianoRoll;
import com.frinika.sequencer.gui.selection.SelectionContainer;
import com.frinika.sequencer.gui.selection.SelectionListener;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.Part;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PadPanel
extends JPanel
implements MouseListener,
AdjustmentListener,
SelectionListener<Part> {
    private static final long serialVersionUID = 1L;
    final int ON = 0;
    final int OFF = 1;
    final int nNote = 127;
    protected Key[] keys = new Key[127];
    Key prevKey;
    int lastKeyPress = 0;
    PianoRoll pianoRoll;
    int timePanelHeight;
    final int keyDepth = 50;
    int yScroll;
    int yBot;
    PadPanelIF padIF;
    PadPanelIF pianoPad;
    PadPanelIF drumPad;
    MidiLane midiLane;
    static Color MY_PIANO_COLOR = new Color(0xFFEEEE);
    static Color MY_DRUM_COLOR = new Color(0xEEEEFF);
    static Color MY_KEYDOWN_COLOR = new Color(0xAAAAAA);

    public PadPanel(PianoRoll pr, int top, int scroll) {
        this.pianoRoll = pr;
        this.timePanelHeight = top;
        this.yScroll = scroll;
        this.addMouseListener(this);
        this.pianoPad = new VirtualPiano();
        this.drumPad = new DrumPad();
        this.yBot = 129 * Layout.getNoteItemHeight();
        this.setSize(new Dimension(50, this.yBot));
        this.setPreferredSize(new Dimension(50, this.yBot));
        this.setMaximumSize(new Dimension(50, 20000));
    }

    public Key createkey(int x, int y, int width, int height, int num) {
        return new Key(x, y, width, height, num);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.padIF != null) {
            this.padIF.paintComponent(g);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.yScroll = e.getValue();
        this.repaint();
    }

    public int getLastKeytPress() {
        return this.lastKeyPress;
    }

    public Key getKey(int i) {
        return this.keys[i];
    }

    protected Key getKey(Point p) {
        return this.padIF.getKey(p);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.prevKey = this.getKey(e.getPoint());
        if (this.prevKey != null) {
            this.prevKey.on();
            this.repaint();
        }
        if (e.getButton() == 3 && this.midiLane.isDrumLane()) {
            this.popupMapper(e.getX(), e.getY(), this.prevKey);
        }
    }

    void popupMapper(int x, int y, final Key key) {
        JPopupMenu menu = new JPopupMenu();
        Font plain = this.getGraphics().getFont();
        Font small = new Font(plain.getFamily(), 0, 9);
        menu.setFont(small);
        boolean count = false;
        String[] keyNames = this.midiLane.getKeyNames();
        class XXX {
            String name;
            int key;

            public XXX(int i, String string) {
                this.key = i;
                this.name = string;
            }

            public String toString() {
                return this.name;
            }
        }
        Vector<XXX> vec = new Vector<XXX>();
        XXX xx = null;
        XXX zz = null;
        for (int i = 0; i < keyNames.length; ++i) {
            if (keyNames[i] != null) {
                zz = new XXX(i, keyNames[i]);
                vec.add(0, zz);
            }
            if (i != key.kNum) continue;
            xx = zz;
        }
        final JList list = new JList(vec);
        list.setSelectionMode(0);
        list.setSelectedValue(xx, true);
        list.addListSelectionListener(new ListSelectionListener(){
            int zzz = -1;

            public void valueChanged(ListSelectionEvent e) {
                int jj = ((XXX)list.getSelectedValue()).key;
                PadPanel.this.midiLane.setDrumMapping(key.kNum, jj);
                if (this.zzz != jj) {
                    key.on();
                } else {
                    key.off();
                }
                this.zzz = jj;
            }
        });
        JScrollPane listScroller = new JScrollPane(list);
        listScroller.setPreferredSize(new Dimension(200, 800));
        JFrame frame = new JFrame();
        frame.setContentPane(listScroller);
        frame.pack();
        frame.setVisible(true);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.prevKey != null) {
            this.prevKey.off();
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.prevKey != null) {
            this.prevKey.off();
            this.repaint();
            this.prevKey = null;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void selectionChanged(SelectionContainer<? extends Part> src) {
        Part focus = (Part)this.pianoRoll.getProjectContainer().getPartSelection().getFocus();
        if (focus == null) {
            return;
        }
        if (!(focus instanceof MidiPart)) {
            return;
        }
        this.midiLane = (MidiLane)focus.getLane();
        if (this.midiLane.isDrumLane()) {
            if (this.padIF != this.drumPad) {
                this.padIF = this.drumPad;
                this.padIF.resizeKeys();
            }
        } else if (this.padIF != this.pianoPad) {
            this.padIF = this.pianoPad;
            this.padIF.resizeKeys();
        }
        this.validate();
        this.repaint();
    }

    class VirtualPiano
    implements PadPanelIF {
        Vector<Key> blackKeys = new Vector();
        Vector<Key> whiteKeys = new Vector();
        final int nWhiteNote = 75;
        final int nOctave = 11;
        int whiteKeyWidth;
        int blackKeyDepth = 30;
        int blackWhiteGap;
        int noteItemHeight;

        VirtualPiano() {
        }

        public void resizeKeys() {
            int keyNum;
            this.blackKeys.clear();
            this.whiteKeys.clear();
            this.noteItemHeight = Layout.getNoteItemHeight();
            this.whiteKeyWidth = this.noteItemHeight * 12 / 7;
            this.blackWhiteGap = this.whiteKeyWidth / 3;
            int[] whiteIDs = new int[]{0, 2, 4, 5, 7, 9, 11};
            PadPanel.this.yBot = 129 * this.noteItemHeight - this.whiteKeyWidth;
            int y = 0;
            for (int i = 0; i < 11; ++i) {
                int keyNum2;
                int j = 0;
                while (j < 7 && (keyNum2 = i * 12 + whiteIDs[j]) < 127) {
                    this.whiteKeys.add(new Key(0, PadPanel.this.yBot - y, 50, this.whiteKeyWidth, keyNum2));
                    ++j;
                    y += this.whiteKeyWidth;
                }
            }
            int halfGap = this.blackWhiteGap / 2;
            int yBot1 = PadPanel.this.yBot + 7 * this.whiteKeyWidth / 8;
            int blackKeyWidth = 2 * this.whiteKeyWidth / 3;
            int i = 0;
            int y2 = 0;
            while (i < 11 && (keyNum = i * 12) < 126) {
                this.blackKeys.add(new Key(0, yBot1 - (y2 += this.whiteKeyWidth) - halfGap / 2, this.blackKeyDepth, blackKeyWidth, keyNum + 1));
                if (keyNum >= 124) break;
                this.blackKeys.add(new Key(0, yBot1 - (y2 += this.whiteKeyWidth) - 3 * halfGap / 2, this.blackKeyDepth, blackKeyWidth, keyNum + 3));
                if (keyNum >= 121) break;
                y2 += this.whiteKeyWidth;
                this.blackKeys.add(new Key(0, yBot1 - (y2 += this.whiteKeyWidth) - halfGap / 2 + 1, this.blackKeyDepth, blackKeyWidth, keyNum + 6));
                if (keyNum >= 119) break;
                this.blackKeys.add(new Key(0, yBot1 - (y2 += this.whiteKeyWidth) - halfGap, this.blackKeyDepth, blackKeyWidth, keyNum + 8));
                if (keyNum >= 117) break;
                this.blackKeys.add(new Key(0, yBot1 - (y2 += this.whiteKeyWidth) - 3 * halfGap / 2 - 1, this.blackKeyDepth, blackKeyWidth, keyNum + 10));
                ++i;
                y2 += this.whiteKeyWidth;
            }
            Iterator<Key> i$ = this.blackKeys.iterator();
            while (i$.hasNext()) {
                Key key;
                PadPanel.this.keys[key.kNum] = key = i$.next();
            }
            i$ = this.whiteKeys.iterator();
            while (i$.hasNext()) {
                Key key;
                PadPanel.this.keys[key.kNum] = key = i$.next();
            }
        }

        public void paintComponent(Graphics g) {
            Key key;
            int i;
            if (this.noteItemHeight != Layout.getNoteItemHeight()) {
                this.resizeKeys();
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.translate(0, PadPanel.this.timePanelHeight - PadPanel.this.yScroll);
            g2.setColor(MY_PIANO_COLOR);
            g2.fillRect(0, 0, 50, PadPanel.this.yBot);
            for (i = 0; i < this.whiteKeys.size(); ++i) {
                key = this.whiteKeys.get(i);
                if (key.isNoteOn()) {
                    g2.setColor(MY_KEYDOWN_COLOR);
                    g2.fill(key);
                }
                g2.setColor(Color.black);
                g2.draw(key);
                if (key.kNum % 12 != 0) continue;
                g2.setColor(Color.BLACK);
                g2.drawString(String.valueOf(key.kNum / 12), 35, key.y + key.height - 1);
            }
            for (i = 0; i < this.blackKeys.size(); ++i) {
                key = this.blackKeys.get(i);
                if (key.isNoteOn()) {
                    g2.setColor(MY_KEYDOWN_COLOR);
                    g2.fill(key);
                    g2.setColor(Color.black);
                    g2.draw(key);
                    continue;
                }
                g2.setColor(Color.black);
                g2.fill(key);
            }
            g2.translate(0, -(PadPanel.this.timePanelHeight - PadPanel.this.yScroll));
        }

        public Key getKey(Point point) {
            point.translate(0, -PadPanel.this.timePanelHeight + PadPanel.this.yScroll);
            for (Key key : this.blackKeys) {
                if (key == null || !key.contains(point)) continue;
                return key;
            }
            for (Key key : this.whiteKeys) {
                if (key == null || !key.contains(point)) continue;
                return key;
            }
            return null;
        }
    }

    class DrumPad
    implements PadPanelIF {
        private static final long serialVersionUID = 1L;
        int noteItemHeight;

        DrumPad() {
        }

        public void resizeKeys() {
            this.noteItemHeight = Layout.getNoteItemHeight();
            PadPanel.this.yBot = 128 * this.noteItemHeight;
            int y = 0;
            int j = 0;
            while (j < 127) {
                PadPanel.this.keys[j] = PadPanel.this.createkey(0, PadPanel.this.yBot - y, 50, this.noteItemHeight, j);
                ++j;
                y += this.noteItemHeight;
            }
            PadPanel.this.validate();
        }

        public void paintComponent(Graphics g) {
            if (this.noteItemHeight != Layout.getNoteItemHeight()) {
                this.resizeKeys();
            }
            String[] keyNames = PadPanel.this.midiLane.getKeyNames();
            Font plain = g.getFont();
            Font small = new Font(plain.getFamily(), 0, 9);
            Graphics2D g2 = (Graphics2D)g;
            g2.setFont(small);
            g2.translate(0, PadPanel.this.timePanelHeight - PadPanel.this.yScroll);
            g2.setColor(MY_DRUM_COLOR);
            g2.fillRect(0, 0, 50, PadPanel.this.yBot);
            for (int i = 0; i < PadPanel.this.keys.length; ++i) {
                Key key = PadPanel.this.keys[i];
                if (key.isNoteOn()) {
                    g2.setColor(MY_KEYDOWN_COLOR);
                    g2.fill(key);
                }
                int kk = PadPanel.this.midiLane.mapNote(i);
                g2.setColor(Color.black);
                g2.draw(key);
                if (keyNames == null || kk >= keyNames.length || keyNames[kk] == null) continue;
                if (kk != i) {
                    g2.setColor(Color.red);
                }
                g2.drawString(keyNames[kk], key.x + 2, key.y + this.noteItemHeight - 2);
            }
            g2.translate(0, -(PadPanel.this.timePanelHeight - PadPanel.this.yScroll));
        }

        public Key getKey(Point point) {
            point.translate(0, -PadPanel.this.timePanelHeight + PadPanel.this.yScroll);
            for (Key key : PadPanel.this.keys) {
                if (key == null || !key.contains(point)) continue;
                return key;
            }
            return null;
        }
    }

    static interface PadPanelIF {
        public void resizeKeys();

        public void paintComponent(Graphics var1);

        public Key getKey(Point var1);
    }

    public class Key
    extends Rectangle {
        private static final long serialVersionUID = 1L;
        Receiver recv;
        int chan;
        int noteState;
        int kNum;

        public Key(int x, int y, int width, int height, int num) {
            super(x, y, width, height);
            this.recv = null;
            this.chan = 0;
            this.noteState = 1;
            this.kNum = num;
        }

        public boolean isNoteOn() {
            return this.noteState == 0;
        }

        public void on() {
            this.setNoteState(0);
            if (PadPanel.this.pianoRoll == null) {
                return;
            }
            this.recv = PadPanel.this.midiLane.getReceiver();
            this.chan = PadPanel.this.midiLane.getMidiChannel();
            if (this.recv == null) {
                return;
            }
            ShortMessage shm = new ShortMessage();
            int kk = PadPanel.this.midiLane.mapNote(this.kNum);
            try {
                shm.setMessage(144, this.chan, kk, 100);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
            this.recv.send(shm, -1L);
        }

        public void off() {
            this.setNoteState(1);
            if (this.recv == null) {
                return;
            }
            ShortMessage shm = new ShortMessage();
            int kk = PadPanel.this.midiLane.mapNote(this.kNum);
            try {
                shm.setMessage(144, this.chan, kk, 0);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
            this.recv.send(shm, -1L);
            this.recv = null;
        }

        public void setNoteState(int state) {
            this.noteState = state;
            if (state == 0) {
                PadPanel.this.lastKeyPress = this.kNum;
            }
        }
    }
}

