/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.pianoroll;

import com.frinika.localization.CurrentLocale;
import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.gui.MyAbstractTableModel;
import com.frinika.sequencer.gui.menu.midi.MidiStepRecordAction;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.MultiEventChangeRecorder;
import com.frinika.sequencer.model.NoteEvent;
import com.frinika.sequencer.model.util.TimeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiEventTableModel
extends MyAbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final String[] noteColumnNames = new String[]{"Time", "Note", "Vel", "Len"};
    private static final String[] cntrlColumnNames = new String[]{"Time", "N.A.", "Value", "N.A."};
    static final int COLUMN_TIME = 0;
    static final int COLUMN_NOTEORCC = 1;
    static final int COLUMN_VELORVAL = 2;
    static final int COLUMN_LEN = 3;
    static final int COLUMNS = noteColumnNames.length;
    MultiEvent event;
    long startTick;
    int ticksPerBeat;
    int quantize;
    TimeUtils time;

    public MultiEventTableModel(ProjectContainer project, MultiEvent note, int quantize, int ticksPerBeat) {
        this.event = note;
        this.quantize = quantize;
        this.ticksPerBeat = ticksPerBeat;
        this.time = new TimeUtils(project);
    }

    void setMultiEvent(MultiEvent ev) {
        this.event = ev;
    }

    @Override
    public int getRowCount() {
        return 1;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Double.class;
            }
            case 3: {
                return Double.class;
            }
        }
        return Integer.class;
    }

    @Override
    public String getColumnName(int column) {
        if (this.event instanceof NoteEvent) {
            return noteColumnNames[column];
        }
        return cntrlColumnNames[column];
    }

    @Override
    public int getColumnCount() {
        return COLUMNS;
    }

    @Override
    public int getColumnWidth(int column) {
        switch (column) {
            case 0: {
                return 8;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 7;
            }
        }
        return 10;
    }

    @Override
    public Object getValueAt(int row, int columnIndex) {
        if (this.event == null) {
            return "null";
        }
        switch (columnIndex) {
            case 0: {
                return this.time.tickToBarBeatTick(this.event.getStartTick());
            }
            case 2: {
                return this.event.getValueUI();
            }
        }
        if (this.event instanceof NoteEvent) {
            return this.getNoteValueAt(row, columnIndex);
        }
        return null;
    }

    public Object getNoteValueAt(int row, int columnIndex) {
        NoteEvent ne = (NoteEvent)this.event;
        if (this.event == null) {
            System.out.println("NULL EVENT");
            return null;
        }
        switch (columnIndex) {
            case 1: {
                return ne.getNoteName();
            }
            case 3: {
                return this.time.tickToBarBeatTick(ne.getDuration());
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object obj, int row, int columnIndex) {
        if (this.event == null) {
            return;
        }
        assert (obj instanceof String);
        final String string = (String)obj;
        switch (columnIndex) {
            case 0: {
                final long newTick = this.time.barBeatTickToTick(string);
                new MultiEventChangeRecorder(CurrentLocale.getMessage("sequencer.eventview.move"), this.event){

                    public void doChange(MultiEvent me) {
                        MultiEventTableModel.this.event.setStartTick(newTick);
                    }
                };
                break;
            }
            case 2: {
                new MultiEventChangeRecorder(CurrentLocale.getMessage("sequencer.eventview.adjust_velocity"), this.event){

                    public void doChange(MultiEvent event) {
                        event.setValueUI(Integer.parseInt(string));
                    }
                };
                break;
            }
            case 3: {
                if (!(this.event instanceof NoteEvent)) {
                    return;
                }
                NoteEvent me = (NoteEvent)this.event;
                new MultiEventChangeRecorder(CurrentLocale.getMessage("sequencer.change_duration"), me){

                    public void doChange(MultiEvent e) {
                        ((NoteEvent)e).setDuration(MultiEventTableModel.this.time.barBeatTickToTick(string));
                    }
                };
                break;
            }
            case 1: {
                if (!(this.event instanceof NoteEvent)) {
                    return;
                }
                NoteEvent me = (NoteEvent)this.event;
                new MultiEventChangeRecorder(CurrentLocale.getMessage("sequencer.eventview.adjust_pitch"), me){

                    public void doChange(MultiEvent e) {
                        ((NoteEvent)e).setNote(MidiStepRecordAction.parseNote(string));
                    }
                };
            }
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }
}

